/* $Id: upper.c 639 2005-11-21 04:43:14Z bruce $ */
/* str/upper.c - Translate a string into uppercase
 * Copyright (C) 2001,2005  Bruce Guenter <bruce@untroubled.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301 USA
 */
#include <ctype.h>
#include "str.h"

/** Translate all lower-case characters to upper-case */
void str_upper(str* s)
{
  char* ptr;
  unsigned i;
  for (i = 0, ptr = s->s; i < s->len; ++i, ++ptr)
    if (islower(*ptr)) *ptr = toupper(*ptr);
}
