/*
** Copyright (C) 2003-2006 Teus Benschop.
**  
** This program is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation; either version 2 of the License, or
** (at your option) any later version.
**  
** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU General Public License for more details.
**  
** You should have received a copy of the GNU General Public License
** along with this program; if not, write to the Free Software
** Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
**  
*/


#include "utilities.h"
#include "dialogshowscript.h"
#include <glib.h>
#include "constants.h"
#include "directories.h"
#include "gwrappers.h"
#include "help.h"


ustring logfile_get_filename ()
{
  return gw_build_filename (directories_get_temp(), "bibledit.log");
}


ShowScriptDialog::ShowScriptDialog (int dummy)
{
  // Build gui.
  showscriptdialog = gtk_dialog_new ();
  gtk_window_set_title (GTK_WINDOW (showscriptdialog), "Contents");
  gtk_window_set_position (GTK_WINDOW (showscriptdialog), GTK_WIN_POS_CENTER_ON_PARENT);
  gtk_window_set_modal (GTK_WINDOW (showscriptdialog), TRUE);
  gtk_window_set_default_size (GTK_WINDOW (showscriptdialog), 640, 480);
  gtk_window_set_type_hint (GTK_WINDOW (showscriptdialog), GDK_WINDOW_TYPE_HINT_DIALOG);

  dialog_vbox1 = GTK_DIALOG (showscriptdialog)->vbox;
  gtk_widget_show (dialog_vbox1);

  vbox1 = gtk_vbox_new (FALSE, 0);
  gtk_widget_show (vbox1);
  gtk_box_pack_start (GTK_BOX (dialog_vbox1), vbox1, TRUE, TRUE, 0);

  scrolledwindow1 = gtk_scrolled_window_new (NULL, NULL);
  gtk_widget_show (scrolledwindow1);
  gtk_box_pack_start (GTK_BOX (vbox1), scrolledwindow1, TRUE, TRUE, 0);
  gtk_scrolled_window_set_policy (GTK_SCROLLED_WINDOW (scrolledwindow1), GTK_POLICY_AUTOMATIC, GTK_POLICY_AUTOMATIC);

  textview1 = gtk_text_view_new ();
  gtk_widget_show (textview1);
  gtk_container_add (GTK_CONTAINER (scrolledwindow1), textview1);
  gtk_text_view_set_editable (GTK_TEXT_VIEW (textview1), FALSE);

  checkbutton1 = gtk_check_button_new_with_mnemonic ("Show _previous session");
  gtk_widget_show (checkbutton1);
  gtk_box_pack_start (GTK_BOX (vbox1), checkbutton1, FALSE, FALSE, 0);

  dialog_action_area1 = GTK_DIALOG (showscriptdialog)->action_area;
  gtk_widget_show (dialog_action_area1);
  gtk_button_box_set_layout (GTK_BUTTON_BOX (dialog_action_area1), GTK_BUTTONBOX_END);

  help_button (dialog_action_area1, NULL, NULL);

  cancelbutton = gtk_button_new_from_stock ("gtk-cancel");
  gtk_widget_show (cancelbutton);
  gtk_dialog_add_action_widget (GTK_DIALOG (showscriptdialog), cancelbutton, GTK_RESPONSE_CANCEL);
  GTK_WIDGET_SET_FLAGS (cancelbutton, GTK_CAN_DEFAULT);

  g_signal_connect ((gpointer) checkbutton1, "toggled", G_CALLBACK (on_checkbutton1_toggled), gpointer(this));

  gtk_widget_grab_focus (textview1);
  gtk_widget_grab_default (cancelbutton);

  // Load the text.
  load();
  
  // Keep loading the text repeatedly so as to show recent changes also.
  event_source_id = g_timeout_add_full (G_PRIORITY_DEFAULT, 500, GSourceFunc (show_script_dialog_load), gpointer(this), NULL);
}


ShowScriptDialog::~ShowScriptDialog ()
{
  // Destroy the source of the timeout (bibledit crashes if this is not done).
  GSource *source;
  source = g_main_context_find_source_by_id (NULL, event_source_id);
  if (source)
    g_source_destroy (source);
  // Get rid of the dialog.
  gtk_widget_destroy (showscriptdialog);
}


int ShowScriptDialog::run()
{
  return gtk_dialog_run (GTK_DIALOG (showscriptdialog));
}


bool ShowScriptDialog::show_script_dialog_load (gpointer data)
{
  return ((ShowScriptDialog *) data)->load();
}


bool ShowScriptDialog::load () 
{
  // Insert the text from the file.
  gchar *contents;
  if (gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON (checkbutton1))) {
    ustring filename = logfile_get_filename() + ".old";
    g_file_get_contents (filename.c_str(), &contents, NULL, NULL);
  }
  else
    g_file_get_contents (logfile_get_filename().c_str(), &contents, NULL, NULL);
  // Only insert the text if new text is available on disk.
  GtkTextIter begin;
  gtk_text_buffer_get_start_iter (gtk_text_view_get_buffer (GTK_TEXT_VIEW (textview1)), &begin);
  GtkTextIter end;
  gtk_text_buffer_get_end_iter (gtk_text_view_get_buffer (GTK_TEXT_VIEW (textview1)), &end);
  if (g_ascii_strcasecmp (contents, gtk_text_buffer_get_text (gtk_text_view_get_buffer (GTK_TEXT_VIEW (textview1)), &begin, &end, false)) != 0) {
    gtk_text_buffer_set_text (gtk_text_view_get_buffer (GTK_TEXT_VIEW (textview1)), contents, -1);
    // Scroll to end;
    while (gtk_events_pending()) gtk_main_iteration ();
    GtkTextIter end;
    gtk_text_buffer_get_end_iter (gtk_text_view_get_buffer (GTK_TEXT_VIEW (textview1)), &end);
    gtk_text_view_scroll_to_iter (GTK_TEXT_VIEW (textview1), &end, 0, true, 0, 0);
  }
  g_free (contents);
  // Do it again next time.
  return true;
}


void ShowScriptDialog::on_checkbutton1_toggled (GtkToggleButton *togglebutton, gpointer user_data)
{
  ((ShowScriptDialog *) user_data)->on_checkbutton1 ();
}


void ShowScriptDialog::on_checkbutton1 ()
{
  load ();
}
