/*
** Copyright (C) 2003-2006 Teus Benschop.
**  
** This program is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation; either version 2 of the License, or
** (at your option) any later version.
**  
** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU General Public License for more details.
**  
** You should have received a copy of the GNU General Public License
** along with this program; if not, write to the Free Software
** Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
**  
*/


#ifndef INCLUDED_HIGHLIGHT_H
#define INCLUDED_HIGHLIGHT_H


#include "libraries.h"
#include <glib.h>
#include <gtk/gtk.h>


class Highlight
{
public:
  Highlight (GtkTextBuffer * buffer, GtkWidget * textview);
  ~Highlight ();
  void line_at_cursor (GtkTextTag * tag);
  void searchwords (GtkTextTag * tag, const ustring& verse);
  GtkTextTag * get_tag (const ustring& tagname);
private:
  GtkTextBuffer * mybuffer;
  GtkTextView * mytextview_edit;
  void searchwords_find_slow (GtkTextIter * beginbound, GtkTextIter * endbound,
                              const ustring & searchword,
                              bool casesensitive, bool globbing, bool matchbegin, bool matchend,
                              vector <GtkTextIter>& wordstart, vector<GtkTextIter>& wordend);
  void searchwords_find_fast (GtkTextIter * beginbound, GtkTextIter * endbound,
                              const ustring & searchword, bool casesensitive,
                              vector <GtkTextIter>& wordstart, vector<GtkTextIter>& wordend);
  void searchwords_highlight (vector <GtkTextIter>& start, vector<GtkTextIter>& end,
                              bool& cursor_set, GtkTextTag * tag);
  void searchwords_in_area (vector <GtkTextIter>& start, vector<GtkTextIter>& end,
                            bool area_id, bool area_intro, bool area_heading, bool area_chapter, 
                            bool area_study, bool area_notes, bool area_xref, bool area_verse); 
};



#endif
