/*
** Copyright (C) 2003-2006 Teus Benschop.
**  
** This program is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation; either version 2 of the License, or
** (at your option) any later version.
**  
** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU General Public License for more details.
**  
** You should have received a copy of the GNU General Public License
** along with this program; if not, write to the Free Software
** Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
**  
*/


#ifndef INCLUDED_PRINTPROJECT_H
#define INCLUDED_PRINTPROJECT_H


#include <gtk/gtk.h>
#include "ustring.h"
#include "progresswindow.h"
#include "generalconfig.h"
#include "projectconfig.h"
#include "usfm.h"
#include "xslfofootnote.h"
#include "xslfoendnote.h"
#include "xslfoxref.h"
#include "usfm-inline-markers.h"
#include "scripture_reordered.h"


class PrintProject
{
public:
  PrintProject (ProgressWindow * progresswindow);
  ~PrintProject ();
  void print ();
private:
  ProgressWindow * myprogresswindow;
  GeneralConfiguration genconfig;
  ProjectConfiguration projectconfig;
  Usfm usfm;
  ScriptureReordered * scripture_reordered;
  UsfmInlineMarkers * usfm_inline_markers;
  XslFoFootnote * xslfofootnote;
  XslFoEndnote * xslfoendnote;
  XslFoXref * xslfoxref;
  XmlFoBlock * myxmlfoblock;
  vector<ustring> xslfo_lines;
  vector<ustring> running_headers_anchor;
  bool portion_print;
  unsigned int portion_chapter_from, portion_chapter_to;
  ustring portion_verse_from, portion_verse_to;
  unsigned int chaptercount;
  vector<ustring> running_headers;
  vector<ustring> table_of_contents_texts;
  vector<ustring> table_of_contents_identifiers;
  unsigned int id_page_break_count;
  void format_general (vector <ustring>& lines, bool spancolumns);
  void cover_page ();
  void headers_insert_anchor (unsigned int index);
  void table_of_contents_running_headers_prepare ();
  void table_of_contents_insert_body ();
  void table_of_contents_insert_anchor ();
  void picture (const ustring& marker, const ustring& line);
  unsigned int get_last_paragraph_before_verse (unsigned int currentline, vector <ustring>& lines);
};





#endif
