/*
** Copyright (C) 2003-2006 Teus Benschop.
**  
** This program is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation; either version 2 of the License, or
** (at your option) any later version.
**  
** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU General Public License for more details.
**  
** You should have received a copy of the GNU General Public License
** along with this program; if not, write to the Free Software
** Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
**  
*/


#include "scripture_reordered.h"
#include "projectutils.h"
#include "projectconfig.h"
#include "books.h"


ScriptureReordered::ScriptureReordered (const ustring& project)
// This object encapsulates a reordered Scripture.
{
  myproject = project;
  reordering_read ();
  vector<unsigned int> scripture_books = project_get_books (project);
  for (unsigned int i = 0; i < reordered_books.size(); i++) {
    for (unsigned int i2 = 0; i2 < scripture_books.size(); i2++) {
      if (reordered_books[i] == books_id_to_english (scripture_books[i2])) {
        if (reordered_includes[i]) {
          books.push_back (reordered_books[i]);
          portions.push_back (reordered_portions[i]);
        }
      }
    }
  }  
}


void ScriptureReordered::reordering_read ()
/*
Reads reordering information from disk.

If the amount of settings on disk changes, it includes all bits.
*/
{
  // Load scripture.
  vector <ustring> scripture_books;
  { 
    vector <unsigned int> s = project_get_books (myproject);
    for (unsigned int i = 0; i < s.size(); i++)
      scripture_books.push_back (books_id_to_english (s[i]));
  }
  
  // Read the reordering information.
  ProjectConfiguration projectconfig (myproject);
  reordered_books = projectconfig.reordered_books ();
  reordered_includes = projectconfig.reordered_includes ();
  reordered_portions = projectconfig.reordered_portions ();

  // See if the amount of books is still the same. If not, reset the whole 
  // thing.
  bool reset = false;
  if (scripture_books.size() != reordered_books.size()) reset = true;
  if (scripture_books.size() != reordered_includes.size()) reset = true;
  if (scripture_books.size() != reordered_portions.size()) reset = true;

  // No reset: we're through.
  if (!reset) return;
  
  // Reset: include everything.
  reordered_books.clear();
  reordered_includes.clear();
  reordered_portions.clear();
  for (unsigned int i = 0; i < scripture_books.size(); i++) {
    reordered_books.push_back(scripture_books[i]);
    reordered_includes.push_back(true);
    reordered_portions.push_back(CHAPTER_VERSE_SELECTION_ALL);
  }
}


bool ScriptureReordered::reordering_portions_all ()
// Indicates whether all books have their portions set to "all"  and are included.
{
  for (unsigned int i = 0; i < reordered_includes.size(); i++)
    if (!reordered_includes[i])
      return false;
  for (unsigned int i = 0; i < reordered_portions.size(); i++)
    if (reordered_portions[i] != CHAPTER_VERSE_SELECTION_ALL)
      return false;
  return true;
}
