;*=====================================================================*/
;*    serrano/prgm/project/bigloo/api/sqlite/recette/recette.scm       */
;*    -------------------------------------------------------------    */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Mon Feb  4 14:28:58 2002                          */
;*    Last change :  Thu Nov 10 15:45:17 2005 (serrano)                */
;*    Copyright   :  2002-05 Manuel Serrano                            */
;*    -------------------------------------------------------------    */
;*    A test module that deploys the examples of SRFI18.               */
;*=====================================================================*/

;*---------------------------------------------------------------------*/
;*    The module                                                       */
;*---------------------------------------------------------------------*/
(module recette
   (library sqlite)
   (main    main))

;*---------------------------------------------------------------------*/
;*    err ...                                                          */
;*---------------------------------------------------------------------*/
(define (err . msg)
   (with-output-to-port (current-error-port)
      (lambda ()
	 (for-each write msg)
	 (newline))))

;*---------------------------------------------------------------------*/
;*    do-something-else ...                                            */
;*---------------------------------------------------------------------*/
(define (do-something-else)
   #unspecified)

;*---------------------------------------------------------------------*/
;*    *tests* ...                                                      */
;*---------------------------------------------------------------------*/
(define *tests* '())

;*---------------------------------------------------------------------*/
;*    *failure* and *success* ...                                      */
;*---------------------------------------------------------------------*/
(define *failure* '())
(define *success* 0)

;*---------------------------------------------------------------------*/
;*    test ...                                                         */
;*---------------------------------------------------------------------*/
(define (test name prgm::procedure res)
   (display* name "...")
   (flush-output-port (current-output-port))
   (let ((provided (with-exception-handler
		      (lambda (e)
			 (error-notify e)
			 (vector res))
		      prgm)))
      (if (or (eq? res #unspecified)
	      (and (procedure? res) (res provided))
	      (equal? res provided))
	  (begin
	     (set! *success* (+fx 1 *success*))
	     (print "ok."))
	  (begin
	     (set! *failure* (cons name *failure*))
	     (print "error.")
	     (print "   ==> provided: [" provided
		    "]\n       expected: ["
		    (if (procedure? res) (res 'result) res)
		    "]")))))

;*---------------------------------------------------------------------*/
;*    define-test ...                                                  */
;*---------------------------------------------------------------------*/
(define-macro (define-test id prgm . rest)
   (let ((t (match-case rest
	       ((:result ?result)
		`(list ',id (lambda () ,prgm) ,result))
	       (()
		`(list ',id (lambda () ,prgm) #unspecified))
	       (else
		(error "define-test" "Illegal rest argument" rest)))))
      `(set! *tests* (cons ,t *tests*))))

;*---------------------------------------------------------------------*/
;*    cond-expand ...                                                  */
;*---------------------------------------------------------------------*/
(define-test cond-expand
   (cond-expand
      (sqlite #t)
      (else #f))
   :result #t)

;*---------------------------------------------------------------------*/
;*    *db* ...                                                         */
;*---------------------------------------------------------------------*/
(define *db* #unspecified)

;*---------------------------------------------------------------------*/
;*    create-db ...                                                    */
;*---------------------------------------------------------------------*/
(define-test create-db
   (begin
      (when (file-exists? "test.db") (delete-file "test.db"))
      (set! *db* (instantiate::sqlite (path "test.db")))
      *db*)
   :result (lambda (v)
	      (sqlite? *db*)))

;*---------------------------------------------------------------------*/
;*    create-table ...                                                 */
;*---------------------------------------------------------------------*/
(define-test create-table
   (sqlite-exec *db* "CREATE TABLE foo (x INTEGER, y INTEGER)"))

;*---------------------------------------------------------------------*/
;*    insert ...                                                       */
;*---------------------------------------------------------------------*/
(define-test insert
   (for-each (lambda (x)
		(sqlite-exec *db*  "INSERT INTO foo VALUES(~A, ~A)" x (* x x)))
	     (iota 10)))

;*---------------------------------------------------------------------*/
;*    select ...                                                       */
;*---------------------------------------------------------------------*/
(define-test select
   (sqlite-exec *db* "SELECT * FROM foo")
   :result '(#("0" "0")
	     #("1" "1")
	     #("2" "4")
	     #("3" "9")
	     #("4" "16")
	     #("5" "25")
	     #("6" "36")
	     #("7" "49")
	     #("8" "64")
	     #("9" "81")))

;*---------------------------------------------------------------------*/
;*    select2 ...                                                      */
;*---------------------------------------------------------------------*/
(define-test select2
   (sqlite-exec *db* "SELECT y,x FROM foo WHERE y > 50")
   :result '(#("64" "8")
	     #("81" "9")))

;*---------------------------------------------------------------------*/
;*    close ...                                                        */
;*---------------------------------------------------------------------*/
(define-test close
   (sqlite-close *db*))

;*---------------------------------------------------------------------*/
;*    main ...                                                         */
;*---------------------------------------------------------------------*/
(define (main argv)
   (let ((tests '()))
      (args-parse (cdr argv)
	 ((("-h" "--help") (help "This help message"))
	  (args-parse-usage #f)
	  (exit 0))
	 (else
	  (set! tests (cons (string->symbol else) tests))))
      ;; run all the tests
      (for-each (lambda (pvn)
		   (apply test pvn))
		(if (null? tests)
		    (reverse *tests*)
		    (reverse (filter (lambda (t) (memq (car t) tests))
				     *tests*))))
      ;; if we reach that point, we are done
      (print "\n"
	     (if (null? tests) "All" (reverse tests))
	     " tests executed...\n"
	     (if (null? *failure*)
		 "all succeeded"
		 (format " ~a succeeded\n ~a failed ~a"
			 *success*
			 (length *failure*)
			 (reverse *failure*))))))


   

