;*=====================================================================*/
;*    serrano/prgm/project/bigloo/runtime/Eval/evobject.scm            */
;*    -------------------------------------------------------------    */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Sat Jan 14 17:11:54 2006                          */
;*    Last change :  Sat Aug 12 15:41:05 2006 (serrano)                */
;*    Copyright   :  2006 Manuel Serrano                               */
;*    -------------------------------------------------------------    */
;*    Eval class definition                                            */
;*=====================================================================*/

;*---------------------------------------------------------------------*/
;*    The module                                                       */
;*---------------------------------------------------------------------*/
(module __evobject

   (import  __type
	    __error
	    __bigloo
	    __tvector
	    __structure
	    __tvector
	    __bexit
	    __os
	    __bit
	    __param
	    __object
	    
	    __r4_numbers_6_5
	    __r4_numbers_6_5_fixnum
	    __r4_numbers_6_5_flonum
	    __r4_characters_6_6
	    __r4_equivalence_6_2
	    __r4_booleans_6_1
	    __r4_symbols_6_4
	    __r4_strings_6_7
	    __r4_pairs_and_lists_6_3
	    __r4_input_6_10_2
	    __r4_control_features_6_9
	    __r4_vectors_6_8
	    __r4_ports_6_10_1
	    __r4_output_6_10_3
	    
	    __r5_control_features_6_4
	    
	    __progn
	    __evenv
	    __everror
	    __evcompile)
    
  (export (eval-class ::symbol ::bool ::pair-nil ::pair)
	  (eval-make-slot ::symbol ::obj ::bool ::obj ::obj ::obj ::bool ::obj)
	  (eval-expand-instantiate::pair-nil ::symbol ::pair-nil)
	  (eval-expand-duplicate::pair-nil ::symbol ::pair-nil)
	  (eval-expand-with-access::pair-nil ::symbol ::pair-nil)))

;*---------------------------------------------------------------------*/
;*    slot                                                             */
;*---------------------------------------------------------------------*/
(define-struct slot id type ronlyp default-value getter setter indexp info)

;*---------------------------------------------------------------------*/
;*    eval-make-slot ...                                               */
;*---------------------------------------------------------------------*/
(define (eval-make-slot id type ronlyp default-value getter setter indexp info)
   (slot id type ronlyp default-value getter setter indexp info))

;*---------------------------------------------------------------------*/
;*    slot-virtualp ...                                                */
;*---------------------------------------------------------------------*/
(define (slot-virtualp slot)
   (slot-getter slot))

;*---------------------------------------------------------------------*/
;*    decompose-ident ...                                              */
;*---------------------------------------------------------------------*/
(define (decompose-ident id::symbol)
   (let* ((string (symbol->string id))
	  (len (string-length string)))
      (let loop ((walker  0))
	 (cond
	    ((=fx walker len)
	     (values id #f))
	    ((and (char=? (string-ref string walker) #\:)
		  (<fx walker (-fx len 1))
		  (char=? (string-ref string (+fx walker 1)) #\:))
	     (values (string->symbol (substring string 0 walker))
		     (string->symbol (substring string (+fx walker 2) len))))
	    (else
	     (loop (+fx walker 1)))))))

;*---------------------------------------------------------------------*/
;*    class-predicate ...                                              */
;*---------------------------------------------------------------------*/
(define (class-predicate id)
   (symbol-append id '?))

;*---------------------------------------------------------------------*/
;*    class-make ...                                                   */
;*---------------------------------------------------------------------*/
(define (class-make id)
   (symbol-append 'make- id))

;*---------------------------------------------------------------------*/
;*    class-allocate ...                                               */
;*---------------------------------------------------------------------*/
(define (class-allocate id)
   (symbol-append '%allocate- id))

;*---------------------------------------------------------------------*/
;*    class-nil ...                                                    */
;*---------------------------------------------------------------------*/
(define (class-nil id)
   (symbol-append id '-nil))

;*---------------------------------------------------------------------*/
;*    slot-ref ...                                                     */
;*---------------------------------------------------------------------*/
(define (slot-ref fid cid)
   (symbol-append cid '- fid))

;*---------------------------------------------------------------------*/
;*    slot-set ...                                                     */
;*---------------------------------------------------------------------*/
(define (slot-set fid cid)
   (symbol-append cid '- fid '-set!))

;*---------------------------------------------------------------------*/
;*    slot-len ...                                                     */
;*---------------------------------------------------------------------*/
(define (slot-len fid)
   (symbol-append fid '-len))

;* {*---------------------------------------------------------------------*} */
;* {*    type-predicate ...                                               *} */
;* {*---------------------------------------------------------------------*} */
;* (define (type-predicate type)                                       */
;*    (case type                                                       */
;*       ((bstring) 'string?)                                          */
;*       ((bint) 'integer?)                                            */
;*       (else (symbol-append type '?))))                              */

;*---------------------------------------------------------------------*/
;*    find-super-native-class ...                                      */
;*---------------------------------------------------------------------*/
(define (find-super-native-class class)
   (if (eval-class? class)
       (find-super-native-class (class-super class))
       class))

;*---------------------------------------------------------------------*/
;*    slot-non-virtual-id ...                                          */
;*---------------------------------------------------------------------*/
(define (slot-non-virtual-id s)
   (and (not (slot-virtualp s)) (slot-id s)))

;*---------------------------------------------------------------------*/
;*    non-virtual-slots ...                                            */
;*---------------------------------------------------------------------*/
(define (non-virtual-slots lst)
   (filter (lambda (s) (not (slot-virtualp s))) lst))

;*---------------------------------------------------------------------*/
;*    eval-make-class ...                                              */
;*---------------------------------------------------------------------*/
(define (eval-make-class id slots const super super-slots native native-slots)
   (let* ((fid (class-make id))
	  (tmp (gensym))
	  (make-native (class-make (class-name native)))
	  (slots (non-virtual-slots slots))
	  (super-slots (non-virtual-slots super-slots))
	  (native-slots (non-virtual-slots native-slots))
	  (all-slots (append super-slots slots))
	  (native-args (filter-map slot-non-virtual-id native-slots))
	  (all-args (append (map slot-id super-slots) (map slot-id slots)))
	  (eval-slots (drop all-slots (length native-slots)))
	  (eval-args (drop all-args (length native-args))))
      (define (init-slot s a)
	 (let ((v (if (slot-indexp s)
		      `(make-vector ,(slot-len (slot-id s)) ,a)
		      a)))
	    v))
;* 	    (if (slot-type s)                                          */
;* 		`(if (,(type-predicate (slot-type s)) ,a)              */
;* 		     ,v                                                */
;* 		     (bigloo-type-error ',(slot-set (slot-id s) id)    */
;* 					',(slot-type s)                */
;* 					,a))                           */
;* 		v)))                                                   */
      `(define (,fid ,@all-args)
	  (let ((,tmp (,make-native ,@native-args)))
	     (object-class-num-set! ,tmp (class-num ,id))
	     (%object-widening-set! ,tmp
				    (vector ,@(map init-slot
						   eval-slots
						   eval-args)))
	     ,(when const `(,const ,tmp))
	     ,tmp))))

;*---------------------------------------------------------------------*/
;*    eval-allocate-class ...                                          */
;*---------------------------------------------------------------------*/
(define (eval-allocate-class id slots super super-slots native native-slots)
   (let* ((allocate-native (class-allocate (class-name native)))
	  (native-args (filter-map slot-non-virtual-id native-slots))
	  (args (append (filter-map slot-non-virtual-id super-slots)
			(filter-map slot-non-virtual-id slots)))
	  (fid (class-allocate id))
	  (tmp (gensym)))
      `(define (,fid)
	  (let ((,tmp (,allocate-native)))
	     (object-class-num-set! ,tmp (class-num ,id))
	     (%object-widening-set! ,tmp (make-vector
					  ,(- (length args)
					      (length native-args))))
	     ,tmp))))

;*---------------------------------------------------------------------*/
;*    eval-class-nil ...                                               */
;*---------------------------------------------------------------------*/
(define (eval-class-nil id super native)
   (let* ((native-nil (class-nil (class-name native)))
	  (fid (class-nil id))
	  (tmp (gensym)))
      `(define (,fid)
	  (let ((,tmp (,native-nil)))
	     (object-class-num-set! ,tmp (class-num ,id))
	     ,tmp))))

;*---------------------------------------------------------------------*/
;*    eval-class-predicate ...                                         */
;*---------------------------------------------------------------------*/
(define (eval-class-predicate id)
   (let ((fid (class-predicate id)))
      `(define (,fid x)
	  (is-a? x ,id))))

;*---------------------------------------------------------------------*/
;*    eval-class-slot-alias ...                                        */
;*---------------------------------------------------------------------*/
(define (eval-class-slot-alias cid slot super)
   (let ((sid (slot-id slot)))
      (define (ref)
	 `(define ,(slot-ref sid cid)
	     ,(slot-ref sid (class-name super))))
      (define (set)
	 `(define ,(slot-set sid cid)
	     ,(slot-set sid (class-name super))))
      (if (slot-ronlyp slot)
	  (list (ref))
	  (list (ref) (set)))))

;*---------------------------------------------------------------------*/
;*    eval-class-slot ...                                              */
;*---------------------------------------------------------------------*/
(define (eval-class-slot cid slot offset)
   (define (ref-plain)
      `(define (,(slot-ref (slot-id slot) cid) o)
	  ,(if (slot-getter slot)
	       `(,(slot-getter slot) o)
	       `(vector-ref-ur (%object-widening o) ,offset))))
   (define (set-plain)
      (let ((body (if (slot-setter slot)
		      `(,(slot-setter slot) o v)
		      `(vector-set-ur! (%object-widening o) ,offset v))))
	 `(define (,(slot-set (slot-id slot) cid) o v)
	     ,body)))
;* 	     ,(if (slot-type slot)                                     */
;* 		  `(if (,(type-predicate (slot-type slot)) v)          */
;* 		       ,body                                           */
;* 		       (bigloo-type-error ',(slot-set (slot-id slot) cid) */
;* 					  ',(slot-type slot)           */
;* 					  o))                          */
;* 		  body))))                                             */
   (define (ref-index)
      `(define (,(slot-ref (slot-id slot) cid) o i)
	  (vector-ref (vector-ref-ur (%object-widening o) ,offset) i)))
   (define (set-index)
      (let ((body `(vector-set! (vector-ref-ur (%object-widening o) ,offset) i v)))
	 `(define (,(slot-set (slot-id slot) cid) o i v)
	     ,body)))
;* 	     ,(if (slot-type slot)                                     */
;* 		  `(if (,(type-predicate (slot-type slot)) v)          */
;* 		       ,body                                           */
;* 		       (bigloo-type-error ',(slot-set (slot-id slot) cid) */
;* 					  ',(slot-type slot)           */
;* 					  o))                          */
;* 		  body))))                                             */
   (define (ref)
      (if (slot-indexp slot)
	  (ref-index)
	  (ref-plain)))
   (define (set)
      (if (slot-indexp slot)
	  (set-index)
	  (set-plain)))
   (if (slot-ronlyp slot)
       (list (ref))
       (list (ref) (set))))

;*---------------------------------------------------------------------*/
;*    eval-register-class ...                                          */
;*---------------------------------------------------------------------*/
(define (eval-register-class id super abstract slots sz constructor)
   (let ((cla (gensym)))
      `(define ,id
	  (let ((,cla (register-class!
		       ',id
		       ,(class-name super)
		       ,abstract
		       ,(class-make id)
		       ,(class-allocate id)
		       ,(class-nil id)
		       ,(class-predicate id)
		       -1
		       (list ,@(map (lambda (f)
				       (let ((sid (slot-id f)))
					  `(make-class-field
					    ',sid
					    ,(or (slot-getter f)
						 (slot-ref sid id))
					    ,(unless (slot-ronlyp f)
						(or (slot-setter f)
						    (slot-set sid id)))
					    ,(if (slot-indexp f)
						 (slot-ref (slot-len sid) id)
						 #f)
					    #f
					    ,(slot-info f)
					    (class-field-no-default-value))))
				    slots))
		       ,constructor
		       '#())))
	     (class-evdata-set! ,cla ,sz)
	     ,cla))))

;*---------------------------------------------------------------------*/
;*    field->slot ...                                                  */
;*---------------------------------------------------------------------*/
(define (field->slot field)
   (slot (class-field-name field)
	 #f
	 (not (class-field-mutable? field))
	 (class-field-default-value field)
	 #f
	 #f
	 #f
	 (class-field-info field)))

;*---------------------------------------------------------------------*/
;*    eval-instantiate->fill ...                                       */
;*---------------------------------------------------------------------*/
(define (eval-instantiate->fill cid args slots loc)
   (let* ((mk (class-make cid))
	  (ins (symbol-append 'instantiate:: cid))
	  (nodef (class-field-no-default-value))
	  (new (gensym 'newinst))
	  (tmp (gensym 'tmp)))
      (let loop ((slots slots)
		 (vals '())
		 (virtuals '()))
	 (if (null? slots)
	     (list 'quasiquote
		   `(let ((,new (,mk ,@(map (lambda (v) (list 'unquote v))
					    (reverse! vals)))))
		       ,@(map (lambda (id)
				 `(,(slot-set id cid)
				   ,new ,(list 'unquote id)))
			      virtuals)
		       ,new))
	     (let* ((s (car slots))
		    (id (slot-id s)))
		(cond
		   ;; a virtual slot
		   ((slot-virtualp s)
		    `(let ((,id (let ((c (assq ',id ,args)))
				   (if (pair? c)
				       (cadr c)
				       ,(let ((d (slot-default-value s)))
					   (if (eq? d nodef)
					       '#unspecified
					       (list 'quote d)))))))
			,(loop (cdr slots) vals (cons id virtuals))))
		   (else
		    ;; a plain slot
		    `(let ((,id (let ((c (assq ',id ,args)))
				   (if (pair? c)
				       (cadr c)
				       ,(let ((d (slot-default-value s)))
					   (if (eq? d nodef)
					       `(if (and (pair? ,loc)
							 (pair? (cdr ,loc))
							 (pair? (cddr ,loc)))
						    (error/location
						     ',ins
						     "argument missing"
						     ',id
						     (cadr ,loc)
						     (caddr ,loc))
						    (error ',ins
							   "argument missing"
							   ',id))
					       (list 'quote d)))))))
			,(loop (cdr slots) (cons id vals) virtuals)))))))))

;*---------------------------------------------------------------------*/
;*    eval-instantiate-check ...                                       */
;*---------------------------------------------------------------------*/
(define (eval-instantiate-check id args all-slots body)
   `(let ((lst (filter (lambda (s)
			  (or (not (pair? s))
			      (not (symbol? (car s)))
			      (not (memq (car s) ',(map slot-id all-slots)))))
		       ,args)))
       (if (pair? lst)
	   (error ',id "Illegal slot(s)" lst)
	   ,body)))

;*---------------------------------------------------------------------*/
;*    eval-expand-instantiate ...                                      */
;*---------------------------------------------------------------------*/
(define (eval-expand-instantiate cid all-slots)
   (let ((id (symbol-append 'instantiate:: cid))
	 (a (gensym 'args))
	 (loc (gensym 'loc))
	 (slots all-slots))
      `(define-expander ,id
	  (lambda (x e)
	     (let ((,a (cdr x)))
		(let ((,loc (if (epair? x) (cer x) #f)))
		   (e ,(eval-instantiate-check
			id a slots
			(eval-instantiate->fill cid a slots loc))
		      e)))))))

;*---------------------------------------------------------------------*/
;*    eval-duplicate->fill ...                                         */
;*---------------------------------------------------------------------*/
(define (eval-duplicate->fill cid args old slots)
   (let* ((mk (class-make cid))
	  (ins (symbol-append 'duplicate:: cid))
	  (nodef (class-field-no-default-value))
	  (new (gensym 'new))
	  (tmp (gensym 'tmp))
	  (slots slots))
      (let loop ((slots slots)
		 (vals '())
		 (virtuals '()))
	 (if (null? slots)
	     (list 'quasiquote
		   `(let* ((,tmp ,(list 'unquote old))
			   (,new (,mk ,@(map (lambda (v) (list 'unquote v))
					     (reverse! vals)))))
		       ,@(map (lambda (id)
				 `(,(slot-set id cid)
				   ,new ,(list 'unquote id)))
			      virtuals)
		       ,new))
	     (let* ((s (car slots))
		    (id (slot-id s)))
		(cond
		   ;; a virtual slot
		   ((slot-virtualp s)
		    `(let ((,id (let ((c (assq ',id ,args)))
				   (if (pair? c)
				       (cadr c)
				       ,(let ((d (slot-default-value s)))
					   (if (eq? d nodef)
					       '#unspecified
					       (list 'quote d)))))))
			,(loop (cdr slots) vals (cons id virtuals))))
		   (else
		    ;; a plain slot
		    `(let ((,id (let ((c (assq ',id ,args)))
				   (if (pair? c)
				       (cadr c)
				       '(,(slot-ref id cid) ,tmp)))))
			,(loop (cdr slots) (cons id vals) virtuals)))))))))

;*---------------------------------------------------------------------*/
;*    eval-expand-duplicate ...                                        */
;*---------------------------------------------------------------------*/
(define (eval-expand-duplicate cid all-slots)
   (let ((id (symbol-append 'duplicate:: cid))
	 (o (gensym 'old))
	 (a (gensym 'args))
	 (loc (gensym 'loc)))
      `(define-expander ,id
	  (lambda (x e)
	     (let ((,loc (if (epair? x) (cer x) #f)))
		(if (null? (cdr x))
		    (if (and (pair? ,loc)
			     (pair? (cdr ,loc))
			     (pair? (cddr ,loc)))
			(error/location x "object missing" #f
					(cadr ,loc) (caddr ,loc))
			(error x "object missing" #f))
		    (let ((,o (cadr x))
			  (,a (cddr x)))
		       (e ,(eval-instantiate-check
			    id a all-slots
			    (eval-duplicate->fill cid a o all-slots))
			  e))))))))

;*---------------------------------------------------------------------*/
;*    eval-expand-with-access ...                                      */
;*---------------------------------------------------------------------*/
(define (eval-expand-with-access id all-slots)
   (let ((wid (symbol-append 'with-access:: id))
	 (loc (gensym 'loc)))
      `(define-expander ,wid
	  (lambda (x e)
	     (let ((,loc (if (epair? x) (cer x) #f)))
		(match-case x
		   ((?- ?i (and (? list?) ?vars) . ?body)
		    ,(eval-with-access-expander id all-slots loc))
		   (else
		    (if (and (pair? ,loc)
			     (pair? (cdr ,loc))
			     (pair? (cddr ,loc)))
			(error/location ',wid "Illegal `with-access' form" x
					(cadr ,loc) (caddr ,loc))
			(error ',wid "Illegal `with-access' form" x)))))))))

;*---------------------------------------------------------------------*/
;*    eval-with-access-expander ...                                    */
;*    -------------------------------------------------------------    */
;*    VARS and BODY are not transmitted because this code generates    */
;*    an expression that supposes that these two variables are bound.  */
;*---------------------------------------------------------------------*/
(define (eval-with-access-expander id all-slots loc)
   `(let* ((slots ',(map (lambda (s)
			    (list (slot-id s)
				  (if (slot-indexp s) #t #f)
				  (slot-ronlyp s)))
			 all-slots))
	   (bdgs (map (lambda (v)
			 (cond
			    ((symbol? v)
			     (if (assq v slots)
				 (list v v)
				 (if (and (pair? ,loc)
					  (pair? (cdr ,loc))
					  (pair? (cddr ,loc)))
				     (error/location
				      ',(symbol-append 'with-access:: id)
				      "Illegal attribute(s)"
				      v
				      (cadr ,loc)
				      (caddr ,loc))
				     (error ',(symbol-append 'with-access:: id)
					    "Illegal attribute"
					    v))))
			    ((and (pair? v) (symbol? (car v))
				  (pair? (cdr v)) (symbol? (cadr v))
				  (null? (cddr v)))
			     (if (assq (cadr v) slots)
				 v
				 (if (and (pair? ,loc)
					  (pair? (cdr ,loc))
					  (pair? (cddr ,loc)))
				     (error/location
				      ',(symbol-append 'with-access:: id)
				      "Illegal attribute"
				      v
				      (cadr ,loc)
				      (caddr ,loc))
				     (error ',(symbol-append 'with-access:: id)
					    "Illegal attribute"
					    v))))
			    (else
			     (if (and (pair? ,loc)
				      (pair? (cdr ,loc))
				      (pair? (cddr ,loc)))
				 (error/location
				  ',(symbol-append 'with-access:: id)
				  "Illegal attribute"
				  v
				  (cadr ,loc)
				  (caddr ,loc))
				 (error ',(symbol-append 'with-access:: id)
					"Illegal attribute"
					v)))))
		      vars))
	   (ins (gensym 'ins))
	   (body `(let ((,ins ,i))
		     ,,(make-eval-with-access-body id all-slots 'ins)))
	   (e2 ,(make-eval-with-access-expander id 'ins)))
       (%with-lexical (map car bdgs) body e2 ins)))

;*---------------------------------------------------------------------*/
;*    make-eval-with-access-expander ...                               */
;*---------------------------------------------------------------------*/
(define (make-eval-with-access-expander id tmp)
   `(lambda (x e3)
       (match-case x
	  ((? symbol?)
	   (let* ((c1 (assq x bdgs))
		  (d (and (pair? c1)
			  (let ((c (assq x (%lexical-stack))))
			     (and (pair? c) (eq? (cdr c) ,tmp))))))
	      (if (not d)
		  (e x e)
		  (e `(,(symbol-append ',id '- (cadr c1)) ,,tmp) e))))
	  ((set! ?s ?v)
	   (let* ((c1 (assq s bdgs))
		  (d (and (pair? c1)
			  (let ((c (assq s (%lexical-stack))))
			     (and (pair? c) (eq? (cdr c) ,tmp)))
			  (assq (cadr c1) slots))))
	      (let ((v2 (e3 v e3)))
		 (if (or (not d) (caddr d))
		     (e `(set! ,s ,v2) e)
		     (e `(,(symbol-append ',id '- (cadr c1) '-set!) ,,tmp ,v2) e)))))
	  (else
	   (e x e3)))))

;*---------------------------------------------------------------------*/
;*    make-eval-with-access-body ...                                   */
;*---------------------------------------------------------------------*/
(define (make-eval-with-access-body id all-slots tmp)
   (if (every? (lambda (s) (slot-indexp s) all-slots))
       (make-eval-with-access-body-plain id all-slots tmp)
       (make-eval-with-access-body-indexed id all-slots tmp)))

;*---------------------------------------------------------------------*/
;*    make-eval-with-access-body-plain ...                             */
;*---------------------------------------------------------------------*/
(define (make-eval-with-access-body-plain id all-slots tmp)
   ``(begin ,@body))

;*---------------------------------------------------------------------*/
;*    make-eval-with-access-body-indexed ...                           */
;*---------------------------------------------------------------------*/
(define (make-eval-with-access-body-indexed id all-slots tmp)
   `(let loop ((vars vars))
       (if (null? vars)
	   `(begin ,@body)
	   (let ((d (assq (cadr (car bdgs)) slots)))
	      (cond
		 ((not d)
		  (error ',(symbol-append 'with-access:: id)
			 "Illegal attribute"
			 (car vars)))
		 ((cadr d)
		  ;; an indexed slot
		  (let ((v `(,(symbol-append ',id '- (caar vars) '-len)
			     ,tmp))
			(r `(lambda (r)
			       (,(symbol-append ',id '- (caar vars) '-ref)
				,tmp r)))
			(s `(lambda (r v)
			       (,(symbol-append ',id '- (caar vars) '-set!)
				,tmp r v))))
		     (if (caddr d)
			 `(let ((,(symbol-append (caar vars) '-len) ,v)
				(,(symbol-append (caar vars) '-ref) ,r))
			     ,(loop (cdr vars)))
			 `(let ((,(symbol-append (caar vars) '-len) ,v)
				(,(symbol-append (caar vars) '-ref) ,r)
				(,(symbol-append (caar vars) '-set!) ,s))
			     ,(loop (cdr vars))))))
		 (else
		  ;; a direct slot
		  (loop (cdr vars))))))))

;*---------------------------------------------------------------------*/
;*    class-all-slots ...                                              */
;*---------------------------------------------------------------------*/
(define (class-all-slots class)
   (map field->slot (class-all-fields class)))

;*---------------------------------------------------------------------*/
;*    eval-parse-class-slot ...                                        */
;*---------------------------------------------------------------------*/
(define (eval-parse-class-slot loc f)
   (cond
      ((symbol? f)
       (multiple-value-bind (id type)
	  (decompose-ident f)
	  (list (slot id type #f (class-field-no-default-value) #f #f #f #f))))
      ((not (and (list? f) (symbol? (car f))))
       (evcompile-error (find-loc f loc)
			'eval "Illegal slot declaration" f))
      ((and (eq? (car f) '*)
	    (or (null? (cdr f))
		(not (symbol? (cadr f)))
		(assq 'get (cddr f))
		(assq 'set (cddr f))))
       (evcompile-error (find-loc f loc)
			'eval "Illegal indexed slot declaration" f))
      (else
       (let ((indexp #f)
	     (id (car f))
	     (attrs (cdr f)))
	  (when (eq? (car f) '*)
	     (set! id (cadr f))
	     (set! indexp #t)
	     (set! attrs (cddr f)))
	  (multiple-value-bind (id type)
	     (decompose-ident id)
	     (let ((def (class-field-no-default-value))
		   (get #f)
		   (set #f)
		   (info #f)
		   (ronly #f))
		(for-each (lambda (attr)
			     (cond
				((eq? attr 'read-only)
				 (set! ronly #t))
				(else
				 (match-case attr
				    ((info ?value)
				     (set! info value))
				    ((get ?expr)
				     (set! get expr))
				    ((set ?expr)
				     (set! set expr))
				    ((default ?expr)
				     (set! def expr))
				    (else
				     (evcompile-error
				      (find-loc f loc)
				      'eval "Illegal slot declaration" f))))))
			  attrs)
		(cond
		   ((and get (not ronly) (not set))
		    (evcompile-error
		     (find-loc f loc)
		     'eval "Missing virtual set" f))
		   ((and set (not get))
		    (evcompile-error
		     (find-loc f loc)
		     'eval "Missing virtual get" f))
		   (else
		    (let ((s (slot id type ronly def get set indexp info)))
		       (if indexp
			   (list
			    (slot (slot-len id)
				  'integer
				  #t
				  (class-field-no-default-value)
				  #f
				  #f
				  #f
				  #f)
			    s)
			   (list s)))))))))))

;*---------------------------------------------------------------------*/
;*    eval-parse-class ...                                             */
;*    -------------------------------------------------------------    */
;*    Parse the class clauses, returning the constructor and           */
;*    the new slots.                                                   */
;*---------------------------------------------------------------------*/
(define (eval-parse-class loc clauses)
   (let ((loc (find-loc clauses loc)))
      (cond
	 ((null? clauses)
	  (values #f '()))
	 ((not (list? clauses))
	  (evcompile-error (find-loc clauses loc)
			   'eval "Illegal class declaration" clauses))
	 ((match-case (car clauses) (((? symbol?)) #t) (else #f))
	  (values (caar clauses)
		  (append-map (lambda (f)
				 (eval-parse-class-slot loc f))
			      (cdr clauses))))
	 (else
	  (values #f
		  (append-map (lambda (f)
				 (eval-parse-class-slot loc f))
			      clauses))))))

;*---------------------------------------------------------------------*/
;*    find-class-constructor ...                                       */
;*---------------------------------------------------------------------*/
(define (find-class-constructor c)
   (let ((const (class-constructor c)))
      (if const
	  const
	  (let ((s (class-super c)))
	     (if (class? s)
		 (find-class-constructor s)
		 #f)))))

;*---------------------------------------------------------------------*/
;*    eval-class ...                                                   */
;*    -------------------------------------------------------------    */
;*    Returns a double value, the list of declarations and the list    */
;*    of bound variables.                                              */
;*---------------------------------------------------------------------*/
(define (eval-class id abstract clauses src)
   (multiple-value-bind (cid sid)
      (decompose-ident id)
      (let ((loc (find-loc src #f))
	    (super (find-class (or sid 'object))))
	 (cond
	    ((not (class? super))
	     (evcompile-error loc 'eval "Cannot find super class" sid))
	    ((class-abstract? super)
	     (evcompile-error loc 'eval "Eval class cannot inherit from abstract native classes" sid))
	    (else
	     (multiple-value-bind (constructor slots)
		(eval-parse-class loc clauses)
		(let* ((super-slots (class-all-slots super))
		       (native (find-super-native-class super))
		       (native-slots (class-all-slots native))
		       (all-slots (append super-slots slots))
		       (offset (if (eval-class? super)
				   (class-evdata super)
				   0))
		       (size (length
			      (filter (lambda (s) (not (slot-getter s)))
				      slots))))
		   ;; check illegally overriden fields
		   (let loop ((slots all-slots))
		      (when (pair? slots)
			 (let ((s (car slots)))
			    (for-each (lambda (t)
					 (when (eq? (slot-id s) (slot-id t))
					    (evcompile-error
					     loc
					     'eval
					     "Illegal duplicate field"
					     (slot-id s))))
				      (cdr slots))
			    (loop (cdr slots)))))
		   (let ((exprs '())
			 (idents '()))
		      ;; class definition
		      (set! exprs (list (eval-register-class
					 cid super abstract
					 slots (+ offset size)
					 constructor)))
		      (set! idents (list cid))
		      ;; class slots
		      (let ((e (append-map (lambda (f o)
					      (eval-class-slot cid f o))
					   slots
					   (iota (length slots) offset))))
			 (set! exprs (append e exprs))
			 (set! idents (append (map caadr e) idents)))
		      ;; super slots
		      (let ((e (append-map (lambda (f)
					      (eval-class-slot-alias cid f super))
					   super-slots)))
			 (set! exprs (append e exprs))
			 (set! idents (append (map cadr e) idents)))
		      ;; with-access
		      (set! exprs
			    (cons (eval-expand-with-access cid all-slots)
				  exprs))
		      ;; predicate
		      (let ((e (eval-class-predicate cid)))
			 (set! exprs (cons e exprs))
			 (set! idents (cons (caadr e) idents)))
		      ;; class-nil
		      (let ((e (eval-class-nil cid super native)))
			 (set! exprs (cons e exprs))
			 (set! idents (cons (caadr e) idents)))
		      ;; constructor
		      (unless abstract
			 ;; make
			 (let ((e (eval-make-class
				   cid slots
				   (or constructor (find-class-constructor super))
				   super super-slots
				   native native-slots)))
			    (set! exprs (cons e exprs))
			    (set! idents (cons (caadr e) idents)))
			 ;; allocate
			 (let ((e (eval-allocate-class cid slots
						       super super-slots
						       native native-slots)))
			    (set! exprs (cons e exprs))
			    (set! idents (cons (caadr e) idents)))
			 ;; instantiate
			 (let ((e (eval-expand-instantiate cid all-slots)))
			    (set! exprs (cons e exprs)))
			 ;; duplicate
			 (let ((e (eval-expand-duplicate cid all-slots)))
			    (set! exprs (cons e exprs))))
		      (values exprs idents)))))))))
		     
