/*	
	BMCONF - (Smart) Boot Manager GNU/Linux Configurator
	(C)opyright Risko Gergely, 2000.
	This program can be licensed under the terms of GNU GPL v2 or above.
	
	PLEASE NOTE THAT IF THIS PROGRAM HAS GOT A BUG, IT CAN PRODUCE
	A BAD PARTITION TABLE AND BOOT RECORD. USE AT YOUR OWN RISK!
*/

#include "includes.h"

enum
{
    DRIVE_OPTION=0,
    CDROM_OPTION,
    NAME_OPTION
};

enum
{
    PASS_RECORD_OPTION=0,
    PASS_PASSWORD_OPTION
};

enum
{
    SCHE_RECORD_OPTION=0,
    SCHE_TIME_OPTION
};


char *add_opts[] =
{
    [DRIVE_OPTION]="drive",
    [CDROM_OPTION]="cdrom",
    [NAME_OPTION]="name",
    NULL
};

char *pass_opts[] =
{
    [PASS_RECORD_OPTION]="record",
    [PASS_PASSWORD_OPTION]="password",
    NULL
};

char *sche_opts[] =
{
    [SCHE_RECORD_OPTION]="record",
    [SCHE_TIME_OPTION]="time",
    NULL
};

int main(int argc, char **argv)
{
    int c;
    int optnumber=0;
    int willbeinstalled=0;
    int listflag=0;
    char *configfile;
    char *drive=NULL;
    char *themename;
    unsigned char drivenum;	/* 128 is the first hd */
    int addfloppy=0;
    unsigned char addhard=0;
    unsigned char addpartid=0;
    char *passset;
    char *themesdir=NULL;
    int passrec=0;
    char *scheset;
    int scherec=0;
    char *adddrive=NULL;
    char *addname=NULL;
    int long_index;
    struct struc_bootmanager btmgr;
    
    static struct option long_options[] =
    {
#define VERSION_OPTION 0
	{"version", 0, 0, 0},
#define HELP_OPTION 1
	{"help", 0, 0, 0},
#define DEFRAG_OPTION 2
	{"defrag", 0, 0, 0},
#define DEFAULT_OPTION 3
	{"default", 1, 0, 0},
#define DELAY_OPTION 4
	{"delay", 1, 0, 0},
#define AUTOHIDE_OPTION 5
	{"autohide", 1, 0, 0},
#define AUTOACTIVE_OPTION 6
	{"autoactive", 1, 0, 0},
#define SWAPDRIVEID_OPTION 7
	{"swapdriveid", 1, 0, 0},
#define NOAUTOSCAN_OPTION 8
	{"noautoscan", 0, 0, 0},
#define LIST_OPTION 9
	{"list", 0, 0, 0},
#define DEVICE_OPTION 10
	{"device", 1, 0, 0},
#define ADD_OPTION 11
	{"add", 1, 0, 0},
#define REMBYNUM_OPTION 12
	{"rembynum", 1, 0 ,0},
#define INSTALL_OPTION 13
	{"install", 1, 0, 0},
#define PASSWORD_OPTION 14
	{"password", 1, 0, 0},
#define SCHEDULE_OPTION 15
	{"schedule", 1, 0, 0},
#define SECLOCK_OPTION 16
	{"seclock", 1, 0, 0},
#define DIRECTBOOT_OPTION 17
	{"direct-boot", 1, 0, 0},
#define REMLAST_OPTION 18
	{"remlast", 1, 0, 0},
#define INT13_OPTION 19
	{"int13", 1, 0, 0},
#define CONFIGFILE_OPTION 20
	{"configfile", 1, 0, 0},
#define THEMESDIR_OPTION 21
	{"themesdir", 1, 0, 0},
#define STYLE_OPTION 22
	{"style", 1, 0, 0},
	{0,0,0,0}
    };
    
    opterr=0;
    if (argc==1)
    {
        willbeinstalled=1;
        configrun(&btmgr, &drive, &themesdir, &themename, &drivenum, DEFAULT_CONFIG);
	if (!themesdir)
	    asprintf(&themesdir, DFLTHEMESDIR);
    }
    else 
    while ((c=getopt_long(argc,argv,"",long_options,&long_index)) != -1)
    {
	char * subopts;
	
	optnumber++;
	
	switch (c)
	{
	    case 0:
		switch (long_index)
		{
		    int atoiret;
		    		    
		    case HELP_OPTION:
			usage();
			break;
		    case LIST_OPTION:
			listflag=1;
			if (drive)
			    list(&btmgr);
			else
		    	    usage();
			break;
		    case ADD_OPTION:
			addname=NULL;
			adddrive=NULL;
			addhard=0;
			addpartid=0;
			addfloppy=0;
			subopts=optarg;
			while (*subopts!='\0')
			{
			    char *value;
	    		    switch(getsubopt(&subopts, add_opts, &value))
			    {
				case DRIVE_OPTION:
				    if (value==NULL)
					usage();
				    if (addhard!=0)
				    {
					fprintf(stderr,"You can't use the cdrom and drive option at the same time.\n");
					usage();
				    }
				    
				    parsefdhdxadd(value, &addfloppy, &addhard, &addpartid, &adddrive);
				    break;
				case CDROM_OPTION:
				    if (value==NULL)
					usage();
				    if (addhard!=0)
				    {
					fprintf(stderr,"You can't use the cdrom and drive option at the same time.\n");
					usage();
				    }
				    
				    atoiret=verifiedatoi(value);
				    if (atoiret>=0 && atoiret<256-MIN_CDROM_ID)
					addhard=MIN_CDROM_ID+atoiret;

				    addpartid=0;
				    addfloppy=0;
				    break;
				case NAME_OPTION:
				    if (value==NULL)
					usage();
				    asprintf(&addname,"%s",value);
				    break;
				default:
				    fprintf(stderr, "Unknown add option: %s\n", value);
				    usage();
			    }
			}
			if ((drive) && (addname) && ((addfloppy) || (addhard)))
			    addpartition(&btmgr, addfloppy, addhard, adddrive, addpartid, addname);
			else
			{
			    fprintf(stderr, "Invalid options!\n");
		    	    usage();
			}
			break;
		    case PASSWORD_OPTION:
			subopts=optarg;
			passset=NULL;
			passrec=0;
			while (*subopts!='\0')
			{
			    char *value;
	    		    switch(getsubopt(&subopts, pass_opts, &value))
			    {
				case PASS_RECORD_OPTION:
				    if (value==NULL)
					usage();
				    if (strcasecmp(value, "root")==0)
				    {
					passrec=-1;
				    }
				    else
				    {
					atoiret=verifiedatoi(value);
				        if (atoiret>0)
				        {
					    passrec=atoiret;
				        }
				        else
				        {
					    fprintf(stderr,"Bad option for password record\n");
					    exit(-4);
				        }
				    }

				    break;
				case PASS_PASSWORD_OPTION:
				    if (value==NULL)
					usage();
				    asprintf(&passset,"%s",value);
				    break;
				default:
				    fprintf(stderr, "Unknown password option: %s\n", value);
				    usage();
			    }
			}
			if ((passrec) && (passset) && (drive))
			    password(&btmgr, passrec-1, passset);
			else
		    	    usage();
			break;
		    case SCHEDULE_OPTION:
			subopts=optarg;
			scheset=NULL;
			scherec=0;
			while (*subopts!='\0')
			{
			    char *value;
	    		    switch(getsubopt(&subopts, sche_opts, &value))
			    {
				case SCHE_RECORD_OPTION:
				    if (value==NULL)
					usage();
				    atoiret=verifiedatoi(value);
				    if (atoiret>0)
				    {
					scherec=atoiret;
				    }
				    else
				    {
					fprintf(stderr,"Bad option for schedule record\n");
					exit(-4);
				    }

				    break;
				case SCHE_TIME_OPTION:
				    if (value==NULL)
					usage();
				    asprintf(&scheset,"%s",value);
				    break;
				default:
				    fprintf(stderr, "Unknown schedule option: %s\n", value);
				    usage();
			    }
			}
			if ((scherec) && (drive))
			    schedule(&btmgr, scherec-1, scheset);
			else
			    usage();
			break;
		    case DEVICE_OPTION:
			driveparse(optarg, &drive, &drivenum);
		        if (willbeinstalled) 
			{
			    emptybtmgr(&btmgr, themesdir, themename, drivenum, drive);
			}
			else
			{
			    if (!drivecheck(drive))
			    {
				fprintf(stderr,"Unable to handle %s\n", drive);
				exit(-2);
			    }
			    bmread(drive, &btmgr);
			}
			printf("Device is: %s. Device's bios number: %d\n", drive, drivenum);
			break;
		    case VERSION_OPTION:
		        fprintf(stderr,"BMCONF version %s\n", VERSION);
			exit(-1);
			break;
		    case DEFRAG_OPTION:
			if (drive) defrag(&btmgr);
			else usage();
			break;
		    case SECLOCK_OPTION:
			if (drive) seclock(&btmgr,optarg);
			else usage();
			break;
		    case REMLAST_OPTION:
			if (drive) remlast(&btmgr,optarg);
			else usage();
			break;
		    case INT13_OPTION:
			if (drive) int13(&btmgr,optarg);
			else usage();
			break;
		    case DEFAULT_OPTION:
			if (drive) 
			{
			    atoiret=verifiedatoi(optarg);
			    if (atoiret>0)
			    {
				chdefault(&btmgr, atoiret-1);
			    }
			    else
			    {
				fprintf(stderr,"Bad option for default\n");
				exit(-4);
			    }
			}
			break;
		    case STYLE_OPTION:
			if (drive) 
			{
			    atoiret=verifiedatoi(optarg);
			    if ((atoiret>-1) && (atoiret<4))
			    {
				style(&btmgr, atoiret);
			    }
			    else
			    {
				fprintf(stderr,"Bad option for default\n");
				exit(-4);
			    }
			}
			break;
		    case DIRECTBOOT_OPTION:
			if (drive) 
			{
			    atoiret=verifiedatoi(optarg);
			    if (atoiret>0)
			    {
				directboot(&btmgr, atoiret-1);
			    }
			    else
			    {
				fprintf(stderr,"Bad option for direct-boot\n");
				exit(-4);
			    }
			}
			break;
		    case SWAPDRIVEID_OPTION:
			if (drive) 
			{
			    atoiret=verifiedatoi(optarg);
			    if (atoiret>0)
			    {
				swapdriveid(&btmgr, atoiret-1);
			    }
			    else
			    {
				fprintf(stderr,"Bad option for swapdriveid\n");
				exit(-4);
			    }
			}
			break;
		    case AUTOHIDE_OPTION:
			if (drive) 
			{
			    atoiret=verifiedatoi(optarg);
			    if (atoiret>0)
			    {
				autohide(&btmgr, atoiret-1);
			    }
			    else
			    {
				fprintf(stderr,"Bad option for autohide\n");
				exit(-4);
			    }
			}
			break;
		    case AUTOACTIVE_OPTION:
			if (drive) 
			{
			    atoiret=verifiedatoi(optarg);
			    if (atoiret>0)
			    {
				autoactive(&btmgr, atoiret-1);
			    }
			    else
			    {
				fprintf(stderr,"Bad option for autoactive\n");
				exit(-4);
			    }
			}
			break;
		    case REMBYNUM_OPTION:
			if (drive) 
			{
			    atoiret=verifiedatoi(optarg);
			    if (atoiret>0)
			    {
				rembynum(&btmgr, atoiret-1);
			    }
			    else
			    {
				fprintf(stderr,"Bad option for default\n");
				exit(-4);
			    }
			}
			break;
		    case DELAY_OPTION:
			if (drive) 
			{
			    atoiret=verifiedatoi(optarg);
			    if (atoiret>0)
			    {
				delay(&btmgr, atoiret);
			    }
			    else
			    {
				fprintf(stderr,"Bad option for default\n");
				exit(-4);
			    }
			}
			else usage();
			break;
		    case NOAUTOSCAN_OPTION:
			if (drive)
			{
			    noautoscan(&btmgr);
			}
			else usage();
			break;
		    case INSTALL_OPTION:
			willbeinstalled=1;
			if (!themesdir) asprintf(&themesdir, DFLTHEMESDIR);
			asprintf(&themename, "%s", optarg);
			break;
		    case THEMESDIR_OPTION:
			if (willbeinstalled)
			{
			    fprintf(stderr, "The themesdir option must be specified before --install!\n");
			    usage();
			}
			else
			{
			    asprintf(&themesdir,"%s", optarg);
			}
			break;
		    case CONFIGFILE_OPTION:
			asprintf(&configfile, "%s", optarg);
			if ((getopt_long(argc,argv,"",long_options,&long_index)==-1)
			    && (optnumber==1))
			{
			    willbeinstalled=1;
			    configrun(&btmgr, &drive, &themesdir, &themename, &drivenum, configfile);
			    if (!themesdir)
				asprintf(&themesdir, DFLTHEMESDIR);
			}
			else
			{
			    fprintf(stderr,"If you use configfile option this must be the ONLY ONE option!\n");
			    usage();
			}
			break;
		}
		break;
	    case '?':
		usage();
		break;
	    default:
		fprintf(stderr,"error\n");
		abort();
	}
    }
    
    if (!drive)
    {
	usage();
    }
    else
    {
	struct struc_bootmanager btmgr_tmp;

	if ((!willbeinstalled) && (themesdir))
	{
	    fprintf(stderr, "You can only use themesdir if you specify --install after!\n");
	    usage();
	}
        if (willbeinstalled) install_main(themename, themesdir, drive, drivenum);
	
	bmread(drive, &btmgr_tmp);

	btmgr_tmp.sbmlheader = btmgr.sbmlheader;
	btmgr_tmp.sbmkheader = btmgr.sbmkheader;
	btmgr_tmp.sbmkdata = btmgr.sbmkdata;

	bmwrite(drive, &btmgr_tmp);
	free(btmgr.data);
	free(btmgr_tmp.data);
    }
    
    return 0;
}
