//  BMPx - The Dumb Music Player
//  Copyright (C) 2005 BMPx development team.
//
//  This program is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License Version 2
//  as published by the Free Software Foundation.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program; if not, write to the Free Software
//  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//
//  --
//
//  The BMPx project hereby grants permission for non-GPL compatible GStreamer
//  plugins to be used and distributed together with GStreamer and BMPx. This
//  permission is above and beyond the permissions granted by the GPL license
//  BMPx is covered by.

#ifndef BMP_BASE_TYPES_HH
#define BMP_BASE_TYPES_HH

#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif //HAVE_CONFIG_H

#include <glibmm.h>
#include <boost/optional.hpp>

#include <string>
#include <vector>
#include <map>

namespace Bmp
{
#ifdef HAVE_HAL
  typedef std::pair   < std::string, std::string > UriVrpPair;
  typedef std::vector < UriVrpPair > VUriVrpPair;
#endif //HAVE_HAL

  typedef std::vector<Glib::ustring>      VUri;
  typedef std::vector<std::string>        StrV;

  typedef boost::optional<Glib::ustring>  oustring;
  typedef boost::optional<unsigned int>   ouint;
  typedef boost::optional<bool>           obool;
}

#endif // !BMP_BASE_TYPES_HH
