//  BMPx - The Dumb Music Player
//  Copyright (C) 2005 BMPx development team.
//
//  This program is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License Version 2
//  as published by the Free Software Foundation.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program; if not, write to the Free Software
//  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//
//  --
//
//  The BMPx project hereby grants permission for non-GPL compatible GStreamer
//  plugins to be used and distributed together with GStreamer and BMPx. This
//  permission is above and beyond the permissions granted by the GPL license
//  BMPx is covered by.

#ifndef BMP_DATABASE_TYPES_HH
#define BMP_DATABASE_TYPES_HH

#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif //HAVE_CONFIG_H

#include <string>
#include <queue>
#include <map>
#include <vector>

#include <boost/variant.hpp>
#include <boost/tuple/tuple.hpp>

namespace Bmp
{
  namespace DB
  {
	  enum ValueType
	  {
	      VALUE_TYPE_BOOL,
	      VALUE_TYPE_INT,
	      VALUE_TYPE_REAL,	//We use "REAL" here as it's sqlite3's notation, see: http://www.sqlite.org/datatype3.html
	      VALUE_TYPE_STRING  
	  }; 

	  typedef boost::variant < bool, uint64_t, double, std::string > Variant;

	  typedef std::map    < std::string,  ValueType >	    ValueMap;
	  typedef std::pair   < std::string,  ValueType >	    PairValueType;
	  typedef std::map    < std::string,  Variant >		    Row;
	  typedef std::vector < Row >			                    VRows;
	  typedef std::map    < std::string,  ValueMap >	    TableMapMap;

    struct DatumDefine
    {
      const char    *title;
      const char    *title_plural;
      const char    *description;
      const char    *id;
      DB::ValueType  type;
    };

    enum MatchStyle
    {
      NOOP,
      FUZZY,
      EXACT,
      GREATER_THAN,
      LESSER_THAN,
      GREATER_THAN_OR_EQUAL,
      LESSER_THAN_OR_EQUAL,
      NOT_NULL,
      IS_NULL
    };

	  typedef boost::tuple < MatchStyle, std::string, Variant > Attribute;

	  /** A vector of @link Attribute@endlink
	    *
	    */
	  typedef std::vector  < Attribute > VAttributes;

  } // namespace DB
}; // namespace Bmp 

#endif // !BMP_DATABASE_TYPES_HH
