dnl -*- Mode: Autoconf; -*-

dnl BMP_BOOST_VARS()
AC_DEFUN([BMP_BOOST_VARS],
    [AC_ARG_VAR([BOOST_CFLAGS], [C++ compiler flags for Boost])
     AC_ARG_VAR([BOOST_LIBS], [linker flags for Boost])
    ]
)

dnl BMP_WRAPPED_BOOST_CHECK([BODY])
AC_DEFUN([BMP_WRAPPED_BOOST_CHECK],
    [AC_REQUIRE([BMP_BOOST_VARS])
     BMP_WRAPPED_CHECK(
         [CXXFLAGS="$CXXFLAGS -Wall -ansi -pedantic -Werror $BOOST_CFLAGS"
          LIBS="$BOOST_LIBS"
          $1
         ])
    ]
)

dnl BMP_CHECK_BOOST_SMART_PTR([ACTION-IF-FOUND], [ACTION-IF-NOT-FOUND])
AC_DEFUN([BMP_CHECK_BOOST_SMART_PTR],
    [BMP_WRAPPED_BOOST_CHECK(
        [AC_MSG_CHECKING([for Boost smart pointer library])
         AC_TRY_COMPILE(
             [#include <boost/shared_ptr.hpp>
              #include <boost/scoped_ptr.hpp>],
             [boost::shared_ptr<int> ptr  (new int);
              boost::scoped_ptr<int> ptr2 (new int);],
             [AC_MSG_RESULT([yes])
              $1],
             [AC_MSG_RESULT([not found])
              $2])
        ])
    ]
)

dnl BMP_CHECK_BOOST_STRING_ALGO([ACTION-IF-FOUND], [ACTION-IF-NOT-FOUND])
AC_DEFUN([BMP_CHECK_BOOST_STRING_ALGO],
    [BMP_WRAPPED_BOOST_CHECK(
        [AC_MSG_CHECKING([for Boost string algorithm library])
         AC_TRY_COMPILE(
             [#include <boost/algorithm/string.hpp>],
             [// FIXME: write something...],
             [AC_MSG_RESULT([yes])
              $1],
             [AC_MSG_RESULT([not found])
              $2])
        ])
    ]
)

dnl BMP_CHECK_BOOST_FILESYSTEM([ACTION-IF-FOUND], [ACTION-IF-NOT-FOUND])
AC_DEFUN([BMP_CHECK_BOOST_FILESYSTEM],
    [AC_ARG_VAR([BOOST_FILESYSTEM_CFLAGS], [C++ compiler flags for Boost filesystem library])
     AC_ARG_VAR([BOOST_FILESYSTEM_LIBS], [linker flags for Boost filesystem library])

     if test "$BOOST_FILESYSTEM_LIBS" = ""; then
         BOOST_FILESYSTEM_LIBS="-lboost_filesystem"
     fi

     BMP_WRAPPED_BOOST_CHECK(
        [AC_MSG_CHECKING([for Boost filesystem library])
         CXXFLAGS="$CXXFLAGS $BOOST_FILESYSTEM_CFLAGS"
         LIBS="$LIBS $BOOST_FILESYSTEM_LIBS"

         AC_TRY_COMPILE(
             [#include <boost/filesystem/path.hpp>
              #include <boost/filesystem/operations.hpp>],
             [namespace fs = boost::filesystem;
              fs::path path = fs::path ("directory") / "file";],
             [AC_MSG_RESULT([yes])
              $1],
             [AC_MSG_RESULT([not found])
              $2])
        ])
    ]
)

dnl BMP_CHECK_BOOST_FORMAT_STR([ACTION-IF-FOUND], [ACTION-IF-NOT-FOUND])
AC_DEFUN([BMP_CHECK_BOOST_FORMAT_STR],
    [BMP_WRAPPED_BOOST_CHECK(
        [AC_MSG_CHECKING([for Boost format string library])
         AC_TRY_COMPILE(
             [#include <iostream>
              #include <boost/format.hpp>],
             [std::cout << boost::format ("%d %s") % 1 % "Hello"],
             [AC_MSG_RESULT([yes])
              $1],
             [AC_MSG_RESULT([not found])
              $2])
        ])
    ]
)

dnl BMP_CHECK_BOOST_REGEX([ACTION-IF-FOUND], [ACTION-IF-NOT-FOUND])
AC_DEFUN([BMP_CHECK_BOOST_REGEX],
    [AC_ARG_VAR([BOOST_REGEX_CFLAGS], [C++ compiler flags for Boost regex library])
     AC_ARG_VAR([BOOST_REGEX_LIBS], [linker flags for Boost regex library])

     if test "$BOOST_REGEX_LIBS" = ""; then
         BOOST_REGEX_LIBS="-lboost_regex"
     fi

     BMP_WRAPPED_BOOST_CHECK(
        [AC_MSG_CHECKING([for Boost regex library])
         CXXFLAGS="$CXXFLAGS $BOOST_REGEX_CFLAGS"
         LIBS="$LIBS $BOOST_REGEX_LIBS"

         AC_TRY_COMPILE(
             [#include <boost/regex.hpp>],
             [boost::regex r ("test");],
             [AC_MSG_RESULT([yes])
              $1],
             [AC_MSG_RESULT([not found])
              $2])
        ])
    ]
)
