#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif //HAVE_CONFIG_H

#include <unistd.h>
#include <sys/stat.h>
#include <sys/types.h>

#include <taglib/fileref.h>
#include <glibmm.h>

#include <boost/format.hpp>
static boost::format fsizefmt ("%llu");

// Plugin-specific include
#include <taglib/taglib.h>
#include <taglib/fileref.h>
#include <taglib/tfile.h>
#include <taglib/tag.h>

#include <taglib/mpcfile.h>
#include <taglib/apetag.h>
#include <taglib/apeitem.h>
#include <taglib/apefooter.h>

extern "C" int  _plugin_has_accessors; 
int  _plugin_has_accessors = 1;

#include <bmp/database_types.hh>
#include <bmp/library_types.hh>
#include <src/util_string.hh>

extern "C" bool _set (std::string const& name, Bmp::Library::UTrack & track)
{
  using namespace Bmp::Library;
  using namespace TagLib;

  MPC::File opfile (name.c_str());

  if (!(opfile.isOpen() && opfile.isValid()))
    return false;

  Bmp::Library::metadata_set_common (track, opfile.tag());

  APE::Tag * tag = opfile.APETag(true);
  if (tag)
  {
      if (track.mb_album_artist)
        tag->addValue ("MUSICBRAINZ_ALBUMARTIST",
                        String (track.mb_album_artist.get(),            String::UTF8));

      if (track.mb_album_artist_id)
        tag->addValue ("MUSICBRAINZ_ALBUMARTISTID",
                        String (track.mb_album_artist_id.get(),         String::UTF8));

      if (track.mb_album_artist_sort_name)
        tag->addValue ("MUSICBRAINZ_ALBUMARTISTSORTNAME",
                        String (track.mb_album_artist_sort_name.get(),  String::UTF8));

      if (track.mb_track_id)
        tag->addValue ("MUSICBRAINZ_TRACKID",
                        String (track.mb_track_id.get(),                String::UTF8));

      if (track.mb_album_id)
        tag->addValue ("MUSICBRAINZ_ALBUMID",
                        String(track.mb_album_id.get(),                 String::UTF8));

      if (track.mb_artist_id)
        tag->addValue ("MUSICBRAINZ_ARTISTID",
                        String (track.mb_artist_id.get(),               String::UTF8));


      if (track.mb_artist_sort_name)
        tag->addValue ("MUSICBRAINZ_SORTNAME",
                        String (track.mb_artist_sort_name.get(),        String::UTF8));

      if (track.mb_release_date)
        tag->addValue ("DATE",
                        String (track.mb_release_date.get(),            String::UTF8));

      if (track.asin)
        tag->addValue ("AMAZON_ASIN",
                        String (track.asin.get(),                       String::UTF8));

      if (track.asin)
        tag->addValue ("MUSICIP_PUID",
                        String (track.asin.get(),                       String::UTF8));

      opfile.save();

      tag = opfile.APETag ();

      struct stat tagstat;
      stat (name.c_str(), &tagstat);

      TagLib::ByteVector tagData (tag->render());

      track.hash =
        Bmp::Util::md5_hex ((char*)(tagData.data()), tagData.size())+(fsizefmt % (unsigned long long int)(tagstat.st_size)).str();

      return true;
  }
  else
  {
    return false; 
  }
}

extern "C" bool _get (TagLib::File * p, Bmp::DB::Row & row, std::string const& name)  
{
  using namespace Bmp::Library;
  using namespace TagLib;

  struct { 

      Datum     datum;
      char    * id;

  } mb_metadata_xiph[] = {

    { DATUM_MB_ALBUM_ARTIST,                "MUSICBRAINZ_ALBUMARTIST"           },
    { DATUM_MB_ALBUM_ARTIST_ID,             "MUSICBRAINZ_ALBUMARTISTID"         },
    { DATUM_MB_ALBUM_ARTIST_SORTNAME,       "MUSICBRAINZ_ALBUMARTISTSORTNAME"   },
    { DATUM_MB_TRACK_ID,                    "MUSICBRAINZ_TRACKID"               },
    { DATUM_MB_ALBUM_ID,                    "MUSICBRAINZ_ALBUMID"               },
    { DATUM_MB_ARTIST_ID,                   "MUSICBRAINZ_ARTISTID"              },
    { DATUM_MB_ARTIST_SORTNAME,             "MUSICBRAINZ_SORTNAME"              },
    { DATUM_MB_RELEASE_DATE,                "DATE"                              },
    { DATUM_ASIN,                           "AMAZON_ASIN"                       },
    { DATUM_MUSICIP_PUID,                   "MUSICIP_PUID"                      },

  };


  MPC::File *file;

  if (!(file = dynamic_cast<MPC::File*> (p)))
    return false;

  APE::Tag * tag = file->APETag();

  if (tag)
    {
      TagLib::APE::ItemListMap const& items (tag->itemListMap());

      for (unsigned int n = 0; n < G_N_ELEMENTS (mb_metadata_xiph); ++n)
      {
        if (!items[mb_metadata_xiph[n].id].isEmpty())
        {
          row.insert (std::make_pair (Bmp::MetadatumId (mb_metadata_xiph[n].datum), 
              Glib::ustring (items[mb_metadata_xiph[n].id].toString().toCString(true))));
        }
      }

      struct stat tagstat;
      stat(name.c_str(), &tagstat);

      TagLib::ByteVector tagData (tag->render());

      std::string hash =
          Bmp::Util::md5_hex ((char*)(tagData.data()), tagData.size())+(fsizefmt % (unsigned long long int)(tagstat.st_size)).str();

      row.insert (std::make_pair (Bmp::MetadatumId (DATUM_HASH), Glib::ustring(hash)));
      return true;
    }
  else
    {
      return false;
    }
}
