#ifndef BMP_BOOKMARKS_HH
#define BMP_BOOKMARKS_HH

#include <glibmm.h>
#include <gtkmm.h>

#include <libxml/tree.h>
#include <libxml/parser.h>
#include <libxml/xmlreader.h>
#include <libxml/xpath.h>
#include <libxml/xpathInternals.h>

namespace Bmp
{
  namespace Streams
  {
    class Bookmarks
    {
      public:

      Bookmarks ();
      ~Bookmarks();

      class BookmarkColumns  : public Gtk::TreeModelColumnRecord
      {
        public:

          Gtk::TreeModelColumn<Glib::ustring> title;
          Gtk::TreeModelColumn<Glib::ustring> desc;
          Gtk::TreeModelColumn<Glib::ustring> href;

          BookmarkColumns ()
          {
            add (title);
            add (desc);
            add (href);
          };
      };

      BookmarkColumns columns;

      Glib::RefPtr<Gtk::ListStore>
      get_store ()
      {
        return bookmarks;
      };

      GArray* get_array ();

      private:

        void save ();
        bool append_node (Gtk::TreeModel::iterator const& iter, xmlNodePtr root);
        Glib::RefPtr<Gtk::ListStore> bookmarks;
    };
  }//!Streams::
}//!Bmp::
#endif // !BMP_BOOKMARKS_HH
