#include <glibmm/i18n.h>
#include <gtkmm.h>
#include <cstdlib>
#include <cstring>
#include <iostream>
#include <sstream>

#include "paths.hh"
#include "uri++.hh"

#include "dialog-gaim-send-file.hh"
#include "gaim-dbus.hh"

namespace Bmp
{
  namespace Gaim
  {
      SendFile::~SendFile ()
      {
      }

      SendFile::SendFile (BaseObjectType*                       cobject,
                            const Glib::RefPtr<Gnome::Glade::Xml> &xml)

            : Gtk::Dialog (cobject),
              ref_xml     (xml)
      {

        ref_xml->get_widget ("treeview_buddies", treeview);
        ref_xml->get_widget ("label_filename", label_filename);
        ref_xml->get_widget ("okbutton1", okbutton1);

        Gtk::CellRendererPixbuf *cell_pixbuf;
        Gtk::CellRendererText   *cell_text;

        cell_pixbuf = Gtk::manage (new Gtk::CellRendererPixbuf ());
        cell_pixbuf->property_xpad () = 2;

        treeview->append_column ("", *cell_pixbuf);
        treeview->get_column (0)->add_attribute (*cell_pixbuf, "pixbuf", 0);
        treeview->get_column (0)->set_resizable (false);
        treeview->get_column (0)->set_fixed_width (true);
        treeview->get_column (0)->set_fixed_width (true);
        treeview->get_column (0)->property_fixed_width () = 28;

        cell_text = Gtk::manage (new Gtk::CellRendererText ());
        treeview->append_column ("Nickname", *cell_text);
        treeview->get_column (1)->add_attribute (*cell_text, "text", 1);
        treeview->get_column (1)->set_resizable (false);
        treeview->get_column (1)->set_sort_column (1);

        cell_text = Gtk::manage (new Gtk::CellRendererText ());
        treeview->append_column ("Account", *cell_text);
        treeview->get_column (2)->add_attribute (*cell_text, "text", 2);
        treeview->get_column (2)->set_resizable (false);


        liststore = Gtk::ListStore::create (buddies_cr);
        treeview->set_model (liststore);
      }

      SendFile*
      SendFile::create ()
      {
        const std::string path (BMP_GLADE_DIR G_DIR_SEPARATOR_S "dialog-gaim-send-file.glade");
        Glib::RefPtr<Gnome::Glade::Xml> glade_xml = Gnome::Glade::Xml::create (path);
        SendFile *i = 0;
        glade_xml->get_widget_derived ("send_file", i);
        return i;
      }

      Bmp::Gaim::DBUS::Buddy
      SendFile::get_current_buddy ()
      {
        Gtk::TreeModel::iterator m_iter = treeview->get_selection()->get_selected ();
        return ((*m_iter)[buddies_cr.buddy]);
      }

      int
      SendFile::run (const DBUS::OnlineBuddies& buddies, Glib::ustring const& uri)
      {
          Bmp::URI u (uri);
          if (u.get_protocol() != Bmp::URI::PROTOCOL_FILE) okbutton1->set_sensitive (false);

          label_filename->set_text (Glib::filename_to_utf8 (Glib::filename_from_uri (uri)));

          for (DBUS::OnlineBuddies::const_iterator i = buddies.begin (), end = buddies.end(); i != end; ++i)
          {
            Gtk::TreeModel::iterator m_iter = liststore->append();
            DBUS::Buddy const& buddy = (*i);

            (*m_iter)[buddies_cr.protocol]  = render_icon (DBUS::protocol_get_stock_icon_id (buddy.protocol_id), Gtk::ICON_SIZE_BUTTON); 
            (*m_iter)[buddies_cr.alias]     = buddy.alias;
            (*m_iter)[buddies_cr.name]      = buddy.name;
            (*m_iter)[buddies_cr.buddy]     = buddy; 
          }

          liststore->set_sort_column (1, Gtk::SORT_ASCENDING);

          return Gtk::Dialog::run();
      }
  }
}
