//  BMPx - The Dumb Music Player
//  Copyright (C) 2005-2006 BMPx development team.
//
//  This program is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 2 of the License, or
//  (at your option) any later version.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program; if not, write to the Free Software
//  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//
//  --
//
//  The BMPx project hereby grants permission for non GPL-compatible GStreamer
//  plugins to be used and distributed together with GStreamer and BMPx. This
//  permission is above and beyond the permissions granted by the GPL license
//  BMPx is covered by.

#ifndef BMP_POPUP_HH
#define BMP_POPUP_HH

#include <gtkmm.h>
#include <pangomm.h>
#include <cairomm/cairomm.h>
#include <boost/optional.hpp>

#include "playbacksource.hh"

namespace Bmp
{
  class Popup : public Gtk::Window
  {
    public:

      Popup (GtkWidget *                      widget,
             Gdk::Color const&                outline,
             Gdk::Color const&                inlay,
             Glib::RefPtr<Gdk::Pixbuf> const& image,
             Glib::ustring const&             text);

      ~Popup ();

      void
      tooltip_mode (bool mode = true, bool immediate = false);

      void
      set_info (Bmp::SimpleTrackInfo const& sti);

      void
      set_source_icon (Glib::RefPtr<Gdk::Pixbuf> icon);

      void
      set_coords (int x,
                  int y);

    protected:

      virtual bool
      on_expose_event (GdkEventExpose * event);

      virtual bool
      on_button_press_event (GdkEventButton * event);

      virtual void
      on_realize ();

      virtual void
      on_map ();

      virtual void
      on_unmap ();

      virtual void
      on_show ();
  
    private:

      enum ArrowLocation
      {
        ARROW_TOP,
        ARROW_BOTTOM,
      };

      enum ArrowPosition
      {
        ARROW_POS_DEFAULT,
        ARROW_POS_LEFT,
        ARROW_POS_RIGHT,
      };

      void
      reposition ();

      void
      update_mask ();

      void
      disappear ();

      void
      acquire_widget_info (int & x,
                           int & y,
                           int & width,
                           int & height);

      void
      draw_arrow (Cairo::RefPtr<Cairo::Context> & cr,
                  int                             width,
                  int                             height);

      void
      draw_arrow_outline (Cairo::RefPtr<Cairo::Context> & cr,
                          int                             width,
                          int                             height);

      void
      draw_arrow_mask (Cairo::RefPtr<Cairo::Context> & cr,
                       int                             width,
                       int                             height);

      void
      queue_update ();

      bool
      update_frame ();

      GtkWidget                 * m_widget;
      Gdk::Color                  m_outline, m_inlay;
      Glib::RefPtr<Gdk::Pixbuf>   m_image;
      Glib::RefPtr<Gdk::Pixbuf>   m_default_image;
      Glib::RefPtr<Gdk::Pixbuf>   m_source_icon;
      Glib::ustring               m_text;
      bool                        m_border;
      bool                        m_fade;

      Glib::Timer                 m_timer;
      sigc::connection            m_update_connection;
      double                      m_time_offset;

      Glib::RefPtr<Pango::Layout> m_layout;
      bool                        m_has_alpha;
      int                         m_width;
      int                         m_height;
      int                         m_ax;
      int                         m_x, m_y;

      ArrowLocation               m_location;
      ArrowPosition               m_position;

      bool                        m_tooltip_mode;

      Glib::RefPtr<Pango::Layout> m_layout_l;
      Glib::RefPtr<Pango::Layout> m_layout_r;

      boost::optional<Glib::ustring> m_asin;
  };
}

#endif
