//  BMPx - The Dumb Music Player
//  Copyright (C) 2005-2006 BMPx development team.
//
//  This program is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 2 of the License, or
//  (at your option) any later version.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program; if not, write to the Free Software
//  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//
//  --
//
//  The BMPx project hereby grants permission for non GPL-compatible GStreamer
//  plugins to be used and distributed together with GStreamer and BMPx. This
//  permission is above and beyond the permissions granted by the GPL license
//  BMPx is covered by.

#ifndef BMP_FILE_UTILS_HH
#define BMP_FILE_UTILS_HH

#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <vector>
#include <string>
#include <glibmm.h>

namespace Bmp
{
  namespace Util
  {
    typedef std::vector<std::string> FileList;
    typedef sigc::slot<bool, std::string> DirForeachSlot;

    void
    dir_for_each_entry (const std::string &path,
                        DirForeachSlot     slot);

    bool
    find_file (const std::string &dir_path,
               const std::string &filename,
               std::string       &found_path,
               int                max_depth = -1);

    void
    del_directory (const std::string &dir_path);

    void
    collect_path (const std::string &dir_path,
                  FileList          &collection,
                  bool               clear = true);

    char *
    create_glob (const std::string &suffix);

    bool
    compare_files (const std::string &file1,
                   const std::string &file2);

    void
    copy_file (const std::string &source,
               const std::string &dest);

    void
    files_writable (const FileList &list,
                    FileList       &non_writable);

    // We currently only tag with taglib, so this is limited to ogg, mp3 and mpc
    bool
    files_taggable (const FileList &list);

  }//!Util::
}//!Bmp::

#endif // !BMP_FILE_UTILS_HH
