/***************************************************************************
                          dlgsettings.h  -  description
                             -------------------
    begin                : Sat Nov 16 2002
    copyright            : (C) 2002 by Ken Schenke
    email                : kschenke at users dot sourceforge dot net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful, but   *
 *   WITHOUT ANY WARRANTY; without even the implied warranty of            *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU      *
 *   General Public License for more details.                              *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the Free Software           *
 *   Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA         *
 *   02110-1301, USA                                                       *
 *                                                                         *
 ***************************************************************************/

#ifndef DLGSETTINGS_H
#define DLGSETTINGS_H

#include <QDialog>

#include "ui_dlgsettings.h"
#include "bridgecfg.h"

/***************************************************************************
 *                                                                         *
 *   The DlgSettings class represents the settings dialog box.             *
 *                                                                         *
 ***************************************************************************/

class DlgSettings : public QDialog, public Ui::DlgSettings
{
	Q_OBJECT;

public:
	DlgSettings(const BridgeCfg &cfg, QWidget* parent = 0);
	virtual ~DlgSettings();

public slots:
	void on_buttonAdd_clicked(void);
	void on_listBrowsers_itemSelectionChanged(void);
	void on_editDesc_textChanged(const QString &text);
	void on_buttonDelete_clicked(void);
	void on_buttonBrowse_clicked(void);
	void on_checkReadonly_clicked(void);

	const BridgeCfg & cfg(void) { return m_cfg; }

private:
	BridgeCfg m_cfg;

	void    RefreshButtons(void);
	void    RefreshList(void);
};

#endif  // end of DLGSETTINGS_H
