[-- template default.template --]
[-- define title=Compiling BookmarkBridge From Source --]
[-- define chapter_title=3. How BookmarkBridge Works --]
[-- define prev_link=theory_of_operation.html --]
[-- define prev_title=Theory of Operation --]
[-- define next_link=source_code_roadmap.html --]
[-- define next_title=Source Code Roadmap --]

<p>
Since BookmarkBridge is a multi-platform program, the instructions for compiling from
the source code differ a bit between platforms.  Even though the procedure for compiling
BookmarkBridge may differ between platforms, the source code itself is exactly the
same, whether for Windows or Unix.  All files necessary for compiling it for all
supported platforms are present in the source distribution.
</p>

<h3>Development Pre-requisites</h3>
<p>
BookmarkBridge was written using a few open-source toolkits.  Before compiling
BookmarkBridge under Windows or Unix, you must ensure these development kits are
available on your computer.
<dl>
	<dt>Qt</dt>
	<dd>
		Qt is a multi-platform GUI development framework available for Windows,
		Unix (X11), and Macintosh.  For Unix you need to make sure you have
		the <b>Qt/X11 Open Source Edition</b>.  For Windows you need to obtain the
		<b>Qt/Windows Open Source Edition</b>.  Both are available free from
		TrollTech at www.trolltech.com.  BookmarkBridge requires Qt 4.0.1.
	</dd>
	<dt>Libxml</dt>
	<dd>
		Libxml is an off-shoot of the Gnome Desktop Environment.  It is a
		toolkit used for reading and writing XML and HTML files.
		BookmarkBridge is written to use libxml2.  You can download a
		development toolkit at www.xmlsoft.org.
	</dd>
</dl>
</p>

<h3>Compiling BookmarkBridge for Windows</h3>
<p>
Compiling BookmarkBridge for Windows is not for the faint of heart.  The requirements
for your build environment will take some time and patience to set up.  You will need
the Cygwin POSIX environment.  Make sure you select the libxml-devel package.
The Qt 4.0.1 open source edition for Windows requires the MinGW compiler, available at
www.mingw.org.
</p>

<p>
As part of the source distribution I provide a .pro file.
Before compiling you need to be sure the include.  The qmake program will produce a
makefile suitable for your system from the .pro file.
</p>

<h3>Compiling BookmarkBridge for Unix</h3>
<p>
On Unix, BookmarkBridge uses the standard GNU build procedure.  Just run the following
commands at a shell prompt:
</p>

<pre>
#: ./configure
#: make
#: make install
</pre>

<p>
</p>

<p>
As of this this time (the year 2005) no Linux distros come with Qt 4.x.  You will need
to obtain and build it if you can't find a pre-built package for your distro.
</p>

<p>
If you receive an error message during compilation that the file
<b>&lt;libxml/parser.h&gt;</b> is missing, then you can tell configure
where to find the files.  As discussed in the <b>Development Pre-requisites</b>
section above, you must have the development files for libxml2 installed.  The default is <b>/usr/include/libxml2</b>, but you can use the following:

<pre>#: ./configure --with-libxml2-include=/usr/local/include/libxml2</pre>

<p>Is this case,</p>

<pre>/usr/local/include/libxml2</pre>

<p>
is the directory where the compiler can expect to find the libxml directory containing
the include files for libxml2.
</p>


</p>
