/*************************************************
* GMP Wrapper Header File                        *
* (C) 1999-2005 The Botan Project                *
*************************************************/

#ifndef BOTAN_EXT_GNU_MP_WRAP_H__
#define BOTAN_EXT_GNU_MP_WRAP_H__

#include <botan/bigint.h>
#include <gmp.h>

namespace Botan {

/*************************************************
* Lightweight GMP mpz_t Wrapper                  *
*************************************************/
class GNU_MPZ
   {
   public:
      mpz_t value;

      BigInt to_bigint() const;
      void encode(byte[], u32bit) const;
      u32bit bytes() const;

      GNU_MPZ& operator=(const GNU_MPZ&);

      GNU_MPZ(const GNU_MPZ&);
      GNU_MPZ(const BigInt& = 0);
      GNU_MPZ(const byte[], u32bit);
      ~GNU_MPZ();
   };

}

#endif
