/*************************************************
* POSIX Thread Mutex Source File                 *
* (C) 1999-2005 The Botan Project                *
*************************************************/

#ifndef _POSIX_C_SOURCE
  #define _POSIX_C_SOURCE 199506
#endif

#include <botan/mux_pthr.h>
#include <botan/exceptn.h>
#include <pthread.h>

namespace Botan {

/*************************************************
* Wrapper Type for POSIX Thread Mutex            *
*************************************************/
struct mutex_wrapper
   {
   pthread_mutex_t mutex;
   };

/*************************************************
* Constructor                                    *
*************************************************/
Pthread_Mutex::Pthread_Mutex()
   {
   mutex = new mutex_wrapper;
   if(pthread_mutex_init(&(mutex->mutex), 0) != 0)
      throw Exception("Pthread_Mutex: initialization failed");
   }

/*************************************************
* Destructor                                     *
*************************************************/
Pthread_Mutex::~Pthread_Mutex()
   {
   if(pthread_mutex_destroy(&(mutex->mutex)) != 0)
      throw Invalid_State("Pthread_Mutex: mutex is locked in destructor");
   delete mutex;
   }

/*************************************************
* Lock the Mutex                                 *
*************************************************/
void Pthread_Mutex::lock()
   {
   if(pthread_mutex_lock(&(mutex->mutex)) != 0)
      throw Exception("Pthread_Mutex::lock: Error occured");
   }

/*************************************************
* Unlock the Mutex                               *
*************************************************/
void Pthread_Mutex::unlock()
   {
   if(pthread_mutex_unlock(&(mutex->mutex)) != 0)
      throw Exception("Pthread_Mutex::unlock: Error occured");
   }

}
