#!/usr/bin/python

import sys, os, re, botan

class Test:
    def __init__(self, name, data):
        self.name = name

        self.input = data[0]
        self.output = data[1]

        self.key = None
        self.iv = None

        if len(data) > 2:
            self.key = data[2]

        if len(data) > 3: 
            self.iv = data[3]

    def __str__(self):
        s = "Test of %s\n  In:  %s\n  Out: %s\n" % \
            (self.name, self.input, self.output);
        if self.key != None:
            s = "%s  Key: %s\n" % (s, self.key)
        if self.iv != None:
            s = "%s  IV:  %s\n" % (s, self.iv)
        return s

    def passes(self):
        return True

def tests_in(filename):
    file = open(filename, 'r')
    section = ''
    data = ''

    for line in file:
        line = line[0:line.find('#')].strip()
        if not line:
            continue

        match = re.search('\[(.*)\]', line)
        if match:
            section = match.group(1)
            continue

        data = data + line

        if line[-1] != '\\':
            yield Test(section, data.replace('\\', '').split(':'))
            data = ''

def main():
    for test in tests_in('validate.dat'):
        if not test.passes():
            print "FAILED!", test

if __name__ == '__main__':
   sys.exit(main())
