
/*
 *  Diverse Bristol audio routines.
 *  Copyright (c) by Nick Copeland <nick.copeland@ntlworld.com> 1996,2002
 *
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */

//#define DEBUG

#include <sys/types.h>
#include <sys/socket.h>
#include <signal.h>
#include <unistd.h>

#include "bristol.h"
#include "brightonMini.h"

extern guimain global;

struct sockaddr address;

static int enginepid;

/*
 * Free any memory we have have used up, close the link to the control socket
 * potentially sending a disconnect request.
 */
void
cleanupBristol()
{
	bristolMidiMsg msg;
	guiSynth *synth;
	int result;

#ifdef DEBUG
	printf("cleanupBristol()\n");
#endif
printf("cleanupBristol(%i)\n", global.controlfd);

	if (global.controlfd >= 0)
	{
		for (synth = global.synths; synth != 0; synth = synth->next)
		{
			bristolMidiSendMsg(global.controlfd, synth->sid,
				127, 0, BRISTOL_EXIT_ALGO);
			if ((result = bristolMidiRead(global.controlfd, &msg)) < 0)
				printf("socket closed\n");
#warning need to ensure read message pends
			if (global.libtest == 0)
				sleep(1);
			printf("request acked: %i\n", result);
		}
	}

	/*
	 * I do not like killing the engine with a signal, I would prefer to send
	 * it a message requesting it terminate itself. If there are no more 
	 * bristolAudio's active, the engine will exit gracefully.
	if (global.enginePID > 0)
		kill(guimain.enginePID, SIGINT);
	 */

	/*
	 * This is not actually an FD, but a libbristolmidi handle.
	 */
	if (global.controlfd > 0)
		bristolMidiClose(global.controlfd);

	exit(0);
}

