
/*
 *  Diverse Bristol audio routines.
 *  Copyright (c) by Nick Copeland <nick.copeland@ntlworld.com> 1996,2002
 *
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */

//#define DEBUG

#include "bristol.h"

int midiHandle;
bristolMidiMsg midiMsg;

extern int midiExitReq;

midiHandler bristolMidiRoutines[8];

void *
midiMsgHandler(bristolMidiMsg *msg, audioMain *audiomain)
{
#ifdef DEBUG
	printf("midiMsgHandler(%x, %x)\n", msg, audiomain);
	printMidiMsg(msg);
#endif

	/*
	 * Depending on the message type, handle the message.
	 */
	bristolMidiRoutines[(msg->command & ~MIDI_STATUS_MASK) >> 4]
		(audiomain, msg);
}

extern int exitReq;

void *
midiThread(audioMain *audiomain)
{
	char *device = bAMD;
	int flags = BRISTOL_CONN_MIDI;

#ifdef DEBUG
	printf("starting midi thread\n");
#endif

	audiomain->mtStatus = BRISTOL_WAIT;

	initMidiRoutines(audiomain, bristolMidiRoutines);

printf("	flags are %08x\n", audiomain->flags);
	if ((audiomain->flags & BRISTOL_MIDIMASK) == BRISTOL_MIDI_OSS)
	{
printf("midi oss\n");
		flags = BRISTOL_CONN_OSSMIDI;
		device = bOMD;
	}

	if ((audiomain->flags & BRISTOL_MIDIMASK) == BRISTOL_MIDI_SEQ)
	{
printf("midi sequencer\n");
		flags = BRISTOL_CONN_SEQ;
		device = bOMD;
	}

	if (audiomain->mididev != (char *) NULL)
		device = audiomain->mididev;

	/*
	 * Get a control port.
	 */
	if ((midiHandle = bristolMidiOpen("localhost",
		BRISTOL_DUPLEX|BRISTOL_CONN_TCP|BRISTOL_CONN_PASSIVE, audiomain->port,
		BRISTOL_REQ_SYSEX, midiMsgHandler, audiomain)) < 0)
	{
		printf("Error opening control device, exiting midi thread\n");
		audiomain->atReq = BRISTOL_REQSTOP;
		exitReq = 1;
		pthread_exit(-1);
	}

	if ((midiHandle = bristolMidiOpen(device, flags|BRISTOL_DUPLEX,
		-1, BRISTOL_REQ_NSX, midiMsgHandler, audiomain)) < 0)
	{
		printf("Error opening midi device %s, exiting midi thread\n", device);
		audiomain->atReq = BRISTOL_REQSTOP;
		exitReq = 1;
		pthread_exit(-1);
	}

#ifdef DEBUG
	printf("opened midi device\n");
#endif

	audiomain->mtStatus = BRISTOL_OK;
	/*
	 * This will become blocking midi code, now that we are threaded. In short,
	 * midiCheck should not return. This can be an issue to ensure that the
	 * midi device is closed.
	 */
	midiCheck();

	bristolMidiClose(midiHandle);

	if ((audiomain->debuglevel & BRISTOL_DEBUG_MASK) > BRISTOL_DEBUG1)
		printf("midiThread exiting\n");

	pthread_exit(0);
}

printMidiMsg(bristolMidiMsg *msg)
{
	if (msg->command == 0x00f0) {
		printf("	handle:	%i\n", msg->midiHandle);
		printf("	command:	SYSEX\n");
	} else {
		printf("	handle:	%i\n", msg->midiHandle);
		printf("	chan:	%i\n", msg->channel);
		printf("	command:	%x\n", msg->command);
		printf("	p1:	%i, p2:	%i\n",
			msg->params.key.key, msg->params.key.velocity);
	}
}

