
/*
 *  Diverse Bristol audio routines.
 *  Copyright (c) by Nick Copeland <nick.copeland@ntlworld.com> 1996,2002
 *
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */

/*
 * Some structures for device management. These are for the library internal,
 * and not for anybody using the API. If you want to use the midi library, use
 * bristolmdidiapi.h
 *
 * This controls messages on any given midi channel, handles that have been
 * opened for any channel, and global control structures.
 */

#ifndef _BRISTOL_MIDI_H
#define _BRISTOL_MIDI_H

#include "bristolaudio.h"

#ifdef ADLIB
#if ADLIB == -1
#undef ADLIB
#elif ADLIB == 2
#include <alsa/asoundlib.h>
#elif ADLIB == 1
#include <sys/asoundlib.h>
#elif ADLIB == 0
#include <alsa/asoundlib.h>
#endif /* if ADLIB */
#endif /* ADLIB */

#include "bristolmidiapi.h"

#define BRISTOL_SOCKNAME "/tmp/.bristol"

#define BRISTOL_PERMMASK 0x00f
#define BRISTOL_CONNMASK 0xff0

/*
 * Global limits
 */
#define BRISTOL_MIDI_DEVCOUNT 8
#define BRISTOL_MIDI_HANDLES 16
#define BRISTOL_MIDI_CHCOUNT 64
#define BRISTOL_MIDI_BUFSIZE 64

/*
 * Control flags
#define BRISTOL_ALSA_RAWMIDI 1
#define BRISTOL_OSS_RAWMIDI 2
#define BRISTOL_ALSA_SEQ 3
 */

#define BRISTOL_MIDI_TERMINATE 0x80000000
#define BRISTOL_MIDI_INITTED 0x40000000

/*
 * Channel state flags
 */
#define BRISTOL_CHANSTATE_WAIT 0
#define BRISTOL_CHANSTATE_WAIT_1 1
#define BRISTOL_CHANSTATE_WAIT_2 2
#define BRISTOL_CHANSTATE_WAIT_3 3

typedef struct BristolMidiChannel {
	int channel;
	int handle;
	int command;
	int state;
	int count; /* Of current number of bytes for this command */
} bristolMidiChannel;

typedef struct BristolMidiHandle {
	int handle;
	int state;
	int channel;
	int dev;
	unsigned int flags;
	int messagemask;
	int (*callback)();
	void *param;
} bristolMidiHandle;

#ifdef ADLIB
typedef struct BristolALSADev {
	snd_rawmidi_t *handle; /* ALSA driver handle */
} bristolALSADev;

typedef struct BristolSeqDev {
	snd_seq_t *handle; /* ALSA driver handle */
} bristolSeqDev;
#endif /* ADLIB */

typedef struct BristolMidiDev {
	char name[64];
	int state;
	unsigned int flags;
	int fd;
	int lastchan;
	int lastcommand;
	int lastcommstate;
	int handleCount; /* numberof handles using this dev */
	struct {
		int count;
		bristolMsg *bm;
	} sysex;
	union {
#ifdef ADLIB
		bristolALSADev alsa; /* ALSA driver handle */
		bristolSeqDev seq; /* ALSA sequencer driver handle */
#endif
		/*
		 * And descriptor types for any other dev libraries.
		 */
	} driver;
	unsigned char buffer[BRISTOL_MIDI_BUFSIZE];
	int bufcount;
	int bufindex;
	bristolMidiChannel I_channel[BRISTOL_MIDI_CHANNELS];
	bristolMidiChannel O_channel[BRISTOL_MIDI_CHANNELS];
	bristolMidiMsg msg;
} bristolMidiDev;

typedef struct BristolMidiMain {
	unsigned int flags;
	bristolMidiDev dev[BRISTOL_MIDI_DEVCOUNT];
	bristolMidiHandle handle[BRISTOL_MIDI_HANDLES];
} bristolMidiMain;

#endif // _BRISTOL_MIDI_H

