/********************************************************************
 * Copyright (C) 2005 Piotr Pszczolkowski
 *-------------------------------------------------------------------
 * This file is part of BsC (Beesoft Commander).
 *
 * BsC is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * BsC is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with BsC; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *******************************************************************/
#ifndef INCLUDED_BUSY_H
#define INCLUDED_BUSY_H

/*------- include files:
------------------------------------------------------------------*/
#ifndef INCLUDED_QOBJECT_H
#include <qobject.h>
#define INCLUDED_QOBJECT_H
#endif // INCLUDED_QOBJECT_H

/*------- forward declaration:
-------------------------------------------------------------------*/
class QEvent;

/*------- class declaration:
--------------------------------------------------------------------*/
class Busy : public QObject
{
public:
	static void set_busy( bool in_on );

protected:
	bool eventFilter( QObject*, QEvent* );

private:
    Busy(); // Disable constructor
    Busy( const Busy& );
    Busy& operator=( const Busy& );
    
    static Busy* d_instance;
    bool d_isOn;
};

#endif // INCLUDED_BUSY_H
