/********************************************************************
 * Copyright (C) 2005 Piotr Pszczolkowski
 *-------------------------------------------------------------------
 * This file is part of BsC (Beesoft Commander).
 *
 * BsC is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * BsC is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with BsC; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *******************************************************************/
#ifndef INCLUDED_CMPFILES_H
#define INCLUDED_CMPFILES_H

/*------- includes files:
-------------------------------------------------------------------*/
#include <qobject.h>

#ifndef INCLUDED_QSTRING_H
#include <qstring.h>
#define INCLUDED_QSTRING_H
#endif // INCLUDED_QSTRING_H

#ifndef INCLUDED_CSTDLIB
#include <cstdlib>
#define INCLUDED_CSTDLIB
#endif // INCLUDED_CSTDLIB

class CmpFiles : public QObject
{
	Q_OBJECT
// ******* CONSTRUCTION *******
public:
	CmpFiles( QObject* in_parent, const QString& in_name_1, const QString& in_name_2 )
	: QObject( in_parent )
	, d_name_1( in_name_1 )
	, d_name_2( in_name_2 )
	, d_loop( TRUE )
	{}
private:
	CmpFiles( const CmpFiles& );
	CmpFiles& operator=( const CmpFiles& );

// ******* TYPES *******
private:
	enum { BufferSize = 4096 };
public:
	typedef enum {
		IOError = 0,
		Break,
		Equal,
		NotEqual
	} CmpResult;
	
// ******* MEMBERS *******
private:
	const QString d_name_1;
	const QString d_name_2;
	bool  d_loop;
	char d_buffer_1[ BufferSize ];
	char d_buffer_2[ BufferSize ];

// ******* METHODS *******
public:
	CmpResult compare();
private:
	CmpResult compare_buffers( const int ) const;
private slots:
	void stop();
};

//*******************************************************************
// compare_buffers                                           PRIVATE
//*******************************************************************
inline CmpFiles::CmpResult CmpFiles::compare_buffers( const int n_bytes ) const
{
	return ( 0 == memcmp( d_buffer_1, d_buffer_2, n_bytes ) ) ? Equal : NotEqual;
}
// end of compare_buffers

inline void CmpFiles::stop()
{
	d_loop = FALSE;
}


#endif // INCLUDED_CMPFILES_H
