/********************************************************************
 * Copyright (C) 2005, 2006 Piotr Pszczolkowski
 *-------------------------------------------------------------------
 * This file is part of BSCommander (Beesoft Commander).
 *
 * BsC is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * BsC is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with BsC; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *******************************************************************/
#ifndef INCLUDED_HELP_H
#define INCLUDED_HELP_H

/*------- include files:
-------------------------------------------------------------------*/
#ifndef INCLUDED_QDIALOG_H
#include <qdialog.h>
#define INCLUDED_QDIALOG_H
#endif // INCLUDED_QDIALOG_H

/*------- forward declarations:
-------------------------------------------------------------------*/
class QTextBrowser;
class QPushButton;

/*------- class declaration:
-------------------------------------------------------------------*/
class Help : public QDialog
{
	Q_OBJECT

// ******* CONSTRUCTION *******
public:
	Help( QWidget* const in_parent );
private:
	Help( const Help& );
	Help& operator=( const Help& );

// ******* CONSTANTS *******
private:
	static const QString help_text[];
		
// ******* MEMBERS *******
private:
	QTextBrowser* const d_viewer;
	QPushButton*  const d_return_btn;

// ******* METHODS *******
private:
	void set_viewer_text();
	void polish();
};

#endif // INCLUDED_HELP_H
