/*=========================================================================

  Program:   CABLE - CABLE Automates Bindings for Language Extension
  Module:    $RCSfile: cxxConversions.h,v $
  Language:  C++
  Date:      $Date: 2002/10/23 21:35:02 $
  Version:   $Revision: 1.8 $

  Copyright (c) 2002 Kitware, Inc., Insight Consortium.  All rights reserved.
  See Copyright.txt for details.

     This software is distributed WITHOUT ANY WARRANTY; without even 
     the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
     PURPOSE.  See the above copyright notices for more information.

=========================================================================*/
#ifndef _cxxConversions_h
#define _cxxConversions_h

// Include all the type representations.
#include "cxxTypes.h"

namespace _cxx_
{

/**
 * A set of utilities for conversion tests.
 */
class _cxx_EXPORT Conversions
{
public:
  static bool ReferenceCanBindAsIdentity(const CvQualifiedType& from,
                                         const ReferenceType* to);
  static bool ReferenceCanBindAsDerivedToBase(const CvQualifiedType& from,
                                              const ReferenceType* to);
  static bool IsValidQualificationConversion(const PointerType* from,
                                             const PointerType* to);
  static bool CanConvert(const CvQualifiedType& from,
                         const CvQualifiedType& to);
private:
  static bool ReferenceBinding(const CvQualifiedType& from,
                               const CvQualifiedType& to);
};

} // namespace _cxx_

#endif
