/*
 * Caudium - An extensible World Wide Web server
 * Copyright  2000-2004 The Caudium Group
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */
/*
 * $Id: camas_preferences_imap.pike,v 1.13.2.2 2004/03/28 20:40:54 vida Exp $
 */

#include <module.h>
#include <camas/globals.h>
inherit "module";

constant cvs_version="$Id: camas_preferences_imap.pike,v 1.13.2.2 2004/03/28 20:40:54 vida Exp $";
constant module_type = MODULE_PROVIDER;
constant module_name = "CAMAS: Preferences IMAP";
constant module_doc  = "IMAP preferences module for CAMAS. This module will take care of retrieving "
                       "and storing preferences from an IMAP mail folder for other CAMAS modules.<br/>"
                       "This module is automatically selected if you select Camas Addressbook user's preferences.<br/>"
                       "<i>Note</i>: If you load several preferences modules, Camas will store "
                       "information on each of them allowing you to migrate easily among them. "
                       "It will also try to load the preferences for each of them in the order of "
                       "the priority of each module. In this mode, it will stop after the first successfull "
                       "module. <br />";
constant module_unique = 1;
constant thread_safe = 1;		// I think this module should be :)

string defaultprefsbox;

void create()
{
#ifdef CAMAS_DEBUG
  defvar("debug",0,"Debug",TYPE_FLAG,"Debug the call / errors into Caudium "
         "error log ?");
#endif
   defvar("defaultprefsbox", "imhoprefs", "User preferences folder", TYPE_STRING,
         "Mail folder to hold user preferences. Relative to the default mail folder path. "
         "This option can be overridden by a different setting in the IMAP server list.<br />"
         "<b>Note</b>: You should not have any '.' if using '.' as a namespace (usually "
         "the case if you put 'INBOX.' in IMAP mail folder path).");
  defvar("autocreate", 1, "Auto create the folder", TYPE_FLAG,
         "If set to yes, the IMAP folder used to store preferences will be automatically created.<br />");
  defvar("logoutsave", 0, "Always save preferences on logout",
         TYPE_FLAG, "If set the preferences will always be saved for this module "
	 "when the user logout. This is useful for migrating the preferences "
	 "from other method to this one");
}

void start(int cnt, object conf)
{
  defaultprefsbox = QUERY(defaultprefsbox);
}

string status()
{
  string out = "Using folder " + QUERY(defaultprefsbox);
  return out;
}

string query_provides()
{
  return("camas_preferences");
}

void stop()
{
}

/*
 * What we provide here
 */

//
//! method: int version(void)
//!  Give the CAMAS_PREFERENCES api version
//!  supported by the module
//! returns:
//!  the version of the API
//
int version()
{
  return 1;
}

//
//! method: mixed set_preferences(object id)
//!  Save the preferences into this module method
//! returns:
//!  a void by default
//!  an array containing the IMAP commands if using the 
//!  the IMAP module
//
mixed set_preferences(object id)
{
  return ({ CAMAS.IMAPTools.imap_cmd ("save_user_prefs") });
}

//
//! method: mixed get_preferences(object id)
//!  Get the preferences from this module method
//! returns:
//!  a void by default
//!  an array containing the IMAP commands if using the 
//!  the IMAP module
//
mixed get_preferences(object id)
{
  array commands = ({ });
  
  if(QUERY(autocreate))
  {
    string tocreate;
    tocreate = CAMAS.Tools.strip(CSESSION->baseprefsbox);
    commands += ({
                  CAMAS.IMAPTools.imap_cmd("create",
                  "newmailbox", tocreate, 
		  "addmailpath", 1, "createonlyifnotexists", 1)
                });
  }
  commands += ({ CAMAS.IMAPTools.imap_cmd("load_user_prefs","abortfail",0)  });
  return commands;
}

//
//! method: mixed save_on_logout(id)
//!  Do we have to save the preferences on each user logout ?
//! returns:
//!  a void by default
//!  an array containing the IMAP commands if using the 
//!  the IMAP module
//
mixed save_on_logout(object id)
{
  if(QUERY(logoutsave))
    return set_preferences(id);
}

/*
 * If you visit a file that doesn't contain these lines at its end, please     
 * cut and paste everything from here to that file.                            
 */                                                                            

/*
 * Local Variables:                                                            
 * c-basic-offset: 2                                                           
 * End:                                                                        
 *                                                                             
 * vim: softtabstop=2 tabstop=2 expandtab autoindent formatoptions=croqlt smartindent cindent shiftwidth=2
 */

/* START AUTOGENERATED DEFVAR DOCS */

//! defvar: debug
//! Debug the call / errors into Caudium error log ?
//!  type: TYPE_FLAG
//!  name: Debug
//
//! defvar: defaultprefsbox
//! Mail folder to hold user preferences. Relative to the default mail folder path. This option can be overridden by a different setting in the IMAP server list.<br /><b>Note</b>: You should not have any '.' if using '.' as a namespace (usually the case if you put 'INBOX.' in IMAP mail folder path).
//!  type: TYPE_STRING
//!  name: User preferences folder
//
//! defvar: autocreate
//! If set to yes, the IMAP folder used to store preferences will be automatically created.<br />Warning: this option will only work if you enable Mailboxes in Camas Features -&gt; Features.
//!  type: TYPE_FLAG
//!  name: Auto create the folder
//
//! defvar: logoutsave
//! If set the preferences will always be saved for this module when the user logout. This is useful for migrating the preferences from other method to this one
//!  type: TYPE_FLAG
//!  name: Always save preferences on logout
//

/*
 * If you visit a file that doesn't contain these lines at its end, please
 * cut and paste everything from here to that file.
 */

/*
 * Local Variables:
 * c-basic-offset: 2
 * End:
 *
 * vim: softtabstop=2 tabstop=2 expandtab autoindent formatoptions=croqlt smartindent cindent shiftwidth=2
 */

