//
//  Wrappers.m
//  CamelBones
//
//  Copyright (c) 2004 Sherm Pendley. All rights reserved.
//

#import "Wrappers.h"
#import "PerlImports.h"

// Create a Perl object that wraps an Objective-C object
// The wrapper will be blessed into the "NSObject" package.
SV* CBCreateWrapperObject(id obj) {
    return CBCreateWrapperObjectWithClassName(obj, [obj className]);
}

// Create a Perl object that wraps an Objective-C object.
// The wrapper will be blessed into className.
SV* CBCreateWrapperObjectWithClassName(id obj, NSString* className) {
    // Define a Perl context
    dTHX;

    SV *sv = CBCreateObjectOfClass(className);
    const char *key = "NATIVE_OBJ";
    hv_store((HV*)SvRV(sv), key, strlen(key), newSViv((int)obj), 0);
    return sv;
}

// Create a new Perl object blessed into the specified package
SV* CBCreateObjectOfClass(NSString *className) {
    // Define a Perl context
    dTHX;

    HV *hv = newHV();
    SV *ret = newRV_inc((SV *)hv);
    sv_bless(ret, gv_stashpv([className UTF8String], 0));
    return ret;
}

