;;; @file prlink.s
;;; Transfer routines for the 4-bit/8-bit and 8-bit/8-bit PET/C64/C128/Vic-20
;;; to Centronics cables designed by Marko Mkel and Olaf Seibert
;;; @author Marko Mkel (msmakela@nic.funet.fi)
;;; @author Olaf Seibert (seibert@mbfys.kun.nl)

	;; additional commands for info mode
#define infoinit
	;; initialize the cable
#if host = 20			; set CB1 to trigger on falling edge
#define initcable lda #$ef:and ack:sta ack
#else
#if host >= 201 && host <= 203	; trigger CA1 on falling edge, manual CB2
#define initcable lda ack:and #$fe:ora #$e0:sta ack
#else
#define initcable
#endif
#endif

	;; deinitialize the cable
#define deinitcable
	;; determine whether a request is pending (-FLAG signal)
#define isrequest lda #strval:bit strobe:beq return:ldx #0:stx ddr

	;; wait for -FLAG (or CA1 or CB1) to drop
#if clearviaifr
#define prlink_hs .(:lda #strval:loop bit strobe:beq loop:.):sta strobe
#else
#define prlink_hs .(:lda #strval:loop bit strobe:beq loop:.)
#endif
	;; clear possible bounces on the -FLAG signal
#if ciadebounce
#define debounce bit strobe
#else
#define debounce
#endif

	; .A <- data, .Y <- 00, .X preserved
receive_switch:
	prlink_hs

		;;; and only then switch data direction.
	lda #0	; switch back to inputs
	sta ddr

	beq receive1	; branch always
receive:
#if clearviaifr
rereceive:	; rereceive (without handshake) is only different for the CIA
#endif
	prlink_hs
#if clearviaifr
#else
rereceive:	; rereceive (receive without handshaking) for the CIA
#endif		; clearviaifr
receive1:
	lda #ackval
	eor ack
	ldy data	; read the byte
	debounce
	sta ack	; acknowledge
	tya
	ldy #0
	rts

	; .A trashed, .Y <- 00, .X preserved
send_switch:
		;;; wait for first part of handshake
	tay
	prlink_hs
		;;; and only then switch data direction.
#if prlink88
	lda #$ff
#else
	lda #$0f
#endif
	sta ddr	; set the data lines to output
	bne send1	; branch always

send:
	tay
	prlink_hs
send1:
#if prlink88
#else
	tya
	sta data	; send the low nibble
	lsr
	lsr
	lsr
	lsr
	tay		; move the high nibble to y
	lda #ackval
	eor ack
	debounce
	sta ack	; ack -> the low nibble is on the bus
	prlink_hs
#endif		; prlink88
	sty data	; send the high nibble (or the whole byte, for prlink88)
	ldy #0
	lda ack
	eor #ackval
	debounce
	sta ack	; ack -> the high nibble is on the bus
	rts
