;;; @file c64common.s
;;; Common definitions for Commodore 64 like computers (c64 and c128)
;;; @author Marko Mkel (msmakela@nic.funet.fi)

;;; in the 6522, the interrupt flag has to be reset
clearviaifr = 0
;;; in the 6526, the FLAG line may need debouncing in the C64/C128
ciadebounce = 1

;;; Commodore serial bus definitions
iecport1 = $dd00
iecport2 = iecport1
atno = 8
clko = 16
dato = 32
clki = 64
dati = 128
;;; Commodore cassette port definitions
c2nread = $dc0d
c2nrdval = 16
c2nwrite = 1
c2nwrval = 8

;;; miscellanous
strval	= $10	; strobe bit value

;;; 6551 ACIA definitions (for a 6551 hooked at -I/O1)
acia = $de00
r6551dt = acia			; transmit/receive data
r6551sr = acia + 1		; programmed reset/status register
r6551cm = acia + 2		; command register
r6551ct = acia + 3		; control register

;;; memory locations
stemp	= $a7	; memory place that may hold the byte being received

start	= $ac	; start address of the transfer area
end	= $ae	; end address of the transfer
cinv	= $314	; interrupt vector

ackval	= 4
ack	= $dd00
data	= $dd01
ddr	= $dd03
strobe	= $dd0d

	;; program header
#define header
