#ifndef _HAD_METHODS_H
#define _HAD_METHODS_H

/*
  This file is automatically created from ``methods.mt''; don't make
  changes to this file, change ``methods.mt'' instead.

  Created from:
    $NiH: mkmethods-h.m4,v 1.3 2002/09/16 12:42:39 dillo Exp $
    $NiH: methods.mt,v 1.4 2002/09/16 12:42:37 dillo Exp $
*/

#include <stddef.h>

#include "config.h"
#include "directory.h"

int rftp_close(void);
int rftp_cwd(char *path);
int rftp_deidle(void);
int rftp_fclose(void *f);
directory * rftp_list(char *dir);
int rftp_open(char *host, char *port, char *user, char *pass);
int rftp_mkdir(char *dir);
int rftp_login(char *user, char *pass);
char * rftp_pwd(void);
void * rftp_retr(char *file, int mode, long *startp, long *sizep);
int rftp_rmdir(char *dir);
int rftp_site(char *cmd);
void * rftp_stor(char *file, int mode);
int rftp_xfer_eof(void *file);
int rftp_xfer_read(void *buf, size_t n, void *file);
int rftp_xfer_start(void *file);
int rftp_xfer_stop(void *file, int aborting);
int rftp_xfer_write(void *buf, size_t n, void *file);

#ifdef USE_SFTP

struct ftp_methods {
   int (*fn_close)(void);
   int (*fn_cwd)(char *path);
   int (*fn_deidle)(void);
   int (*fn_fclose)(void *f);
   directory * (*fn_list)(char *dir);
   int (*fn_open)(char *host, char *port, char *user, char *pass);
   int (*fn_mkdir)(char *dir);
   int (*fn_login)(char *user, char *pass);
   char * (*fn_pwd)(void);
   void * (*fn_retr)(char *file, int mode, long *startp, long *sizep);
   int (*fn_rmdir)(char *dir);
   int (*fn_site)(char *cmd);
   void * (*fn_stor)(char *file, int mode);
   int (*fn_xfer_eof)(void *file);
   int (*fn_xfer_read)(void *buf, size_t n, void *file);
   int (*fn_xfer_start)(void *file);
   int (*fn_xfer_stop)(void *file, int aborting);
   int (*fn_xfer_write)(void *buf, size_t n, void *file);
};

extern struct ftp_methods ftp_methods[];

int sftp_close(void);
int sftp_cwd(char *path);
int sftp_deidle(void);
int sftp_fclose(void *f);
directory * sftp_list(char *dir);
int sftp_open(char *host, char *port, char *user, char *pass);
int sftp_mkdir(char *dir);
int sftp_login(char *user, char *pass);
char * sftp_pwd(void);
void * sftp_retr(char *file, int mode, long *startp, long *sizep);
int sftp_rmdir(char *dir);
int sftp_site(char *cmd);
void * sftp_stor(char *file, int mode);
int sftp_xfer_eof(void *file);
int sftp_xfer_read(void *buf, size_t n, void *file);
int sftp_xfer_start(void *file);
int sftp_xfer_stop(void *file, int aborting);
int sftp_xfer_write(void *buf, size_t n, void *file);

#define ftp_close (ftp_methods[ftp_proto].fn_close)
#define ftp_cwd (ftp_methods[ftp_proto].fn_cwd)
#define ftp_deidle (ftp_methods[ftp_proto].fn_deidle)
#define ftp_fclose (ftp_methods[ftp_proto].fn_fclose)
#define ftp_list (ftp_methods[ftp_proto].fn_list)
#define ftp_open (ftp_methods[ftp_proto].fn_open)
#define ftp_mkdir (ftp_methods[ftp_proto].fn_mkdir)
#define ftp_login (ftp_methods[ftp_proto].fn_login)
#define ftp_pwd (ftp_methods[ftp_proto].fn_pwd)
#define ftp_retr (ftp_methods[ftp_proto].fn_retr)
#define ftp_rmdir (ftp_methods[ftp_proto].fn_rmdir)
#define ftp_site (ftp_methods[ftp_proto].fn_site)
#define ftp_stor (ftp_methods[ftp_proto].fn_stor)
#define ftp_xfer_eof (ftp_methods[ftp_proto].fn_xfer_eof)
#define ftp_xfer_read (ftp_methods[ftp_proto].fn_xfer_read)
#define ftp_xfer_start (ftp_methods[ftp_proto].fn_xfer_start)
#define ftp_xfer_stop (ftp_methods[ftp_proto].fn_xfer_stop)
#define ftp_xfer_write (ftp_methods[ftp_proto].fn_xfer_write)

#else /* !USE_SFTP */

#define ftp_close rftp_close
#define ftp_cwd rftp_cwd
#define ftp_deidle rftp_deidle
#define ftp_fclose rftp_fclose
#define ftp_list rftp_list
#define ftp_open rftp_open
#define ftp_mkdir rftp_mkdir
#define ftp_login rftp_login
#define ftp_pwd rftp_pwd
#define ftp_retr rftp_retr
#define ftp_rmdir rftp_rmdir
#define ftp_site rftp_site
#define ftp_stor rftp_stor
#define ftp_xfer_eof rftp_xfer_eof
#define ftp_xfer_read rftp_xfer_read
#define ftp_xfer_start rftp_xfer_start
#define ftp_xfer_stop rftp_xfer_stop
#define ftp_xfer_write rftp_xfer_write

#endif /* !USE_SFTP */

extern int ftp_proto;

#endif /* methods.h */
