/***************************************************************************/
/* 		This code is part of Desktop Background changer		   */
/*		called ChBg						   */
/*		Copyright (c) 1999 - 2001 Ondrejicka Stefan		   */
/*		(ondrej@idata.sk)					   */
/*		Distributed under GPL 2 or later			   */
/***************************************************************************/

#include "config.h"

#ifdef HAVE_XSS_SUPPORT
#include <X11/Xlib.h>
#include <X11/Xutil.h>
#include <X11/cursorfont.h>
#include <stdio.h>

#define BETWEEN(x,a,b) (((x) >= (a)) && ((x) <= (b)))

static Window find_win_at(dpy, w, x, y)
Display *dpy;
Window w;
int x;
int y;
{
	Window root, parent, rv;
	Window *chld;
	unsigned int num;
	int cx,cy;
	XWindowAttributes attrs;
	int i;

	rv = w;

	XQueryTree(dpy, w, &root, &parent, &chld, &num);
	XTranslateCoordinates(dpy, root, w, x, y, &cx, &cy, &parent);

	for(i = num - 1; i >= 0; i--)
	{
		XGetWindowAttributes(dpy, chld[i], &attrs);

		if ((attrs.map_state == IsViewable) &&
		    BETWEEN(cx, attrs.x, attrs.x+attrs.width) &&
		    BETWEEN(cy, attrs.y, attrs.y+attrs.height))
			rv = find_win_at(dpy, chld[i], x, y);
	}

	return rv;
}

static Window get_click_window(dpy)
Display *dpy;
{
	int status;
	XEvent evt;
	Window win = None, root;
	int bpress = 0;

	root = RootWindow(dpy, DefaultScreen(dpy));

	status = XGrabPointer(dpy, root, True,
		ButtonPressMask | ButtonReleaseMask,
		GrabModeSync, GrabModeAsync, None,
		XCreateFontCursor(dpy, XC_crosshair), CurrentTime);

	if (status != GrabSuccess)
	{
		XBell(dpy, 50);
		return None;
	}

	while ((win == None) || !bpress)
	{
		XAllowEvents(dpy, SyncPointer, CurrentTime);
		XWindowEvent(dpy, root, ButtonPressMask | ButtonReleaseMask,
			&evt);

		switch (evt.type)
		{
			case ButtonPress:
				if (win == None)
					win = evt.xbutton.subwindow;
				if (win == None)
					win = root;
				bpress++;
			break;
			/* to suppress button release events in target window */
			case ButtonRelease:
				if (bpress > 0)
					bpress--;
			break;
		}
	} 
	win = find_win_at(dpy, win, evt.xbutton.x, evt.xbutton.y);
	XUngrabPointer(dpy, CurrentTime);

	return(win);
}

Window chwin_get_window()
{
	Display *display;
	Window win;

	display = XOpenDisplay (gdk_display_name);
	win = get_click_window(display);
        XCloseDisplay (display);

	return win;
}

#if 0
int main (argc, argv)
{
	Display *display;
	Window win;
	display = XOpenDisplay (NULL);

	win = get_click_window(display);

	printf("0x%lx\n", win);

        XCloseDisplay (display);

	return 0;
}
#endif

#endif
