/* GTK - The GIMP Toolkit
 * Copyright (C) 1995-1997 Peter Mattis, Spencer Kimball and Josh MacDonald
 * GtkSelBox Copyright (C) 2000 Stefan Ondrejicka <ondrej@idata.sk>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#ifndef __GTK_SELBOX_H__
#define __GTK_SELBOX_H__

#include <gdk/gdk.h>
#include <gtk/gtkframe.h>


#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */


#define GTK_SELBOX(obj)		GTK_CHECK_CAST (obj, gtk_selbox_get_type (), GtkSelBox)
#define GTK_SELBOX_CLASS(klass)	GTK_CHECK_CLASS_CAST (klass, gtk_selbox_get_type (), GtkSelBoxClass)
#define GTK_IS_SELBOX(obj)	GTK_CHECK_TYPE (obj, gtk_selbox_get_type ())



typedef struct _GtkSelBox	GtkSelBox;
typedef struct _GtkSelBoxClass	GtkSelBoxClass;

struct _GtkSelBox
{
	GtkFrame	frame;

	gint		thickness;
	gboolean	selected;
	gboolean	with_frame;
	gboolean	with_window;

	gboolean	was_selected;
};

struct _GtkSelBoxClass
{
	GtkFrameClass parent_class;
};


guint		gtk_selbox_get_type		(void);
GtkWidget*	gtk_selbox_new			(gboolean	with_frame,
						 gboolean	with_window);
void		gtk_selbox_set_thickness	(GtkSelBox	*selbox,
						 gint		thickness);
void		gtk_selbox_set_selected		(GtkSelBox      *selbox,
						 gboolean	selected);


#ifdef __cplusplus
}
#endif /* __cplusplus */


#endif /* __GTK_SELBOX_H__ */

