/***************************************************************************/
/* 		This code is part of Desktop Background changer		   */
/*		called ChBg						   */
/*		Copyright (c) 1999,2000 Ondrejicka Stefan		   */
/*		(ondrej@idata.sk)					   */
/*		Distributed under GPL 2 or later			   */
/***************************************************************************/

#include "config.h"
#include <stdio.h>
#include <string.h>
#include <gtk/gtk.h>

#include "gtkbgpixmap.h"

#include "gui_tools.h"

#include "pixmaps/stock_browse.xpm"

struct path_entry_info {
	GtkWidget	*entry;
	GtkWidget	*fs;
	char		*label;
	int		isdir;
};

static void SetFileEntry(object, info)
GtkObject *object;
struct path_entry_info *info;
{
	gchar *p;

	p = gtk_file_selection_get_filename(GTK_FILE_SELECTION(info->fs));

	gtk_entry_set_text(GTK_ENTRY(info->entry) , p);

	gtk_widget_destroy(gtk_widget_get_toplevel(GTK_WIDGET(object)));
}

static void DestroyW(object , func_data)
GtkObject *object;
gpointer func_data;
{
	gtk_widget_destroy(GTK_WIDGET(func_data));
}

static void GetFile(object, info)
GtkObject *object;
struct path_entry_info *info;
{
	if (!info->fs)
	{
		gchar *p;
		char pom[2048];

		sprintf(pom, gettext("ChBg: select %s"), info->label);
		info->fs = gtk_file_selection_new(pom);

		if (info->isdir)
			gtk_widget_set_sensitive(GTK_FILE_SELECTION(info->fs)->file_list, FALSE);

		gtk_signal_connect(GTK_OBJECT(info->fs), "destroy",
			GTK_SIGNAL_FUNC(gtk_widget_destroyed), &(info->fs));

		p = gtk_entry_get_text(GTK_ENTRY(info->entry));
		
		if (p && p[0])
			gtk_file_selection_set_filename(GTK_FILE_SELECTION(info->fs), p);

		gtk_signal_connect(GTK_OBJECT(GTK_FILE_SELECTION(info->fs)->ok_button),
			"clicked", GTK_SIGNAL_FUNC(SetFileEntry), 
			(gpointer)info);

		gtk_signal_connect(GTK_OBJECT(GTK_FILE_SELECTION(info->fs)->cancel_button),
		"clicked", GTK_SIGNAL_FUNC(DestroyW), 
		(gpointer)info->fs);
	}
	gtk_widget_show(info->fs);
	if (GTK_WIDGET_REALIZED(info->fs))
		gdk_window_raise(info->fs->window);
}

static void path_entry_info_destroy(w, info)
GtkWidget *w;
struct path_entry_info *info;
{
	if (info->fs)
	{
		gtk_signal_disconnect_by_func(GTK_OBJECT(info->fs),
			GTK_SIGNAL_FUNC(gtk_widget_destroyed), &(info->fs));
		gtk_widget_destroy(info->fs);
	}
	g_free(info->label);
	g_free(info);
}

static void path_entry_info_hide(w, info)
GtkWidget *w;
struct path_entry_info *info;
{
	if (info->fs)
		gtk_widget_destroy(info->fs);
}

GtkWidget * guitl_tab_add_path_entry(table, label, col, row, dir)
GtkWidget *table;
char *label;
guint col;
guint row;
int dir;
{
	GtkWidget *entry , *labelw , *pom , *button , *box;
	struct path_entry_info *info;

	info = g_malloc(sizeof(struct path_entry_info));
	info->fs = NULL;
	info->label = g_strndup(label, strlen(label) - 2);
	info->isdir = dir;

	box = gtk_hbox_new(0 , 0);
	gtk_widget_show(box);
	gtk_table_attach(GTK_TABLE(table), box , col , col + 1 , row , row + 1 ,
			GTK_FILL | GTK_SHRINK, GTK_FILL, 2, 2);

	labelw = gtk_label_new(label);
	gtk_box_pack_start(GTK_BOX(box) , labelw , FALSE , TRUE , 0);
	gtk_misc_set_alignment(GTK_MISC(labelw) , 0.0 , 0.5);
	gtk_widget_show(labelw);

	pom = gtk_hbox_new(FALSE , 0);
	gtk_widget_show(pom);
	gtk_table_attach(GTK_TABLE(table), pom , col + 1, col + 2 , row , row + 1 ,
			GTK_FILL | GTK_EXPAND, GTK_FILL, 2, 2);

	info->entry = entry = gtk_entry_new();
	gtk_box_pack_start(GTK_BOX(pom) , entry , TRUE , TRUE , 0);
	gtk_widget_show(entry);

	gtk_signal_connect(GTK_OBJECT(entry), "destroy",
		GTK_SIGNAL_FUNC(path_entry_info_destroy), (gpointer)info);

	gtk_signal_connect(GTK_OBJECT(gtk_widget_get_toplevel(GTK_WIDGET(entry))),
		"hide", GTK_SIGNAL_FUNC(path_entry_info_hide), (gpointer)info);

	button = guitl_pixmap_button(stock_browse_xpm , gettext("Browse ..."));
	gtk_box_pack_end(GTK_BOX(pom) , button , FALSE , TRUE , 2);
	gtk_widget_show(button);

	gtk_signal_connect(GTK_OBJECT(button) , "clicked" , 
		GTK_SIGNAL_FUNC(GetFile) , 
		(gpointer)info);
	
	return entry;
}

GtkWidget *guitl_pixmap_button(pm, label)
char **pm;
char *label;
{
	GtkWidget *btn;

	if (pm)
	{
		GtkWidget *pixmap=NULL;
		GdkPixmap *pmp;
		GdkBitmap *mask;
		GtkWidget *box;
		GtkWidget *lbl;

		btn = gtk_button_new();

		pmp = gdk_pixmap_create_from_xpm_d(GDK_ROOT_PARENT(), &mask , NULL , pm);

		if (pmp)
			pixmap = gtk_pixmap_new(pmp , mask);

		box = gtk_hbox_new(FALSE , 1);
		gtk_container_add(GTK_CONTAINER(btn) , box);
		gtk_widget_show(box);

		gtk_box_pack_start(GTK_BOX(box) , pixmap , TRUE , TRUE , 0);
		gtk_misc_set_alignment(GTK_MISC(pixmap) , 1.0 , 0.5);
		gtk_widget_show(pixmap);

		lbl = gtk_label_new(label);
		gtk_misc_set_alignment(GTK_MISC(lbl) , 0.0 , 0.5);
		gtk_box_pack_start(GTK_BOX(box) , lbl , TRUE , TRUE , 0);
		gtk_widget_show(lbl);

	}
	else
	{
		btn = gtk_button_new_with_label(label);
	}

	return btn;
}

static void menu_kill(w, menu)
GtkWidget *w;
GtkWidget *menu;
{
	gtk_widget_destroy(menu);
}

void guitl_menu_attach(menu, parent)
GtkWidget *menu;
GtkWidget *parent;
{
	gtk_signal_connect(GTK_OBJECT(parent), "destroy",
		GTK_SIGNAL_FUNC(menu_kill), menu);
	gtk_object_set_data(GTK_OBJECT(menu), "guitl_menu_parent", parent);
}

GtkWidget *guitl_menu_parent(menu)
GtkWidget *menu;
{
	return gtk_object_get_data(GTK_OBJECT(menu), "guitl_menu_parent");
}

GtkWidget * guitl_tab_add_numentry(table, flabel, blabel, col, row, nten,
				   sstep, bstep, min_val, max_val, val)
GtkWidget *table;
char *flabel;
char *blabel;
guint col;
guint row;
int nten;
gfloat sstep;
gfloat bstep;
gfloat min_val;
gfloat max_val;
gfloat val;
{
	GtkWidget *entry, *labelw;
	GtkAdjustment *adj;

	if (flabel)
	{
		labelw = gtk_label_new(flabel);
		gtk_misc_set_alignment(GTK_MISC(labelw), 0, 0.5);
		gtk_table_attach(GTK_TABLE(table), labelw,
				col, col+1, row, row+1,
				GTK_FILL | GTK_SHRINK, GTK_FILL, 2, 2);
		gtk_widget_show(labelw);
	}

	if (blabel)
	{
		labelw = gtk_label_new(blabel);
		gtk_misc_set_alignment(GTK_MISC(labelw), 0, 0.5);
		gtk_table_attach(GTK_TABLE(table), labelw,
				col+2, col+3, row, row+1,
				GTK_FILL | GTK_SHRINK, GTK_FILL, 2, 2);
		gtk_widget_show(labelw);
	}

	adj = (GtkAdjustment *)gtk_adjustment_new(val, min_val, max_val,
			sstep, bstep, 0.0);

	entry = gtk_spin_button_new(adj, 0, nten);
	gtk_table_attach(GTK_TABLE(table), entry, col+1, col+2, row, row+1 ,
			0, GTK_FILL, 2, 2);
	gtk_widget_set_usize(entry,
		gdk_string_width(entry->style->font, "00000000000"), -1);
	gtk_widget_show(entry);

	return entry;
}

GtkWidget * guitl_tab_add_entry(table, label, col, row, passw)
GtkWidget *table;
char *label;
guint col;
guint row;
guint passw;
{
	GtkWidget *entry, *labelw;

	labelw = gtk_label_new(label);
	gtk_misc_set_alignment(GTK_MISC(labelw), 0, 0.5);
	gtk_table_attach(GTK_TABLE(table), labelw, col, col + 1, row, row + 1,
			GTK_FILL | GTK_SHRINK, GTK_FILL, 2, 2);
	gtk_widget_show(labelw);

	entry = gtk_entry_new();
	gtk_table_attach(GTK_TABLE(table), entry, col + 1, col + 2, row, row + 1,
			GTK_FILL | GTK_EXPAND, GTK_FILL, 2, 2);
	if (passw)
		gtk_entry_set_visibility(GTK_ENTRY(entry), FALSE);
	gtk_widget_show(entry);

	return entry;
}

static void guitl_picsel_SelectAll(object, func_data)
GtkObject *object;
gpointer func_data;
{
	if (GTK_CLIST(func_data)->rows > 0)
		gtk_clist_select_all(GTK_CLIST(func_data));
}

static void guitl_picsel_Preview(object, picsel)
GtkObject *object;
guitl_picsel_t *picsel;
{
	GtkWidget *pmap;
	absimg_image_t *img;
	GdkPixmap *pixmap;
	char *p;
	guint w,h;
	gfloat scale;
	gchar pom[50];

	if (GTK_BIN(picsel->preview)->child)
		gtk_widget_destroy(GTK_BIN(picsel->preview)->child);
	gtk_label_set(GTK_LABEL(picsel->preview_info), "");

	p = gtk_file_selection_get_filename(GTK_FILE_SELECTION(picsel->filesel));
	
	if (!p)
	{
		gdk_beep();
		return;
	}

	img = absimg_load(p);

	if (!img)
	{
		gdk_beep();
		return;
	}

	w = MIN(picsel->preview->allocation.width -
			2 * (GTK_CONTAINER(picsel->preview)->border_width + 6),
		img->rgb_width);
	h = MIN(picsel->preview->allocation.height -
			2 * (GTK_CONTAINER(picsel->preview)->border_width + 6),
		img->rgb_height);

	scale = 1.0;
	
	if (img->rgb_width > w)
		scale = (gfloat)w / (gfloat)img->rgb_width;
	if (img->rgb_height > h)
		scale = MIN((gfloat)h / (gfloat)img->rgb_height, scale);

	w = (guint)(scale * img->rgb_width);
	h = (guint)(scale * img->rgb_height);
	
	pmap = gtk_bg_pixmap_new(NULL);

	if (absimg_have_alpha(img))
	{
		GdkGC *gc;
		gc = gdk_gc_new(GDK_ROOT_PARENT());
		gtk_widget_ensure_style(pmap);
		gdk_gc_set_foreground(gc, &(pmap->style->bg[GTK_STATE_NORMAL]));
		pixmap = gdk_pixmap_new(GDK_ROOT_PARENT(), w, h,
                        gdk_visual_get_best_depth());
		gdk_draw_rectangle(pixmap, gc, TRUE, 0, 0, w, h);
		absimg_render_alpha_to_pixmap(pixmap, img, w, h);
		gdk_gc_unref(gc);
	}
	else
		pixmap = absimg_render(img, w, h);

	gtk_bg_pixmap_set(GTK_BG_PIXMAP(pmap), pixmap);
	gtk_container_add(GTK_CONTAINER(picsel->preview), pmap);
	gtk_widget_show(pmap);

	sprintf(pom, gettext("Size:  %d x %d  "),
		img->rgb_width, img->rgb_height);
	gtk_label_set(GTK_LABEL(picsel->preview_info), pom);

	absimg_destroy_pixmap(pixmap);
	absimg_destroy(img);
}

static void guitl_picsel_SwitchPic(object, row, col, event, picsel)
GtkObject *object;
int row;
int col;
GdkEvent *event;
guitl_picsel_t *picsel;
{
	if (GTK_TOGGLE_BUTTON(picsel->preview_auto)->active)
		guitl_picsel_Preview(NULL, picsel);
}

static void guitl_picsel_Destroy(w, picsel)
GtkWidget *w;
guitl_picsel_t *picsel;
{
	memset(picsel, '\0', sizeof(guitl_picsel_t));
}

void guitl_picsel_new(picsel, title)
char *title;
guitl_picsel_t *picsel;
{
	GtkWidget *pbox;

	if (picsel->filesel)
	{
		gdk_window_raise(picsel->filesel->window);
		return;
	}

	picsel->filesel = gtk_file_selection_new(title);
	gtk_signal_connect(GTK_OBJECT(picsel->filesel), "destroy",
		GTK_SIGNAL_FUNC(guitl_picsel_Destroy), picsel);

	gtk_file_selection_hide_fileop_buttons(
		GTK_FILE_SELECTION(picsel->filesel));

	gtk_signal_connect(
		GTK_OBJECT(GTK_FILE_SELECTION(picsel->filesel)->file_list),
		"select_row", GTK_SIGNAL_FUNC(guitl_picsel_SwitchPic), picsel);

	gtk_clist_set_selection_mode(
		GTK_CLIST(GTK_FILE_SELECTION(picsel->filesel)->file_list),
		GTK_SELECTION_MULTIPLE);

	picsel->preview = gtk_frame_new(gettext("preview"));
	gtk_widget_set_usize(picsel->preview, 180, 180);
	gtk_container_set_border_width(GTK_CONTAINER(picsel->preview), 5);
	gtk_box_pack_end(GTK_BOX(GTK_FILE_SELECTION(picsel->filesel)->file_list->parent->parent),
		picsel->preview , TRUE, TRUE, 0);
	gtk_widget_show(picsel->preview);

	pbox = gtk_hbox_new(FALSE, 2);
	gtk_box_pack_start(GTK_BOX(GTK_FILE_SELECTION(picsel->filesel)->selection_text->parent),
			pbox, FALSE, FALSE, 0);
	gtk_box_reorder_child(GTK_BOX(GTK_FILE_SELECTION(picsel->filesel)->selection_text->parent) ,
			pbox, 0);
	gtk_widget_show(pbox);

	picsel->preview_auto = gtk_check_button_new_with_label(gettext("Auto preview"));
	SET_TOOLTIP(picsel->preview_auto, gettext(
		"Click on image to show a small preview."));
	gtk_box_pack_end(GTK_BOX(pbox), picsel->preview_auto, FALSE, FALSE, 0);
	gtk_widget_show(picsel->preview_auto);

	picsel->preview_info = gtk_label_new ("");
	gtk_misc_set_alignment (GTK_MISC(picsel->preview_info), 1.0, 0.5);
	gtk_box_pack_start(GTK_BOX(GTK_FILE_SELECTION(picsel->filesel)->selection_text->parent),
			picsel->preview_info, FALSE, FALSE, 0);
	gtk_box_reorder_child(GTK_BOX(GTK_FILE_SELECTION(picsel->filesel)->selection_text->parent) ,
			picsel->preview_info, 1);
	gtk_widget_show (picsel->preview_info);

	picsel->button_selall = gtk_button_new_with_label(gettext("Select All"));
	gtk_container_add(GTK_CONTAINER(GTK_FILE_SELECTION(picsel->filesel)->ok_button->parent), picsel->button_selall);
	GTK_WIDGET_SET_FLAGS (picsel->button_selall, GTK_CAN_DEFAULT);
	gtk_widget_show(picsel->button_selall);

	gtk_signal_connect(GTK_OBJECT(picsel->button_selall), "clicked",
		GTK_SIGNAL_FUNC(guitl_picsel_SelectAll),
		(gpointer)(GTK_FILE_SELECTION(picsel->filesel)->file_list));

	picsel->button_append = gtk_button_new_with_label(gettext("Append"));
	SET_TOOLTIP(picsel->button_append, gettext(
		"to choose multiple directories...hit OK button when done."));
	gtk_container_add(GTK_CONTAINER(GTK_FILE_SELECTION(picsel->filesel)->ok_button->parent), picsel->button_append);
	GTK_WIDGET_SET_FLAGS (picsel->button_append, GTK_CAN_DEFAULT);
	gtk_widget_grab_default (picsel->button_append);
	gtk_widget_show(picsel->button_append);

	picsel->button_preview = gtk_button_new_with_label(gettext("Preview"));
	SET_TOOLTIP(picsel->button_preview, gettext("Preview last selected picture"));
	gtk_container_add(GTK_CONTAINER(GTK_FILE_SELECTION(picsel->filesel)->ok_button->parent), picsel->button_preview);
	GTK_WIDGET_SET_FLAGS (picsel->button_preview, GTK_CAN_DEFAULT);
	gtk_widget_show(picsel->button_preview);

	gtk_signal_connect(GTK_OBJECT(picsel->button_preview), "clicked",
		GTK_SIGNAL_FUNC(guitl_picsel_Preview), picsel);

	gtk_widget_show(picsel->filesel);
}

