/***************************************************************************/
/* 		This code is part of Desktop Background changer		   */
/*		called ChBg						   */
/*		Copyright (c) 1999 - 2001 Ondrejicka Stefan		   */
/*		(ondrej@idata.sk)					   */
/*		Distributed under GPL 2 or later			   */
/***************************************************************************/

#ifndef _options_h_
#define _options_h_

typedef enum {
	CHBG_OPT_V,
	CHBG_OPT_LONG_VERSION,
	CHBG_OPT_H,
	CHBG_OPT_LONG_HELP,
	CHBG_OPT_SETUP,
	CHBG_OPT_SCENARIO,
	CHBG_OPT_MODE,
	CHBG_OPT_EFFECT,
	CHBG_OPT_BG,
	CHBG_OPT_BG2,
	CHBG_OPT_RAND_COLORS,
	CHBG_OPT_SHADER,
	CHBG_OPT_INTERVAL,
	CHBG_OPT_MAX_GROW,
	CHBG_OPT_MAX_SIZE,
	CHBG_OPT_RANDOMIZE,
	CHBG_OPT_SCREENSAVER,
#ifdef HAVE_XSS_SUPPORT
	CHBG_OPT_XSCREENSAVER,
#endif
	CHBG_OPT_SPEED,
	CHBG_OPT_BLANK,
	CHBG_OPT_CYCLE_BLANK,
	CHBG_OPT_R,
	CHBG_OPT_PATTERN,
	CHBG_OPT_INWINDOW,
	CHBG_OPT_WINDOWID,
	CHBG_OPT_RUN,
	CHBG_OPT_MIN_PSIZE,
	CHBG_OPT_DEFFECTS,
	CHBG_OPT_DSHADERS,
	CHBG_OPT_NOTOOLTIPS,
	CHBG_OPT_FRITER,
	CHBG_OPT_RECT_SIZE,
	CHBG_OPT_GRAD_DIR,
	CHBG_OPT_USE_GRAD,
	CHBG_OPT_GRAD,
	CHBG_OPT_REMEMBER,
	CHBG_OPT_SORT,
#ifdef HAVE_ENLIGHTENMENT_SUPPORT
	CHBG_OPT_ENLIGHTENMENT,
#endif
	CHBG_OPT_ONCE,
	CHBG_OPT_THUMB,
	CHBG_OPT_XPOS,
	CHBG_OPT_YPOS,
	CHBG_OPT_USE_TILES,
	CHBG_OPT_ADD_TILE,
	CHBG_OPT_TILE,
	CHBG_OPT_USE_BANNERS,
	CHBG_OPT_ADD_BANNER,
	CHBG_OPT_BANNER,
	CHBG_OPT_BANNER_XPOS,
	CHBG_OPT_BANNER_YPOS,
	CHBG_OPT_BANNER_MAX_GROW,
	CHBG_OPT_BANNER_MAX_SIZE,
	CHBG_OPT_BANNER_MODE,
	CHBG_OPT_PICTURE,
	CHBG_OPT_CURRENT_PICTURE,
	CHBG_OPT_OUT_FILE,
	CHBG_OPT_OUT_FILE_WIDTH,
	CHBG_OPT_OUT_FILE_HEIGHT,
	CHBG_OPT_TO_FILE,
#ifdef HAVE_XSS_SUPPORT
	CHBG_OPT_SEND_EXPOSE,
#endif
	CHBG_OPT_FAKE_NAUTILUS,
	CHBG_OPT_FORCE_XSCREENSAVER,


	CHBG_OPT_FOREIGN
} option_type_t;

typedef struct {
	option_type_t	type;
	char		*cmd;
	char		*scn;
	int		nparams;
} option_t;

option_t chbg_opts[] = {
	{CHBG_OPT_V, "-v", NULL, 0},
	{CHBG_OPT_LONG_VERSION, "--version", NULL, 0},
	{CHBG_OPT_H, "-h", NULL, 0},
	{CHBG_OPT_LONG_HELP, "--help", NULL, 0},
	{CHBG_OPT_SETUP, "-setup", NULL, 0},
	{CHBG_OPT_SCENARIO, "-scenario", NULL, 1},
	{CHBG_OPT_MODE, "-mode", "RenderingMode:", 1},
	{CHBG_OPT_EFFECT, "-effect", "Efect:", 1},
	{CHBG_OPT_BG, "-bg", "BackgroundColor:", 1},
	{CHBG_OPT_BG2, "-bg2", "BackgroundColor2:", 1},
	{CHBG_OPT_RAND_COLORS, "-rand_colors", "RandomizeColors:", 0},
	{CHBG_OPT_SHADER, "-shader", "Shader:", 1},
	{CHBG_OPT_INTERVAL, "-interval", "Interval:", 1},
	{CHBG_OPT_MAX_GROW, "-max_grow", "MaxGrow:", 1},
	{CHBG_OPT_MAX_SIZE, "-max_size", "MaxSize:", 1},
	{CHBG_OPT_RANDOMIZE, "-randomize", "Randomize:", 0},
	{CHBG_OPT_SCREENSAVER, "-screensaver", "Screensaver:", 0},
#ifdef HAVE_XSS_SUPPORT
	{CHBG_OPT_XSCREENSAVER, "-xscreensaver", "XScreensaver:", 0},
#endif
	{CHBG_OPT_SPEED, "-speed", "Speed:", 1},
	{CHBG_OPT_BLANK, "-blank", "Blank:", 0},
	{CHBG_OPT_CYCLE_BLANK, "-cycle_blank", "CycleBlank:", 0},
	{CHBG_OPT_R, "-R", "Recurse:", 0},
	{CHBG_OPT_PATTERN, "-pattern", "Pattern:", 1},
	{CHBG_OPT_INWINDOW, "-inwindow", "InWindow:", 0},
	{CHBG_OPT_WINDOWID, "-windowid", NULL, 1},
	{CHBG_OPT_RUN, "-run", NULL, 0},
	{CHBG_OPT_MIN_PSIZE, "-min_psize", "MinPictureSize:", 1},
	{CHBG_OPT_DEFFECTS, "-deffects", "DisabledEffects:", 1},
	{CHBG_OPT_DSHADERS, "-dshaders", "DisabledShaders:", 1},
	{CHBG_OPT_NOTOOLTIPS, "-notooltips", "Tooltips:", 0},
	{CHBG_OPT_FRITER, "-friter", "FractalIterations:", 1},
	{CHBG_OPT_RECT_SIZE, "-rect_size", "RectSize:", 1},
	{CHBG_OPT_GRAD_DIR, "-grad_dir", "GradientsDir:", 1},
	{CHBG_OPT_USE_GRAD, "-use_grad", "UseGradients:", 0},
	{CHBG_OPT_GRAD, "-grad", "Gradient:", 1},
	{CHBG_OPT_REMEMBER, "-remember", "RememberLast:", 0},
	{CHBG_OPT_SORT, "-sort", "Sort:", 0},
#ifdef HAVE_ENLIGHTENMENT_SUPPORT
	{CHBG_OPT_ENLIGHTENMENT, "-enlightenment", "Enlightenment:", 0},
#endif
	{CHBG_OPT_ONCE, "-once", NULL, 0},
	{CHBG_OPT_THUMB, "-thumb", NULL, 1},
	{CHBG_OPT_XPOS, "-xpos", "XPosition:", 1},
	{CHBG_OPT_YPOS, "-ypos", "YPosition:", 1},
	{CHBG_OPT_USE_TILES, "-use_tiles", "UseTiles:", 0},
	{CHBG_OPT_ADD_TILE, "-add_tile", "AddTile:", 1},
	{CHBG_OPT_TILE, "-tile", "Tile:", 1},
	{CHBG_OPT_ADD_BANNER, "-add_banner", "AddBanner:", 1},
	{CHBG_OPT_USE_BANNERS, "-use_banners", "UseBanners:", 0},
	{CHBG_OPT_BANNER, "-banner", "Banner:", 1},
	{CHBG_OPT_BANNER_XPOS, "-banner_xpos", "BannerXPosition:", 1},
	{CHBG_OPT_BANNER_YPOS, "-banner_ypos", "BannerYPosition:", 1},
	{CHBG_OPT_BANNER_MAX_GROW, "-banner_max_grow", "BannerMaxGrow:", 1},
	{CHBG_OPT_BANNER_MAX_SIZE, "-banner_max_size", "BannerMaxSize:", 1},
	{CHBG_OPT_BANNER_MODE, "-banner_mode", "BannerMode:", 1},
	{CHBG_OPT_PICTURE, NULL, "Picture:", 1},
	{CHBG_OPT_CURRENT_PICTURE, NULL, "CurrentPicture:", 1},
	{CHBG_OPT_OUT_FILE, "-out_file", "OutputFile:", 1},
	{CHBG_OPT_OUT_FILE_WIDTH, "-out_file_width", "OutputFileWidth:", 1},
	{CHBG_OPT_OUT_FILE_HEIGHT, "-out_file_height", "OutputFileHeight:", 1},
	{CHBG_OPT_TO_FILE, "-to_file", "OutputToFile:", 0},
#ifdef HAVE_XSS_SUPPORT
	{CHBG_OPT_SEND_EXPOSE, "-send_expose", "SendExpose:", 0},
#endif
	{CHBG_OPT_FAKE_NAUTILUS, "-force_nautilus", "ForceNautilus:", 0},
	{CHBG_OPT_FORCE_XSCREENSAVER, "-force_xscreensaver", NULL, 0},
};

option_t foreign_opts[] = {
	{CHBG_OPT_FOREIGN, "--gtk-module", NULL, 1},
	{CHBG_OPT_FOREIGN, "--g-fatal-warnings", NULL, 0},
	{CHBG_OPT_FOREIGN, "--gtk-debug", NULL, 0},
	{CHBG_OPT_FOREIGN, "--gtk-no-debug", NULL, 0},
	{CHBG_OPT_FOREIGN, "--gdk-debug", NULL, 0},
	{CHBG_OPT_FOREIGN, "--gdk-no-debug", NULL, 0},
	{CHBG_OPT_FOREIGN, "--display", NULL, 1},
	{CHBG_OPT_FOREIGN, "--sync", NULL, 0},
	{CHBG_OPT_FOREIGN, "--no-xshm", NULL, 0},
	{CHBG_OPT_FOREIGN, "--name", NULL, 1},
	{CHBG_OPT_FOREIGN, "--class", NULL, 1},
	{CHBG_OPT_FOREIGN, "--gxid_host", NULL, 1},
	{CHBG_OPT_FOREIGN, "--gxid_port", NULL, 1},
	{CHBG_OPT_FOREIGN, "--xim-preedit", NULL, 1},
	{CHBG_OPT_FOREIGN, "--xim-status", NULL, 1},
};

#endif

