/* VGAlib version 1.0 - (c) 1992 Tommy Frandsen 		   */
/*								   */
/* This library is free software; you can redistribute it and/or   */
/* modify it without any restrictions. This library is distributed */
/* in the hope that it will be useful, but without any warranty;   */
/* without even the implied warranty of merchantability or fitness */
/* for a particular purpose.					   */

#ifndef VGA1_H
#define VGA1_H

#define TEXT 	     0
#define G320x200x16  1
#define G640x200x16  2
#define G640x350x16  3
#define G640x480x16  4
#define G320x200x256 5
#define G320x240x256 6
#define G320x400x256 7
#define G360x480x256 8

extern int vga1_setmode(int mode);
extern int vga1_setflipchar(int c);

extern int vga1_clear();
extern int vga1_flip();

extern int vga1_getxdim();
extern int vga1_getydim();
extern int vga1_getcolors();

extern int vga1_setpalette(int index, int red, int green, int blue);
extern int vga1_getpalette(int index, int *red, int *green, int *blue);
extern int vga1_setpalvec(int start, int num, int *pal);
extern int vga1_getpalvec(int start, int num, int *pal);

extern int vga1_screenoff();
extern int vga1_screenon();

extern int inline vga1_setcolor(int color);
extern int inline vga1_drawpixel(int x, int y);
extern int vga1_drawline(int x1, int y1, int x2, int y2);
extern int vga1_drawscanline(int line, char* colors);

extern int vga1_getch();
extern void vga1_drawtext(int,int,char *);
extern void vga1_drawctext(int,int,char *);

#define SIGREL SIGUSR1
#define SIGACQ SIGUSR2
void vga1_drawtext(int,int,char *);
void vga1_drawctext(int,int,char *);
void vga1_clreol(int,int);
void vga1_scroll(int,int,int );
void vga1_rscroll(int,int,int);
void vga1_invert(int);
void vga1_clearblock(int,int,int,int);
void vga1_moveleft(int,int,int,int);
void vga1_moveright(int,int,int,int);
void vga1_cursor(int,int);
int vga1_curcolor();
void vga1_underline(int);

#endif /* VGA1_H */

