/***************************************************************************
    This file is part of the CheeseTronic Music Tools
    url                  : http://reduz.com.ar/cheesetronic
    copyright            : (C) 2003 by Juan Linietsky
    email                : coding@reduz.com.ar
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "columned_list.h"
#include <stdio.h>

void Columned_List::tree_selection_changed_callback() {

	Gtk::TreeModel::iterator treeI=tree_selection->get_selected();
	if (treeI==0) { //why 0?! NULL gives me a warning

		//printf("nothing selected\n");
	} else {
		Gtk::TreeModel::Row row = *treeI;

		int which=row[base_tree_model->column_internal_index];
		//printf("SOMETHING SELECTED!! %i - %i\n",which,treeI);
	}
}
                              
Columned_List::Columned_List(Base_Model_Column *p_columnrecord) : label("Name:") {
	
	add(vbox);
	vbox.pack_start(tree_scroll);
	vbox.pack_start(hbox,0,0);
	hbox.pack_start(label,0,0);
	hbox.pack_start(entry);
	

	base_tree_model=p_columnrecord;	
	tree_scroll.add(tree_view);
	
	tree_scroll.set_policy(Gtk::POLICY_NEVER, Gtk::POLICY_AUTOMATIC);
	 
	tree_model_ref = Gtk::ListStore::create(*p_columnrecord);
	tree_view.set_model(tree_model_ref);
	tree_selection=tree_view.get_selection();
	tree_selection->signal_changed().connect(SigC::slot(*this,&Columned_List::tree_selection_changed_callback));
	
/*	
	Gtk::TreeModel::Row auxrow = *(tree_model_ref->append());
	auxrow[tree_model.column_index] = 1;
	auxrow[tree_model.column_name] = "hooraye";

	auxrow = *(tree_model_ref->append());
	auxrow[tree_model.column_index] = 2;
	auxrow[tree_model.column_name] = "mamma mia";
		
  //Add the TreeView's view columns:
	tree_view.append_column("#", tree_model.column_index);
	tree_view.append_column("Active", tree_model.column_active);
	tree_view.append_column("L", tree_model.column_volume);	
	tree_view.append_column("Name                   ", tree_model.column_name);*/
	
	
	show_all();
}


Columned_List::~Columned_List() {


}
