/*
 * AUTHOR: Pedro Lineu Orso                          pedro.orso@gmail.com
 *                                                             1998, 2006
 * CHETCPASSWD System Password Change Utility http://sarg.sourceforge.net
 * ----------------------------------------------------------------------
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111, USA.
 *
 */

#include "include/conf.h"
#include "include/defs.h"

char IP[255];

int main(int argc, char *argv[])
{

#if defined(CONF_SITE) 
   char IP2[255];
   char SITE[255];
   struct hostent *websinfo;
   char *prefix;
   char NotFound;
#endif
   FILE *auth, *fpw, *tmp;
   char buf[MAXLEN];
   char User[MAXLEN];
   char PUser[MAXLEN];
   char WUser[MAXLEN];
   char Old_pw[MAXLEN];
   char WOld_pw[MAXLEN];
   char Wrest[MAXLEN];
   char New_pw1[MAXLEN];
   char New_pw2[MAXLEN];
   char Action[50];
   char Msg[MAXLEN];
   char command[255];
   char InputBuffer[MAXLEN];
   char *pContentLength;
   char *cpw, salt[3];
   char pwdfile[255]="/etc/passwd";
   char template[255]="/var/tmp/chetcpwd.XXXXXX";
   int  Uid, Gid;
   int  ContentLength;
   int  i, authbit=0;
   int  x, z, ok=0;
   int  fd;
   struct stat statb;
   static char IP_TEST[12]=".0123456789";

   Uid=getuid();
   Gid=getgid();

   if((setuid(0)) < 0) eperror("setuid");
   if((setgid(3)) < 0) eperror("setgid");

   strcpy(Language,"English");
   sprintf(ConfigFile,"%s/chetcpasswd.conf",SYSCONFDIR);

   getconf();

   strcpy(Title,text[22]);
   strcpy(SubTitle,text[23]);

#if defined(CONF_SITE) 
   if(access(CONF_SITE,R_OK) != 0)
      Hmsg(text[1], Uid, Gid);

   if((tmp=fopen(CONF_SITE,"r"))==NULL)
      Hmsg(text[2], Uid, Gid);

   sprintf(SITE,"%s",getenv("SERVER_NAME"));
   websinfo = gethostbyname(SITE);
   if (!(websinfo->h_length)) {
      sprintf(Msg,"% %s %s", text[3], SITEm text[4]);
      Hmsg(Msg, Uid, Gid);
   } else {
      sprintf(IP2,"%d.%d.%d.%d", NORM(websinfo->h_addr_list[0][0]), NORM(websinfo->h_addr_list[0][1]), NORM(websinfo->h_addr_list[0][2]), NORM(websinfo->h_addr_list[0][3]));
   }

   NotFound = 1;
   while(NotFound && fgets(buf,MAXLEN,tmp)!=NULL){
      getword(IP,buf,' ');
      if(!(strcmp(IP,IP2))) NotFound = 0;
   }
   fclose(tmp);
   if (NotFound){
      sprintf(Msg,"%s %s %s", text[5], IP2, text[4]);
      Hmsg(Msg, Uid, Gid);
   } else {
      prefix = (char *) malloc(strlen(buf)+1);
      getword(prefix,buf,'\n');
   }

#endif /* CONF_SITE */

   if(access("/etc/chetcpasswd.allow",R_OK) != 0)
      Hmsg(text[6], Uid, Gid);

   if(stat("/etc/chetcpasswd.allow",&statb))
      eperror("/etc/chetcpasswd.allow");
   if(statb.st_uid != 0)
      Hmsg(text[7], Uid, Gid);

   if(statb.st_mode & 022)
      Hmsg(text[8], Uid, Gid);

   if((auth=fopen("/etc/chetcpasswd.allow","r"))==NULL)
      Hmsg(text[9], Uid, Gid);

   if(getenv("HTTP_X_FORWARDED_FOR"))
      sprintf(IP,"%s",getenv("HTTP_X_FORWARDED_FOR"));
    else sprintf(IP,"%s",getenv("REMOTE_ADDR"));
   
   test_ip_address(IP);
      
   while(fgets(buf,MAXLEN,auth)!=NULL) {
      authbit=vauth(buf,IP);
      if(authbit) break;
   }

   if(!authbit)
      Hmsg(text[10], Uid, Gid);

#ifdef CONF_SITE
   sprintf(pwdfile, "%s/etc/shadow", prefix);
#else
   if(access("/etc/shadow",R_OK) == 0)
      sprintf(pwdfile, "/etc/shadow");
#endif

   if(strcmp((char *)getenv("REQUEST_METHOD"),"GET") == 0) {
      UserForm();
      return 0;
   }

   pContentLength = (char *)getenv("CONTENT_LENGTH");

   if (pContentLength != NULL)
      ContentLength = atoi(pContentLength);
   else ContentLength = 0;
	
   if (ContentLength > sizeof(InputBuffer)-1)
      ContentLength = sizeof(InputBuffer)-1;

   i = 0;

   while (i < ContentLength) {
      x = fgetc(stdin);
      if (x==EOF) break;
      InputBuffer[i++] = x;
   }

   InputBuffer[i] = '\0';
   ContentLength = i;

   getword(User,InputBuffer,'=');
   getword(User,InputBuffer,'&');
   getword(Old_pw,InputBuffer,'=');
   getword(Old_pw,InputBuffer,'&');
   getword(New_pw1,InputBuffer,'=');
   getword(New_pw1,InputBuffer,'&');
   getword(New_pw2,InputBuffer,'=');
   getword(New_pw2,InputBuffer,'&');
   getword(Action, InputBuffer, '=');

   if(strcmp(Action,"cancel") == 0 ) {
      printf("Content-type: text/html\n");
      puts("\n");
      printf("<meta http-equiv=\"Refresh\" content=\"0;URL=%s\">\n",CancelUrl);
      printf("<html>");
      printf("</html>");
      exit(0);
   }

   fixpwd(User);
   fixpwd(Old_pw);
   fixpwd(New_pw1);
   fixpwd(New_pw2);

   if(strcmp(User,"root") == 0) {
      sprintf(Msg,"%s: %s %s",text[20],User,text[21]);
      Hmsg(Msg, Uid, Gid);
   }
   
   strcpy(PUser,User);
   strcat(PUser,":");

   if (strcmp(Action, "change") == 0) {
      if(strlen(User) > atoi(MaxUserLen))
         Hmsg(text[36], Uid, Gid);

      if(strlen(New_pw1) < atoi(PasswordMinimumLenght))
         Hmsg(text[11], Uid, Gid)
;
      if(strcmp(User,New_pw1) == 0)
         Hmsg(text[12], Uid, Gid);

      if(strcmp(Old_pw,New_pw1) == 0)
         Hmsg(text[13], Uid, Gid);

      if(strcmp(New_pw1,New_pw2) != 0)
         Hmsg(text[14], Uid, Gid);

      if((fpw=fopen(pwdfile,"r"))==NULL) {
         sprintf(Msg,"%s: %s",text[15],pwdfile);
         Hmsg(Msg, Uid, Gid);
      }
      
      fd = mkstemp(template);
      if((fd == -1 ) ||
         ((tmp = fdopen (fd, "w+" )) == NULL)  ) {    /* failure, bail out */
         Hmsg(text[16], Uid, Gid);
      }

      while(fgets(buf,MAXLEN,fpw)!=NULL){
         if(!ok) {
            if(strncmp(buf,PUser,strlen(PUser)) == 0) {
               getword(WUser,buf,':');
               getword(WOld_pw,buf,':');
               strcpy(Wrest,buf);

               if(strcmp(WOld_pw, (char *)crypt(Old_pw, WOld_pw)) != 0) {
                  sprintf(Msg,"%s: %s",text[17],WUser);
                  if(fpw)
                     fclose(fpw);
                  if(tmp) {
                     fclose(tmp);
                     unlink(template);
                  }
                  Hmsg(Msg, Uid, Gid);
               }
	
               (void)srand((int)time((time_t *)NULL));
               to64(&salt[0],rand(),2);

               if (strncmp(UseMD5,"yes",3) == 0) 
                  cpw = (char *)md5_crypt(New_pw1,salt);
               else
                  cpw = (char *)crypt(New_pw1,salt);

               sprintf(buf,"%s:%s:%s\n",User,cpw,Wrest);
               buf[strlen(buf)-1]='\0';
               ok++;
            }
         } 

         putline(tmp,buf);
      }

      fclose(fpw);
      fclose(tmp);

      if(ok) {
         sprintf(command,"cp %s %s",template,pwdfile);
         system(command);
         unlink(template);
 
         if(strlen(PostChange) > 0) {
            getword(command,PostChange,'"');      
            getword(command,PostChange,'"');      
            system(command);
         }

         sprintf(Msg,"%s %s.",text[18],User);
         success(Msg, Uid, Gid);
      } else {
         unlink(template);
         if(strlen(User)>100) {
            sprintf(Msg,"%s: %s %s",text[19],User,text[20]);
            alert("No way. Yoy are trying to break the code. This incident was reported. Bye, bye" , Uid, Gid);
         }
         sprintf(Msg,"%s: %s %s",text[19],User,text[20]);
         Hmsg(Msg, Uid, Gid);
      }

      if((setuid(Uid)) < 0) eperror("setuid");
      if((setgid(Gid)) < 0) eperror("setgid");

      return 0;
   } else {
      if (strcmp(Action, "cancel") == 0)
         Hmsg(text[22], Uid, Gid);
   }
   return 0;
}


void getword(char *word, char *line, char stop) 
{
   int x = 0,y;

   for(x=0;((line[x]) && (line[x] != stop));x++)
      word[x] = line[x];

   word[x] = '\0';
   if(line[x]) ++x;
   y=0;

   while((line[y++] = line[x++]));
}


void Hmsg(char *msg, int Uid, int Gid)
{
   syslog(LOG_ERR,"%s, IPAddress %s\n",msg,IP);
   printf("Content-type: text/html\n");
   puts("\n");
   printf("<meta http-equiv=\"Refresh\" content=\"%s;URL=/cgi-bin/chetcpasswd.cgi\">\n",WarningTime);
   printf("<html>");
   printf("<style>\n");
   printf(".body {margin:50px; background-color:%s}\n",BackgroundColor);
   printf(".warn {font-family:%s;font-size:%s;color:%s;text-align:center;padding:10px}\n", \
                FontFamily,WarningFontSize,WarningFontColor);
   printf("</style>\n");
   printf("<body class=\"body\">\n");
   printf("<table class=\"warn\">\n");
   printf("<tr><td class=\"warn\">%s</td></tr>\n",msg);
   printf("</table>\n");
   printf("</html>\n");
  	
   if((setuid(Uid)) < 0) eperror("setuid");
   if((setgid(Gid)) < 0) eperror("setgid");
   exit(1);
}


void alert(char *msg, int Uid, int Gid)
{
   FILE *alert;
   char template[255]="/var/tmp/chetcpwd-alert.XXXXXX";
   int  fd1;

   printf("Content-type: text/html\n");
   puts("\n");
   syslog(LOG_ERR,"%s, IPAddress %s\n",msg,IP);

   if(strlen(AlertEmail) > 0) {
      fd1 = mkstemp(template);
      if((fd1 == -1 ) ||
         ((alert = fdopen (fd1, "w+" )) == NULL)  ) {    /* failure, bail out */
         Hmsg(text[16], Uid, Gid);
      }
      sprintf(buf,"IP Address: %s\n",IP);
      fputs(buf,alert);
      sprintf(buf,"Incident: %s\n",msg);
      fputs(buf,alert);
      fclose(alert);

      sprintf(buf,"mail -s \"CHETCPASSWD Alert\" %s < %s", AlertEmail, template);
      system(buf);
      unlink(template);
   }

//   printf("Content-type: text/html\n");
//   puts("\n");
   printf("<html>");
   printf("<style>\n");
   printf(".body {margin:50px; background-color:black}\n");
   printf(".warn {font-family:%s;font-size:15px;color:red;text-align:center;padding:10px}\n", \
                FontFamily);
   printf("</style>\n");
   printf("<body class=\"body\">\n");
   printf("<table class=\"warn\">\n");
   printf("<tr><td class=\"warn\"><b>%s</b></td></tr>\n",msg);
   printf("</table>\n");
   printf("</html>\n");
  	
   if((setuid(Uid)) < 0) eperror("setuid");
   if((setgid(Gid)) < 0) eperror("setgid");

   exit(1);
}


void success(char *msg, int Uid, int Gid)
{
   syslog(LOG_ERR,"%s, IPAddress %s\n",msg,IP);
   printf("Content-type: text/html\n");
   puts("\n");
   printf("<meta http-equiv=\"Refresh\" content=\"%s;URL=%s\">\n",WarningTime,SuccessUrl);
   printf("<html>");
   printf("<style>\n");
   printf(".body {margin:50px; background-color:%s}\n",BackgroundColor);
   printf(".warn {font-family:%s;font-size:%s;color:%s;text-align:center;padding:10px}\n", \
                FontFamily,SuccessFontSize,SuccessFontColor);
   printf("</style>\n");
   printf("<body class=\"body\">\n");
   printf("<table class=\"warn\">\n");
   printf("<tr><td class=\"warn\">%s</td></tr>\n",msg);
   printf("</table>\n");
   printf("</html>\n");
  	
   if((setuid(Uid)) < 0) eperror("setuid");
   if((setgid(Gid)) < 0) eperror("setgid");
   exit(0);
}


void putline(FILE *f,char *l) {
   int x;

   for(x=0;l[x];x++) fputc(l[x],f);
   return;
}


int vauth(char *buf, char *ip)
{
   char a1[4],a2[4],a3[4],a4[4];
   char o1[4],o2[4],o3[4],o4[4];
   char buf2[255];
   char ip2[255];
   int ok=1;

   buf[strlen(buf)-1]='\0';

   if(strcmp(buf,"0.0.0.0") == 0)
      return(1);
   if(strcmp(buf,ip) == 0)
      return(1);

   strcpy(buf2,buf);
   strcpy(ip2,ip);

   getword(a1,buf2,'.');
   getword(a2,buf2,'.');
   getword(a3,buf2,'.');
   getword(a4,buf2,' ');

   getword(o1,ip2,'.');
   getword(o2,ip2,'.');
   getword(o3,ip2,'.');
   getword(o4,ip2,' ');

   ok=1;
   if(strcmp(a1,"0") != 0){
      if(strcmp(a1,o1) != 0)
         ok=0;
   }
   if(strcmp(a2,"0") != 0){
      if(strcmp(a2,o2) != 0)
         ok=0;
   }
   if(strcmp(a3,"0") != 0){
      if(strcmp(a3,o3) != 0)
         ok=0;
   }
   if(strcmp(a4,"0") != 0){
      if(strcmp(a4,o4) != 0)
         ok=0;
   }

   return(ok);
}


void eperror(s)
register char *s;
{
   perror("chetcpasswd.cgi");
   exit(1);
}


static unsigned char itoa64[] =         /* 0 ... 63 => ascii - 64 */
        "./0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz";

void to64(s, v, n)
   register char *s;
   register long v;
   register int n;
{
   while (--n >= 0) {
      *s++ = itoa64[v&0x3f];
      v >>= 6;
   }
}

static void
fixpwd(str)
   unsigned char   *str;
{
   unsigned char   *dest = str;

   while (str[0]) {
      if (str[0] == '+')
         dest[0] = ' ';
      else if (str[0] == '%' && hhex(str[1]) && hhex(str[2])) {
         dest[0] = (unsigned char) htoi(str + 1);
         str += 2;
      } else dest[0] = str[0];

      str++;
      dest++;
   }

   dest[0] = '\0';
   return;
}

static int
htoi(s)
   unsigned char   *s;
{
   int     value;
   char    c;

   c = s[0];
   if (isupper(c))
      c = tolower(c);
   value = (c >= '0' && c <= '9' ? c - '0' : c - 'a' + 10) * 16;

   c = s[1];
   if (isupper(c))
      c = tolower(c);
   value += c >= '0' && c <= '9' ? c - '0' : c - 'a' + 10;

   return (value);
}

static int
test_ip_address(char *ip)
{
   char *str;
   int z;

   if(strlen(ip) > 15)
      noway();

   str=ip;
   for(z=0; z<=strlen(ip); z++) {
      str=(char *) strstr(ip, ".");
      if(strstr(str,".") == 0) noway();
      str="0";
      str++;
   }

   str=ip;
   for(z=0; z<=strlen(ip); z++) {
      if(str[z]!='.' == 0 &&
         str[z]!='0' == 0 &&
         str[z]!='1' == 0 &&
         str[z]!='2' == 0 &&
         str[z]!='3' == 0 &&
         str[z]!='4' == 0 &&
         str[z]!='5' == 0 &&
         str[z]!='6' == 0 &&
         str[z]!='7' == 0 &&
         str[z]!='8' == 0 &&
         str[z]!='9')
            noway();
   }
}

static int
noway()
{
   puts("Content-type: text/html");
   puts("");
   puts("No way ...<br>");
   exit(1);
}
