/*
 * br_macros.cpp  --  Part of the CinePaint plug-in "Bracketing_to_HDR"
 *
 * Copyright (c) 2005-2006  Hartmut Sbosny  <hartmut.sbosny@gmx.de>
 *
 * LICENSE:
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */
/**
  br_macros.cpp  --  output functions for the macros in "br_macros.h".
*/

#include <cstdio>               // printf(),...
#include "br_macros.hpp"        // declarations of br_*()
#include "br_enums.hpp"         // ImageType
#include "br_enums_strings.hpp" // IMAGE_TYPE_STR[] 


void br_print_CTOR (const char* func, const char* s)
{
    if (!s || *s=='\0')  printf("CTOR %s()...\n", func);
    else                 printf("CTOR %s(\"%s\")...\n", func, s);
}
void br_print_CTOR (const char* func, const char* s, void* pThis)
{
    if (!s || *s=='\0')  printf("CTOR %s()[ this=%p ]...\n", func, pThis);
    else                 printf("CTOR ~%s(\"%s\")[ this=%p ]...\n", func, s, pThis);
}
void br_print_DTOR (const char* func, const char* s)
{
    if (!s || *s=='\0')  printf("DTOR ~%s()...\n", func);
    else                 printf("DTOR ~%s(\"%s\")...\n", func, s);
}
void br_print_DTOR (const char* func, const char* s, void* pThis)
{
    if (!s || *s=='\0')  printf("DTOR ~%s()[ this=%p ]...\n", func, pThis);
    else                 printf("DTOR ~%s(\"%s\")[ this=%p ]...\n", func, s, pThis);
}
void br_print_WINCALL (const char* s)
{
    if (!s || *s=='\0')  printf("window callback() called...\n");
    else                 printf("window callback(\"%s\") called...\n", s);
}
void br_print_s (const char* s)
{
    if (!s || *s=='\0')  printf("()...\n");
    else                 printf("(\"%s\")...\n", s);
}

void br_fail_warning (const char* cond, 
                      const char* file, int line, const char* func)
{
    fprintf(stderr, "\nBr2Hdr-WARNING **: `%s' failed in %s() [%s:%d]\n",
            cond, func, file, line);
}

void br_assert_failed (const char* cond, 
                       const char* file, int line, const char* func)
{
    fprintf(stderr, "\nBr2Hdr-ASSERTION *** `%s' failed in %s() [%s:%d]\n",
            cond, func, file, line);
}
                     
void br_not_impl_image_type (const char* file, int line, const char* func, br::ImageType type)
{
    fprintf(stderr, "\nBr2Hdr-WARNING **: [%s:%d] %s():\n\tNot implemented for image type '%s'.\n", 
            file, line, func, br::IMAGE_TYPE_STR[type]);
}

void br_not_impl_data_type (const char* file, int line, const char* func, br::DataType type)
{
    fprintf(stderr, "\nBr2Hdr-WARNING **: [%s:%d] %s():\n\tNot implemented for data type '%s'.\n", 
            file, line, func, br::DATA_TYPE_STR[type]);
}

// END OF FILE
