#include "cp_types.h"
#include "cp_proto.h"

/* Find v in combinatoric drawing order, report two circles 
used to locate it, their centers, all radii, resulting center, 
resulting radius. Return number of v in drawing order. Note: 
actual drawing order may be different due to placement 
inconsistencies. (fix?? may want to check either comb or actual order.) */

int cir_placement_data(struct p_data *p,int v)
{
  int nf=p->first_face,count,j,k,indx,i,w;

  if (v<0 || v>p->nodecount) return 0;
  for (i=1;i<=p->nodecount;i++) p->packK_ptr[i].util_flag=0;
  for (i=0;i<3;i++) p->packK_ptr[p->faces[nf].vert[i]].util_flag=1;
  count=3;

  sprintf(msgbuf,"Placement info for circle %d, (curv is %d): ",
	  v,p->hes);
  msg();
  indx=p->faces[nf].index_flag;
  if (v==p->faces[nf].vert[indx])
    {
      sprintf(msgbuf,"   v%d is first circle placed, hence at origin.",v);
      msg();
      return 1;
    }
  if (v==p->faces[nf].vert[(indx+1)%3])
    {
      sprintf(msgbuf,"   v%d is second circle placed, "
	      "on pos y axis at y=%e.",
	      v,p->packR_ptr[v].center.im);
      msg();
      return 2;
    }
  do
    {
      indx=(p->faces[nf].index_flag+2)%3;
      w=p->faces[nf].vert[indx];
      if (v==w) /* nf = face for placing v? */
	{
	  j=p->faces[nf].vert[(indx+1)%3];
	  k=p->faces[nf].vert[(indx+2)%3];
	  if (!p->packK_ptr[j].util_flag || !p->packK_ptr[k].util_flag)
	    {
	      sprintf(msgbuf,"Two lead circles not yet placed");
	      emsg();
	      return 0;
	    }
	  sprintf(msgbuf,"   v%d is in oriented face %d = <%d,%d,%d> "
		  "and is #%d circle placed.\n",
		  v,nf,(j=p->faces[nf].vert[(indx+1)%3]),
		  (k=p->faces[nf].vert[(indx+2)%3]),v,count);
	  msg();
	  sprintf(msgbuf,"   Inv distance errof, %d to %d, "
		  "is %e\n   Radii and centers are:",
		  j,k,invdist_err(p,j,k));
	  msg();
	  sprintf(msgbuf,"     circle %d: rad=%e, cent = (%e,%e).",
		  j,radius(p,j),p->packR_ptr[j].center.re,
		  p->packR_ptr[j].center.im);
	  msg();
	  sprintf(msgbuf,"     circle %d: rad=%e, cent = (%e,%e).",
		  k,radius(p,k),p->packR_ptr[k].center.re,
		  p->packR_ptr[k].center.im);
	  msg();
	  sprintf(msgbuf,"     circle %d: rad=%e, cent = (%e,%e).",
		  v,radius(p,v),p->packR_ptr[v].center.re,
		  p->packR_ptr[v].center.im);
	  msg();
	  return count;
	} 
      if (!p->packK_ptr[w].util_flag)
	{
	  p->packK_ptr[w].util_flag=1;
	  count++;
	}
      nf=p->faces[nf].next_face;
    }  while (nf!=p->first_face);
  return 1;
} /* cir_placement_data */
