#include "cp_types.h"
#include "cp_proto.h"

/* build a p_light structure for which the verts of
   p with their marks set are "variable" (this means
   they are subject to change in repacking); any missing
   nghb's are also sent, these are the "fixed" verts */

struct p_light *convert_to_p_light(struct p_data *p)
{
  int i,j,k,m,w,count=0,tick=1,aim_count=0;
  int *aim_indices=NULL;
  double *aims=NULL;
  struct p_light *pl;
  struct K_data *pK_ptr;
  struct R_data *pR_ptr;

  pK_ptr=p->packK_ptr;pR_ptr=p->packR_ptr;
  /* create p_light area */
  pl=(struct p_light *)calloc((size_t)1,sizeof(struct p_light));
  pl->counts=(int *)calloc((size_t)12,sizeof(int));
  pl->counts[1]=(int)p->hes;
  pl->counts[4]=p->nodecount;

  /* count variable verts */
  for (i=1;i<=p->nodecount;i++)
    if (pK_ptr[i].mark) 
      {
	count++;
	pK_ptr[i].mark=count;
	pl->counts[3] += pK_ptr[i].num+2;
      }
  if (!count) goto SCREWUP;
  pl->var_indices=(int *)calloc((size_t)(pl->counts[3]+1),sizeof(int));
  pl->counts[2]=count; 

  /* continue to get "fixed" (i.e., nghb's of variable verts) */
  for (i=1;i<=p->nodecount;i++)
    if (pK_ptr[i].mark>0)
      for (j=0;j<=pK_ptr[i].num;j++)
	if (!pK_ptr[pK_ptr[i].flower[j]].mark)
	  {
	    count++;
	    pK_ptr[pK_ptr[i].flower[j]].mark=-count;
	  }

  pl->counts[0]=count; /* total nodecount */
  pl->orig_indices=(int *)calloc((size_t)(count+1),sizeof(int));
  pl->orig_fixed=pl->orig_indices+pl->counts[2]+1;
  pl->radii=(double *)
    calloc((size_t)(count+1),sizeof(double));
  pl->fixed_radii=pl->radii+pl->counts[2]+1;
  for (i=1;i<=p->nodecount;i++)
    {
      k=pK_ptr[i].mark;
      if (k>0) /* variable vert */
	{
	  pl->radii[k]=p->packR_ptr[i].rad;
	  if ( (pK_ptr[i].bdry_flag && pR_ptr[i].aim<0)
	       || fabs(2.0*M_PI- pR_ptr[i].aim)>m_toler)
	    {
	      if (!aim_count) /* must allocate space for aims */
		{
		  aim_indices=(int *)
		    calloc((size_t)(pl->counts[2]+1),sizeof(int));
		  aims=(double *)
		    calloc((size_t)(pl->counts[2]+1),sizeof(double));
		}
	      aim_count++;
	      aim_indices[aim_count]=k;
	      aims[aim_count]=pR_ptr[i].aim;
	    }
	  pl->orig_indices[k]=i;
	}
      else if (k<0) /* bdry */
	{
	  pl->radii[-k]=p->packR_ptr[i].rad;
	  pl->orig_indices[-k]=i;
	}
    }

  /* store variable vert info */
  for (i=1;i<=p->nodecount;i++)
    if ((w=pK_ptr[i].mark)>0)
      {
	pl->var_indices[tick++]=pK_ptr[i].num;
	/* create flower list. Note: for interior (in parent),
	   record the redundant last petal index. */
	for (j=0;j<=pK_ptr[i].num;j++)
	  {
	    m=pK_ptr[i].flower[j];
	    if (!(k=pK_ptr[m].mark)) 
	      goto SCREWUP; /* every petal should be a variable
			       or fixed vert, hence mark >0 or <0,
			       resp. */
	    k = (k<0) ? -k : k;
	    pl->var_indices[tick++] = k;
	  }
      }

  /* move aim info to properly sized space. */
  if (aim_count)
    {
      pl->counts[5]=aim_count;
      pl->aim_indices=(int *)calloc((size_t)(aim_count+1),sizeof(int));
      pl->aims=(double *)calloc((size_t)(aim_count+1),sizeof(double));
      for (i=1;i<=aim_count;i++)
	{
	  *(pl->aim_indices+i)=*(aim_indices+i);
	  *(pl->aims+i)=*(aims+i);
	}
      free(aims);
      free(aim_indices);
    }
	
  /* success */
  for (i=1;i<=p->nodecount;i++) pK_ptr[i].mark=0;
  return pl; 

 SCREWUP:
  for (i=1;i<=p->nodecount;i++) pK_ptr[i].mark=0;
  free_p_light(&pl);
  return NULL;
} /* convert_to_p_light */


