#include "cp_types.h"
#include "cp_proto.h"

/* compute ang sum; should not be called if there are overlaps. */

int h_anglesum(struct p_data *p,int i,double s,double *c,int *flag)
{
  int k,j2,j1;
  double s1,s2,s3,m2,m3,a1,o1,o2,o3;
  struct K_data *pK_ptr;
  struct R_data *pR_ptr;

  pK_ptr=p->packK_ptr;
  pR_ptr=p->packR_ptr;
  *c=0;
  *flag=0; 
  if (s<=0) return 1; /* infinite radius at vertex of interest */
  j2=pK_ptr[i].flower[0];
  s2=pR_ptr[j2].rad;
  if (s2<=0)  m2 = 1;
  else  m2 = (1-s2)/(1-s*s2);
  if (!p->overlap_status)
    for (k=1;k<=pK_ptr[i].num;k++)
      {
	s3=pR_ptr[pK_ptr[i].flower[k]].rad;
	if (s3<=0)  m3 = 1;
	else   m3 = (1-s3)/(1-s*s3);
	a1 = 1 - 2*s*m2*m3;
	if (a1>1)  a1 = 1;
	if (a1<-1) a1 = -1;
	*c+=acos(a1);
	s2 = s3;
	m2 = m3;
      }
  else
    {
      o2=pK_ptr[i].overlaps[0];
      for (k=1;k<=pK_ptr[i].num;k++)
	{
	  s1=s2;
	  o1=o2;
	  j1=j2;
	  j2=pK_ptr[i].flower[k];
	  s2=pR_ptr[j2].rad;
	  o2=pK_ptr[i].overlaps[k];
	  o3=pK_ptr[j1].overlaps[nghb(p,j1,j2)];
	  *c+=acos(h_cos_overlap(s,s1,s2,o3,o2,o1,flag));
	}
    }
  return 1;
} /* h_anglesum */
