/* cp_special.c   Routines that can be tried out without recompiling rest
of programs. There is button allowing selection of 5 different specials.*/

#include "cp_head.h"
#include "xv_head.h"

FILE *fp;

/* ==========Must update this menu when routines change=============== */

Menu special_menu;

int create_special_menu()
/* menu attached to "Special button" */
{
  special_menu=menu_create(MENU_STRINGS,
     "approx radii using exp(z^3)",
     "approx radii using exp(z^2)",
     "make radial slits in pack: special3 p <z..>",
     "give center ratios, p1/p2: special4 p1 p2 <v..> ",
     "decrease bdry angle sums",
     "Shrink to square","Shrink/expand","Shrink to strip",
     "shift hex branch point v-->w: special9 p v w",
     0,
     MENU_NOTIFY_PROC,handle_special_proc,
     0);
  return 1;
} /* create_special_menu */

int special2(char *datastr)
     /* Jason Howard's routine to measure moduli of tori generated
	from current pack by random "Whitehead flips". 6/01 */
{
  int count=0,nodecount,num,i;
  int j,n;
  int lpcnt=0;
  int f1=3; /* number of flips */
  int k;
  int v1; /* first random vertice */
  int v2; /* neighbor of v1 */
  complex W[7]; /* matrix for side pairing maps */
  complex C[1000]; /* max number of flips is 1000 */
  complex w,wcheck; /* period ratio */ 
  complex tau;
  complex r1,r12,r2,r22,r3,r32;
  double bnd;
  struct p_data *p=&(packdata[current_p]);
  complex m_one;
  Mobius mob;

  //  sprintf(msgbuf,"Hello\n");
  //msg();
  if (sscanf(datastr,"%d",&f1)!= 1 || f1<0 
      || p->num_bdry_comp>0 || p->genus!=1)
    return 0;
  sprintf(msgbuf,"Hello %d \n", f1);
  msg();


/* read data in. Want w1,w2 ... = cdiv(mob.a, mob.b) for each 
   edge-pair[i].mob consider putting in array W and do for loop on 
   i.(this will change r1 etc)*/
  nodecount=p->nodecount;
  m_one.re=-1.0;m_one.im=0.0;
  k=0;
  do
    {
      for(n=0;n<1;n++){
      
      /* since arrays start at 0 in C right? */
      
      j=1;
      while(p->edge_pair[j].edge)
	{
	  mob=p->edge_pair[j].mob;
	  W[j]=cdiv(mob.b,mob.a);
	  j++;
	}
      if (mob.a.re!=0 && mob.a.im!=0) {    

/*----------Calculate ratios and select candidate in upper half plane ------*/

      r1=cdiv(W[1],W[2]);
      r12=cdiv(W[2],W[1]);
      r2=cdiv(W[3],W[2]);
      r22=cdiv(W[2],W[3]);
      r3=cdiv(W[3],W[4]);
      r32=cdiv(W[4],W[3]);
      
      /*get initial tau in upper half plane*/
     
      if (r1.im>=0)         
	w=r1;
      
      else if (r12.im>=0)
	w=r12;
      
      else if (r2.im>=0)
	w=r2;
      
      else if (r22.im>=0)
	w=r22;
      
      else if (r3.im>=0)
	w=r3;
      
      else if (r32.im>=0)
	w=r32;
      
      else 
	return 0;
      
      /* lower bnd for imag part in fundemental cell*/
      if (w.re>=1) 
	    {
	      w.re -= floor(w.re);
	    }
	  
	  else if (w.re<-1){
	     w.re = w.re - floor(w.re);
	  }
      
      bnd=sqrt(1-(w.re)*(w.re));
 
      lpcnt=0;
      while (fabs(w.re)>.5 || w.im<bnd)
	{ 
	  wcheck.re=w.re;
	  wcheck.im=w.im;
	  if (w.re>=1) 
	    {
	      w.re -= floor(w.re);
	    }
	  
	  else if (w.re<-1){
	     w.re = w.re - floor(w.re);
	  }
	  
	  else if (w.re<=1 && w.re>.5){
	    w.re -= 1.0;
	  }
	  
	  else if (w.re>=-1 && w.re<-.5){
	    w.re += 1.0;
	  }
	  
	  
	  if (w.im<bnd) {
	    w=cdiv(m_one,w);
	  }

	  if (w.re>=1) 
	    {
	      w.re -= floor(w.re);
	    }
	  
	  else if (w.re<-1){
	     w.re = w.re - floor(w.re);
	  }
	  
	  bnd=sqrt(1-(w.re)*(w.re));
	  lpcnt=lpcnt+1;

          if (lpcnt>5000){
	    sprintf(msgbuf,"**ERROR**Caught in infinte loop ");
	    msg();
	    sprintf(msgbuf,"Flip # %d of %d",count,f1);
	    msg();
	    
	    return 0;
} 

	  //  need to add more conditions HERE to wcheck
	  //if (w.re == wcheck.re && w.im == wcheck.im){
	  //  sprintf(msgbuf,"error:caught in infinte loop ");
	  // msg();
	  //  return 0;

	  // }
	 

	   
	}
      
      tau=w;
        sprintf(msgbuf,"tau=%lf + %lf i",tau.re,tau.im);
      msg();

      // C[count]=tau;
      //count++;

      if (count<f1)
	{
	  v1=rand()%nodecount;
	  v1=v1+1;
	  //  sprintf(msgbuf,"v1=%d",v1);
	  //msg();
	  num=p->packK_ptr[v1].num;
	  //      v2=rand()%(num-1);
	  v2=p->packK_ptr[v1].flower[rand()%(num)];
	  
	  //sprintf(msgbuf,"v2=%d",v2);
	  // msg();
	 


     
	  sprintf(buf,"flip %d %d",v1,v2);
    
	  handle_cmd(buf,&current_p);
	  sprintf(buf,"repack 2000");
	  handle_cmd(buf,&current_p);
	  sprintf(buf,"fix");
	  handle_cmd(buf,&current_p);

	  //sprintf(buf,"disp -w -C -Rn a");
	  //handle_cmd(buf,&current_p);
	 
	  //sprintf(msgbuf,"Flip # %d of %d",count,f1);
	  //msg();
	}

      }

      else if (mob.a.re==0 && mob.a.im==0){
	
	sprintf(buf,"unflip %d %d",v1,v2);
	handle_cmd(buf,&current_p);
	sprintf(buf,"repack 2000");
	handle_cmd(buf,&current_p);
	sprintf(buf,"fix");
	handle_cmd(buf,&current_p);

	sprintf(buf,"write /tmp/unflip.p");
	handle_cmd(buf,&current_p);
	printf("unflip %d %d.\n",v1,v2);
	return 0;

	count=count-1;
	k=k+1;
}
    }
      C[count]=tau;
      count++;

    } while (count<f1);
  
    
  fp=fopen("tau.dat","w");
  for (i=0;i<count;i++)
    // fprintf(fp,"%d: tau = (%.12f,%.12f)\n",i,C[i].re,C[i].im);
fprintf(fp," %.12f %.12f\n",C[i].re,C[i].im);
  fclose(fp);
sprintf(msgbuf,"Accesed unflip command %d times",k);
	  msg();

} /* special2 */





int special1(char *datastr)
/* use info about p2 (domain packing) with constant
radii to set approximate radii of p1 (range packing) to approximate 
"exp(z^3)". Results to p1. Assume same complex, both eucl. 
p2 is regular hex packing, radii given by rad, center point given by  
(m*(2*rad),n*(rad+sqr(3)*rad*I). Default to rad=1, m=n=0.  */
{
	int next,pnum1,pnum2,flag=0,i,m,n,cmdcount;
	double rad,mf,nf;
	complex z,w;
	struct p_data *p1,*p2;
	struct R_data *pR_ptr1,*pR_ptr2;
	struct K_data *pK_ptr1;

	if ( (cmdcount=sscanf(datastr,"%d %d %lf %d %d",
		&pnum1,&pnum2,&rad,&m,&n))>2
		&& pnum1 >= 0 && pnum1 < NUM_PACKS 
		&& pnum2 >= 0 && pnum2 < NUM_PACKS
		&& pnum1 != pnum2 
		&& packdata[pnum1].status && packdata[pnum2].status 
		&& packdata[pnum1].nodecount==packdata[pnum2].nodecount)
	 {
		p1=&packdata[pnum1];
		p2=&packdata[pnum2];
		pR_ptr1=p1->packR_ptr;  pR_ptr2=p2->packR_ptr;
		pK_ptr1=p1->packK_ptr;  
		if (p1->hes!=0 || p2->hes!=0)
		 {
			strcpy(msgbuf,"Packs are not both euclidean.");
			emsg();
			return 0;
		 }
		rad = (cmdcount>2 && rad>0) ? rad : 1.0;
		for (i=1;i<=p1->nodecount;i++)
			pR_ptr2[i].rad=rad;
		comp_pack_centers(p2,0,0,2,okerr);
		next=p1->beta;
		while (!flag || next!=p1->beta) /* set boundary radii only*/
		 {
		   mf = (cmdcount>3) ? (double)m: 0;
		   nf = (cmdcount>4) ? (double)n: 0;
		   z.re = pR_ptr2[next].center.re + 2*mf*rad + nf*rad;
		   z.im = pR_ptr2[next].center.im + nf*sqrt(3.0)*rad;
		   w=cmult(cmult(z,z),z);	   
		   pR_ptr1[next].rad=exp(w.re);
		   next=pK_ptr1[next].flower[0];
		   flag=1;
		 }
		fillcurves(p1);
		sprintf(msgbuf,"Approx bdry radii are stored in %d.",pnum1);
		msg();
		return 1;
	 }
	strcpy(msgbuf,"Usage: special1 p q x m n. q=domain,p=range,x=rad,m,n tell starting circle.");
	emsg();
	return 0;
} /* special1 */


 
int special3(char *datastr)
/* Cut radial edeg-slits in active packing from 
up to 20 specified complex numbers out towards infinity. May be problem if
numbers are too close or have arguments too close.
Usage: special3 p <filename> z1.re z1.im ... zn.re zn.im 
Output written to filename included edge descriptions before 
usual packing data.*/
{
  int go_flag,count,i,j,n,k,v,w,bestpetal=0,pnum,newvert;
  complex *tips;
  int *verts,*starts,*finishes;
  double dist,arg,v_arg,argdiff,bestarg,newdist;
  char next[256],outfile[256],*listbuf,*nextptr;
  struct Vertlist *vertlist,*trace;
  struct p_data *p;
  struct K_data *pK_ptr;
  struct R_data *pR_ptr;

  nextptr=datastr;
  if (!grab_next(&nextptr,next) || !sscanf(next,"%d",&pnum) 
      || pnum<0 || pnum>=NUM_PACKS || !grab_next(&nextptr,next)
      || !sscanf(next,"%s",outfile))
    {
      sprintf(msgbuf,"special3 didn't get the required pack "
	      "number or output filename:\n Usage: special3 pnum "
	      "<fileneme> z_1.re z_1.im ... z_n.im z_n.im.");
      emsg();
      return 0;
    }
  p=&packdata[pnum];
  pR_ptr=p->packR_ptr;
  pK_ptr=p->packK_ptr;
  tips=(complex *)calloc(21,sizeof(complex));
  verts=(int *)calloc(21,sizeof(int));
  starts=(int *)calloc(21,sizeof(int));
  finishes=(int *)calloc(21,sizeof(int));
  n=0;
  while (n<20 && grab_next(&nextptr,next) && sscanf(next,"%lf",&(tips[n].re))
	 && grab_next(&nextptr,next) && sscanf(next,"%lf",&(tips[n].im)))
    n++;
  if (!n)
    {
      sprintf(msgbuf,"Special3 didn't get required complex "
	      "numbers:\n   Usage: special3 pnum <fileneme> "
	      "z_1.re z_1.im ... z_n.im z_n.im.");
      emsg();
      return 0;
    }
     /* find closest circle centers */
  count=n;
  for (i=0;i<count;i++)
    {
      go_flag=0;
      dist=cAbs(csub(pR_ptr[1].center,tips[i]));
      v=1;
      if (dist<2.0*pR_ptr[v].rad) go_flag=1;
      for (j=1;j<=p->nodecount;j++)
	if ((newdist=cAbs(csub(pR_ptr[j].center,tips[i])))<dist)
	  {
	    v=j;
	    dist=newdist;
	    if (newdist<2.0*pR_ptr[v].rad) go_flag=1;
	  }
      if (!go_flag || pK_ptr[v].bdry_flag)
	 /* complex number not near interior vert */
	{
	  for (k=i;k<count-1;k++)
	    {
	      tips[k].re=tips[k+1].re;
	      tips[k].im=tips[k+1].im;
	    }
	  count--;
	}
      else verts[i]=v;
    }
  if (count<n)
    {
      sprintf(msgbuf,"Special3: Found interior vertices near "
	      "only %d of the %d specified complex numbers.",count,n);
      emsg();
      if (count==0) return 0;
    }
/* ----------- for each vert, find edge-path, make slit --------- */
  listbuf=(char *)malloc(3000*sizeof(char));
  for (i=0;i<count;i++)
     {
       vertlist=(struct Vertlist *)calloc(1,sizeof(struct Vertlist));
       trace=vertlist;
       trace->v=v=verts[i];
       dist=cAbs(pR_ptr[v].center);
       v_arg=Arg(pR_ptr[v].center);
       w=v;
       while(!pK_ptr[w].bdry_flag)
	 {
	   go_flag=0;
	   bestarg=2*M_PI;
	   for (j=0;j<=pK_ptr[w].num-1;j++)
	     {
	       k=pK_ptr[w].flower[j];
	       if (cAbs(pR_ptr[k].center)>cAbs(pR_ptr[w].center))
		 {
		   arg=Arg(pR_ptr[k].center);
		   argdiff=fabs(arg-v_arg);
		   if (fabs(argdiff-2*M_PI)<argdiff) 
		     argdiff=fabs(argdiff-2*M_PI);
		   if (argdiff<bestarg)
		     {
		       bestarg=argdiff;
		       go_flag=1;
		       bestpetal=k;
		     }
		 }
	     }
	   if (!go_flag)
	     {
	       sprintf(msgbuf,"Special3: problem with edge-path from v%d.",v);
	       emsg();
	       return 0;
	     }
	   trace=trace->next=
	     (struct Vertlist *)calloc(1,sizeof(struct Vertlist));
	   trace->v=w=bestpetal;
	 }
       if (trace==vertlist || !vertlist->next)
	 {
	   sprintf(msgbuf,"Special3: problem with edge-path from v%d.",v);
	   emsg();
	   return 0;
	 } 
       listbuf[0]='\0';
       trace=vertlist;
       while (trace && trace->next && trace->next->next) 
	 trace=trace->next;
       while (trace->v!=v && trace->next)
	 {
	   sprintf(next,"%d ",trace->next->v);
	   strcat(listbuf,next);
	   trace->next=NULL;
	   trace=vertlist;
	   while (trace && trace->next && trace->next->next) 
	     trace=trace->next;
	 }
       sprintf(next,"%d ",vertlist->next->v);
       strcat(listbuf,next);
       sprintf(next,"%d ",v);
       strcat(listbuf,next);
       vert_free(&vertlist);
       newvert=p->nodecount+1;
       if (!slit_complex(p,listbuf))
	 {
	   sprintf(msgbuf,"Special3: couldn't slit complex from v%d.",v);
	   emsg();
	   return 0;
	 }
       grab_next(&listbuf,next);
       sscanf(next,"%d",&starts[i]);
       finishes[i]=newvert;
     }

/* ------------ set alpha and gamma ---------------- */
  /* by default, alpha==1 and gamma==2 is the tip of the 
     first slit. */

  if (p->alpha!=1) 
    {
      sprintf(msgbuf,"swap -p%d %d 1",pnum,p->alpha);
      handle_cmd(msgbuf,&current_p);
    }
  if ((v=verts[0])>0 && v!=2)
    {
      sprintf(msgbuf,"swap -p%d %d 2",pnum,verts[0]);
      handle_cmd(msgbuf,&current_p);
      sprintf(msgbuf,"gamma -p%d 2",pnum);
      handle_cmd(msgbuf,&current_p);
      verts[0]=2;
    } 
  sprintf(msgbuf,"fix -p%d",pnum);
  handle_cmd(msgbuf,&current_p);

  /* ------------- write output and report ----------- */

  set_packing_path();
  strcpy(next,path);
  strcat(next,outfile);
  strcpy(outfile,next);
  if (!(fp=fopen(outfile,"w"))) 
    {
      sprintf(msgbuf,"Couldn't open %s for output.",outfile);
      emsg();
      return 0;
    }
  fprintf(fp,"BORDER_SEGMENT_COUNT:  %d\n",count);
  for (i=0;i<count;i++)
    {
      fprintf(fp,"\t %d  \t%d  %d\n",i+1,starts[i],finishes[i]);
      sprintf(msgbuf,"     Cut #%d: tip at v%d, clk'wise edge (%d, %d).",
	      i+1,verts[i],starts[i],finishes[i]);
      msg();
    }
  fprintf(fp,"\n");
  if (writepack(fp,p,0017,0))
    {
      sprintf(msgbuf,"Special3: made %d cuts in packing p%d."
	      "\n Packing with edge data written to file %s.",
	      count,pnum,outfile);
      msg();
      return 1;
    }
  sprintf(msgbuf,"Special3: something went wrong in writing output to %s.",
	  outfile);
  emsg();
  return 0;
} /* special3 */

int special4(char *datastr)
/* special routine 4. Display ratios of moduli of centers of
circles in p1 to p2. For use in Smale conjecture. Usage: p1 p2 <v..> */
{
	int v,pnum1,pnum2,dum;
	double ratio;
	char *nextpoint,*endptr,next[256];
	struct Vertlist *vertlist,*clobber;
	struct p_data *p1,*p2;

	nextpoint=datastr;
	if (!grab_next(&nextpoint,next) || !sscanf(next,"%d",&pnum1) 
	    || pnum1<0 || !grab_next(&nextpoint,next) 
	    || !sscanf(next,"%d",&pnum2) || pnum2<0
	    || pnum1>=NUM_PACKS || pnum2>=NUM_PACKS) return 0;
	p1=&packdata[pnum1];
	p2=&packdata[pnum2];
	if (!p1->status || !p2->status) return 0;
	sprintf(msgbuf,"Ratios of moduli of centers, p%d/p%d.\n",
		pnum1,pnum2);
	msg();
	if (!(vertlist=node_link_parse(p1,nextpoint,&endptr,&dum))) return 0;
	clobber=vertlist;
	while (clobber && (v=clobber->v)<=p2->nodecount)
	  {
	    ratio=cAbs(p1->packR_ptr[v].center)/cAbs(p2->packR_ptr[v].center);
	    sprintf(msgbuf,"  v%d: ratio %f.\n",v,ratio);
	    msg();
	    clobber=clobber->next;
	  }
	vert_free(&vertlist);
	return 1;
} /* special4 */

int special5(char *datastr)
/* special routine 5. Mark "p1 p2 x". This reduces bdry
angle sums of p2 by x times the corresponding bdry angle sum in
p1. No angle sum of p2 is reduced below .0001; negative ones remain
unchanged; minimal error detection. */
{
	int i,p1,p2;
	double x,newaim,dec;

	if (sscanf(datastr,"%d %d %lf",&p1,&p2,&x) 
		&& p1>=0 && p1<NUM_PACKS && p2>=0 && p2<NUM_PACKS &&
		packdata[p1].status && packdata[p2].status &&
		packdata[p1].nodecount==packdata[p2].nodecount &&
		(-.5<x) && (x<.5))
	 {
		for (i=1;i<=packdata[p2].nodecount;i++)
		 {
			if (packdata[p2].packK_ptr[i].bdry_flag)
			 {
			   dec=fabs(packdata[p1].packR_ptr[i].aim)*x;
			   newaim=(fabs(packdata[p2].packR_ptr[i].aim))-dec;
			   if (newaim>0.0001) 
				   packdata[p2].packR_ptr[i].aim=newaim;
			   else packdata[p2].packR_ptr[i].aim=.0001;
			 }
		 }
	 }
	else
	 {
		strcpy(msgbuf,"Usage: special5 p q x.  Decr bdry "
		       "angles of q by x times those of p.  ");
		emsg();
		return 0;
	 }
	return 1;
} /* special5 */
 
int special6(char *datastr) 
{
	int pnum,i,count=0;
	double min_dist,xx,yy,factor=.3333;

/* must read in number of pack */

	if (sscanf(datastr,"%d %lf",&pnum,&factor) && pnum>=0 
		&& pnum<NUM_PACKS && packdata[pnum].status 
		&& packdata[pnum].hes==0 && factor>.01
		&& factor < 1.0)
	 {
/* scan vertices */
	   for (i=1;i<=packdata[pnum].nodecount;i++) 
	    {
/* pick out boundary ones */
		if (packdata[pnum].packK_ptr[i].bdry_flag) 
		 {
			xx=packdata[pnum].packR_ptr[i].center.re;
			yy=packdata[pnum].packR_ptr[i].center.im;
/* min_dist has minimum distance to unit square */
			min_dist=fabs(1-xx);
			if (fabs(xx+1)<min_dist) min_dist=fabs(xx+1);
			if (fabs(1-yy)<min_dist) min_dist=fabs(1-yy);
			if (fabs(yy+1)<min_dist) min_dist=fabs(yy+1);
/* adjust, but don't cut down by too much */
			if (min_dist<(packdata[pnum].packR_ptr[i].rad)*factor)
			 {
				packdata[pnum].packR_ptr[i].rad=
					packdata[pnum].packR_ptr[i].rad*factor;
				count++;
			 }
			else if (min_dist<packdata[pnum].packR_ptr[i].rad)
			 {
				packdata[pnum].packR_ptr[i].rad=min_dist;
				count++;
			 }
		 }
	    }
	   if (count) fillcurves(&packdata[pnum]);
	 }
	else /* if there was some problem, e.g., pack wasn't given */
	 {
		sprintf(msgbuf,"Special6 error. Is pack euclidean?");
		emsg();
		return 0;
	 }
/* return shows if any changes were made */
	return count; 
} /* special6 */

int special7(char *datastr) 
{
	int pnum,i,count=0,sideflag;
	double min_dist,xx,yy,factor=.3333,rad;

/* must read in number of pack */

	if (sscanf(datastr,"%d %lf",&pnum,&factor) && pnum>=0 
		&& pnum<NUM_PACKS && packdata[pnum].status 
		&& packdata[pnum].hes==0 && factor>.01
		&& factor < 1.0)
	 {
/* scan vertices */
	   for (i=1;i<=packdata[pnum].nodecount;i++) 
	    {
/* pick out boundary ones */
		if (packdata[pnum].packK_ptr[i].bdry_flag) 
		 {
			sideflag=1;
			xx=packdata[pnum].packR_ptr[i].center.re;
			yy=packdata[pnum].packR_ptr[i].center.im;
			rad=packdata[pnum].packR_ptr[i].rad;
			if ((xx+rad)>1.0 || (xx-rad)<-1.0 
				|| (yy+rad)>1.0 || (yy-rad)<-1.0) sideflag=0;
/* min_dist has minimum distance to unit square */
			min_dist=fabs(1-xx);
			if (fabs(xx+1)<min_dist) min_dist=fabs(xx+1);
			if (fabs(1-yy)<min_dist) min_dist=fabs(1-yy);
			if (fabs(yy+1)<min_dist) min_dist=fabs(yy+1);
/* adjust, but don't move down or up too much */
			if (min_dist<(packdata[pnum].packR_ptr[i].rad)*factor
			  || min_dist>(packdata[pnum].packR_ptr[i].rad)/factor)
			 {
			   if (!sideflag)
			    {
				packdata[pnum].packR_ptr[i].rad=
				   packdata[pnum].packR_ptr[i].rad*(1.0+ 
					factor)/2.0;
				count++;
			    }
			   else
			    {
				packdata[pnum].packR_ptr[i].rad=
				   packdata[pnum].packR_ptr[i].rad*
					(1.0 +1.0/factor)/2.0;
				count++;
			    }

			 }
			else if (min_dist > packdata[pnum].packR_ptr[i].rad 
			   && !sideflag)
			 {
				packdata[pnum].packR_ptr[i].rad=
				   packdata[pnum].packR_ptr[i].rad*
					(1.0 +factor)/2.0;
				count ++;
			 }
			else			
			 {
			  	packdata[pnum].packR_ptr[i].rad=
				   (packdata[pnum].packR_ptr[i].rad+
					min_dist)/2.0;
				count++;
			 }
		 }
	    }
	   if (count) fillcurves(&packdata[pnum]);
	 }
	else /* if there was some problem, e.g., pack wasn't given */
	 {
		sprintf(msgbuf,"Special7 error. Is pack euclidean?");
		emsg();
		return 0;
	 }
/* return shows if any changes were made */
	return count; 
} /* special7 */

int special8(char *datastr) 
{
	int pnum,i,count=0,sideflag;
	double min_dist,xx,factor=.3333,rad;

/* must read in number of pack */

	if (sscanf(datastr,"%d %lf",&pnum,&factor) && pnum>=0 
		&& pnum<NUM_PACKS && packdata[pnum].status 
		&& packdata[pnum].hes==0 && factor>.01
		&& factor < 1.0)
	 {
/* scan vertices */
	   for (i=1;i<=packdata[pnum].nodecount;i++) 
	    {
/* pick out boundary ones */
		if (packdata[pnum].packK_ptr[i].bdry_flag) 
		 {
			sideflag=1;
			xx=packdata[pnum].packR_ptr[i].center.re;
			rad=packdata[pnum].packR_ptr[i].rad;
			if ((xx+rad)>1.0 || (xx-rad)<-1.0 ) sideflag=0;
/* min_dist has minimum distance to unit square */
			min_dist=fabs(1-xx);
			if (fabs(xx+1)<min_dist) min_dist=fabs(xx+1);
/* adjust, but don't move down or up too much */
			if (min_dist<(packdata[pnum].packR_ptr[i].rad)*factor
			   || min_dist>(packdata[pnum].packR_ptr[i].rad)/factor)
			 {
			   if (!sideflag)
			    {
				packdata[pnum].packR_ptr[i].rad=
				   packdata[pnum].packR_ptr[i].rad*(1.0 +
					factor)/2.0;
				count++;
			    }
			   else
			    {
				packdata[pnum].packR_ptr[i].rad=
				   packdata[pnum].packR_ptr[i].rad*
					(1.0 +1.0/factor)/2.0;
				count++;
			    }

			 }
			else if (min_dist > packdata[pnum].packR_ptr[i].rad 
			   && !sideflag)
			 {
				packdata[pnum].packR_ptr[i].rad=
				   packdata[pnum].packR_ptr[i].rad*
					(1.0 +factor)/2.0;
				count ++;
			 }
			else			
			 {
			  	packdata[pnum].packR_ptr[i].rad=
				   (packdata[pnum].packR_ptr[i].rad+
					min_dist)/2.0;
				count++;
			 }
		 }
	    }
	   if (count) fillcurves(&packdata[pnum]);
	 }
	else /* if there was some problem, e.g., pack wasn't given */
	 {
		sprintf(msgbuf,"Special8 error. Is pack euclidean?");
		emsg();
		return 0;
	 }
/* return shows if any changes were made */
	return count; 
} /* special8 */

int special9(char *datastr)
/* sliding a branch point. In branched packing, want to
move simple branch point from a vert v to its neighbor w. For now, have
to assume we're in a branched hex packing. Vert numbers adjusted so
new branch point retains index v. */
{
  int ind,dex,jdex,i,j,v,w,ww,u,pnum,node;
  int *flower_v,*flower_w,*flower_ww;
  char *endptr,*nextpoint,next[256];
  struct Vertlist *vertlist;
  struct p_data *p;
  struct K_data *pK_ptr;
  struct R_data *pR_ptr;

  nextpoint=datastr;
  if (!grab_next(&nextpoint,next) || !sscanf(next,"%d",&pnum)
     || pnum<0 || pnum>NUM_PACKS) return 0;
  p=&packdata[pnum];
  node=p->nodecount;
  pK_ptr=p->packK_ptr;
  pR_ptr=p->packR_ptr;
  if (!(vertlist=node_link_parse(p,nextpoint,&endptr,&jdex))
     || !vertlist->next) return 0;
  v=vertlist->v;
  ww=vertlist->next->v; 
  vert_free(&vertlist);
  ind=nghb(p,v,ww);
  w=pK_ptr[v].flower[(ind+6)%pK_ptr[v].num]; /* half way around v from w */
  /* need v to have 12-flower, w and ww to have 6 flowers, all
     to be interior */
  if ( ind < 0 || pK_ptr[v].num!=12 || pK_ptr[w].num!=6 || pK_ptr[ww].num!=6
       || pK_ptr[w].bdry_flag || pK_ptr[v].bdry_flag
       || pK_ptr[ww].bdry_flag) 
    return 0;

  /* Will finally identify ww with w to become new branch point.  
     "half" of v starting at w will become new vert w;
     other half, vert ww. Here are their flowers */
  flower_w=(int *)calloc(7,sizeof(int));
  flower_w[0]=flower_w[6]=v; 
  for (i=1;i<6;i++) flower_w[i]=pK_ptr[v].flower[(ind+i)%pK_ptr[v].num];
  flower_ww=(int *)calloc(7,sizeof(int));
  flower_ww[0]=flower_ww[6]=v;
  for (i=1;i<6;i++) flower_ww[i]=pK_ptr[v].flower[(ind+6+i)%pK_ptr[v].num];
     /* flower for new v (combination of old w and ww) */
  flower_v=(int *)calloc(13,sizeof(int));
  flower_v[0]=flower_v[12]=w;
  dex=nghb(p,ww,v);
  for (i=1;i<6;i++) flower_v[i]=pK_ptr[ww].flower[(dex+i)%pK_ptr[ww].num];
  flower_v[6]=ww;
  dex=nghb(p,w,v);
  for (i=1;i<6;i++) flower_v[6+i]=pK_ptr[w].flower[(dex+i)%pK_ptr[w].num];
/* tmp fix nghbs of original v */
  for (i=1;i<6;i++)
    {
      u=pK_ptr[v].flower[(ind+i)%pK_ptr[v].num];
      if (u!=w && u!=ww && (dex=nghb(p,u,v))>=0)
	{
	  pK_ptr[u].flower[dex]=node+w;
	  if (dex==0 && !pK_ptr[u].bdry_flag)
	    pK_ptr[u].flower[pK_ptr[u].num]=node+w;
	}
      u=pK_ptr[v].flower[(ind+6+i)%pK_ptr[v].num];
      if (u!=w && u!=ww && (dex=nghb(p,u,v))>=0)
	{
	  pK_ptr[u].flower[dex]=node+ww;
	  if (dex==0 && !pK_ptr[u].bdry_flag)
	    pK_ptr[u].flower[pK_ptr[u].num]=node+ww;
	}
    }
/* fix nghbs of original w */
  dex=nghb(p,w,v);
  for (i=1;i<6;i++)
    {
      u=pK_ptr[w].flower[(dex+i)%pK_ptr[w].num];
      jdex=nghb(p,u,w);
      pK_ptr[u].flower[jdex]=v;
      if (jdex==0 && !pK_ptr[u].bdry_flag) 
	pK_ptr[u].flower[pK_ptr[u].num]=v;
    }
/* fix nghbs of original ww */
  dex=nghb(p,ww,v);
  for (i=1;i<6;i++)
    {
      u=pK_ptr[ww].flower[(dex+i)%pK_ptr[ww].num];
      jdex=nghb(p,u,ww);
      pK_ptr[u].flower[jdex]=v;
      if (jdex==0 && !pK_ptr[u].bdry_flag) 
	pK_ptr[u].flower[pK_ptr[u].num]=v;
    }
/* final fix of nghbs of original v */
  for (i=0;i<pK_ptr[v].num;i++)
    {
      u=pK_ptr[v].flower[i];
      for (j=0;j<=pK_ptr[u].num;j++)
	{
	  if (pK_ptr[u].flower[j]==node+w) pK_ptr[u].flower[j]=w;
	  else if (pK_ptr[u].flower[j]==node+ww) pK_ptr[u].flower[j]=ww;
	}
    }

/* implement new flowers, num's, etc. */

  sprintf(msgbuf,"Special9: shifted branch point %d to %d.",v,ww);
  msg();

  free(pK_ptr[v].flower);
  pK_ptr[v].flower=flower_v;

  free(pK_ptr[w].flower);
  pK_ptr[w].flower=flower_w;

  free(pK_ptr[ww].flower);
  pK_ptr[ww].flower=flower_ww;
  pK_ptr[w].num=pK_ptr[ww].num=6;
 
  complex_count(p,1);
  facedraworder(p,0);
  return 1;
} /* special9 */
  


