#include "cp_types.h"
#include "cp_proto.h"

/* given a side_pairing index, record the mobius transform for
the side-pairing. */

int pair_mobius(struct p_data *p,int n)
{
  int length=0,indx,fore_indx,vert,cross_indx,err_flag=0;
  complex a,b,A,B;
  struct RedList *edge,*mate,*fore_face,*cross;

  while (p->edge_pair[length+1].edge)
    length++;
  if (n<1 || n>length) return 0;
  edge=p->edge_pair[n].edge;
  if (!(mate=p->edge_pair[n].mate))
    {
      p->edge_pair[n].mob=ident_mob();
      p->edge_pair[n].mob_err=0.0;
      return 0;
    } /* no edge-pairing indicated */

  indx=(nghb_tri(p,edge->prev->face,edge->face)+2) % 3;

  /* find 'begin' center a of seg */

  if (edge->next->face==edge->prev->face 
      && indx!=p->edge_pair[n].edge_indx)
    /* blue face, want second edge (center kept by prev face). */
    {
      a=edge->prev->center;
    }
  else a=edge->center;

  /* find 'end' center b for seg; first find cross face downstream of 
     mate and index to approp vert. */
  
  next_red_edge(p,mate,(p->edge_pair[n].mate_indx+2) % 3,
		&fore_face,&fore_indx,1);
  vert=p->faces[fore_face->face].vert[fore_indx];
  cross=fore_face->cross[fore_indx]; 
  cross_indx=find_index(p,cross->face,vert);
  if (cross_indx==cross->v_flag) b=cross->center;
  else /* cross must be blue; e.g., cross must equal edge. */
    b=cross->prev->center;

  /* find 'begin' center B of paired seg */

  indx=(nghb_tri(p,mate->prev->face,mate->face)+2) % 3;

  if (mate->next->face==mate->prev->face 
      && indx!=p->edge_pair[n].mate_indx)
    /* blue face, want second edge (center kept by prev face). */
    {
      B=mate->prev->center;
    }
  else B=mate->center;

  /* find 'end' center A for paired seg; first find cross face downstream of 
     edge and index to approp vert. */
  
  next_red_edge(p,edge,(p->edge_pair[n].edge_indx+2) % 3,
		&fore_face,&fore_indx,1);
  vert=p->faces[fore_face->face].vert[fore_indx];
  cross=fore_face->cross[fore_indx]; 
  cross_indx=find_index(p,cross->face,vert);
  if (cross_indx==cross->v_flag) A=cross->center;
  else /* cross must be blue; e.g., cross must equal edge. */
    A=cross->prev->center;

  /* now, have everything for mobius transformation. (Assume mobius
     for mate is set separately (should be inverse to this mobius)). */

  if (p->hes<0) /* hyp */
    p->edge_pair[n].mob=
      auto_abAB(a,b,A,B,&(p->edge_pair[n].mob_err),&err_flag);
  else if (p->hes==0) /* eucl */
    p->edge_pair[n].mob=affine_mob(a,b,A,B,&err_flag);
  else p->edge_pair[n].mob=ident_mob(); /* sph not implemented */
  if (err_flag) return 0; /* errors in creating the mobius maps should yield
			     the identity mobius and set err_flag. */ 
  return 1;
} /* pair_mobius */
