(in-package :contextl)

(defun make-enclosing-package (name)
  (make-package name :use '()))

(defgeneric enclose-symbol (symbol package)
  (:method ((symbol symbol)
            (package package))
   (assert (symbol-package symbol) (symbol)
     "Symbol ~S must not be uninterned." symbol)
   (intern (format nil "~A::~A"
                   (package-name (symbol-package symbol))
                   (symbol-name symbol))
           package)))

(defvar *layer-class-definers*
  (make-enclosing-package "LAYER-CLASS-DEFINERS"))

(defun defining-layer (name)
  (if (eq name 't) 't
    (enclose-symbol name *layer-class-definers*)))

(defvar *layered-function-definers*
  (make-enclosing-package "LAYERED-FUNCTION-DEFINERS"))

(defun get-layered-function-definer-name (name)
  (cond ((plain-function-name-p name)
         (enclose-symbol name *layered-function-definers*))
        ((setf-function-name-p name)
         `(setf ,(enclose-symbol (cadr name) *layered-function-definers*)))
        (t (error "Illegal function name: ~S." name))))

(declaim (inline plain-function-name-p))

(defun plain-function-name-p (name)
  (symbolp name))

(defun setf-function-name-p (name)
  (and (consp name)
       (eq (car name) 'setf)
       (symbolp (cadr name))
       (null (cddr name))))
