      SUBROUTINE STRPTP(N,ICOUNT,IDEG,R ,X)
C
C COMPUTES INITIAL POINTS FOR PATHS.
C
C ON INPUT:
C
C N  IS THE NUMBER OF (COMPLEX) VARIABLES.
C
C ICOUNT  IS A COUNTER USED TO INCREMENT EACH
C   VARIABLE AROUND THE UNIT CIRCLE SO THAT EVERY
C   COMBINATION OF START VALUES IS CHOSEN.  ICOUNT  IS
C   INITIALIZED IN  POLYP.
C
C IDEG(J)  IS THE DEGREE OF THE J-TH EQUATION.
C
C R(I,J)  IS A (COMPLEX) ARRAY GENERATED BY SUBROUTINE  INITP.
C   R(1,J), AND R(2,J) ARE THE REAL AND IMAGINARY PARTS, RESPECTIVELY.
C
C ON OUTPUT:
C
C X(I,J)  IS INITIALIZED TO THE START VALUES FOR THE CURRENT PATH,
C   WITH X(1,J) AND X(2,J) THE REAL AND IMAGINARY PARTS OF THE
C   J-TH VARIABLE, RESPECTIVELY.
C
C SUBROUTINES:  ATAN, COS, MULP, SIN.
C
C DECLARATION OF INPUT AND OUTPUT:
      INTEGER N,ICOUNT,IDEG
      DOUBLE PRECISION R ,X
      DIMENSION ICOUNT(N),IDEG(N)
      DIMENSION R(2,N),X(2,N)
C
C DECLARATION OF VARIABLES:
      INTEGER J
      DOUBLE PRECISION TWOPI,ANGLE,XXXX
      DIMENSION XXXX(2)
C
      DO 10 J=1,N
         IF(ICOUNT(J) .GE. IDEG(J) ) THEN
             ICOUNT(J)=1
           ELSE
             ICOUNT(J)=ICOUNT(J)+1
             GOTO 20
         END IF
  10  CONTINUE
  20  CONTINUE
      TWOPI = 8.0*ATAN(1.0)
      DO 30 J=1,N
          ANGLE = ( TWOPI/IDEG(J) )*ICOUNT(J)
          XXXX(1) = COS(ANGLE)
          XXXX(2) = SIN(ANGLE)
          CALL MULP(XXXX,R(1,J),X(1,J))
  30  CONTINUE
      RETURN
      END
