C************************************************************
C STANDARD FIRST VERSION OF THE LA05 ROUTINES:
C DOUBLE PRECISION AND FULL-WORD INTEGER.
C*************************************************************
      SUBROUTINE LA05AD(A,IND,NZ,IA,N,IP,IW,W,G,U)
C WARNING:  DON'T TRY TO USE HALF-WORDS FOR THE IP ARRAY.
      INTEGER IP(N,2)
      CHARACTER*1 RC(2,3)
C COULD USE HALF-WORDS:
      INTEGER IND(IA,2),IW(N,8)
      DOUBLE PRECISION A(IA),AMAX,AU,AM,G,U,SMALL,W(N)
      COMMON/LA05DD/SMALL,LP,LENL,LENU,NCP,LROW,LCOL
C IP(I,1),IP(I,2) POINT TO THE START OF ROW/COL I.
C IW(I,1),IW(I,2) HOLD THE NUMBER OF NON-ZEROS IN ROW/COL I.
C DURING THE MAIN BODY OF THIS SUBROUTINE THE VECTORS IW(.,3),IW(.,5),
C     IW(.,7) ARE USED TO HOLD DOUBLY LINKED LISTS OF ROWS THAT HAVE
C     NOT BEEN PIVOTAL AND HAVE EQUAL NUMBERS OF NON-ZEROS.
C IW(.,4),IW(.,6),IW(.,8) HOLD SIMILAR LISTS FOR THE COLUMNS.
C IW(I,3),IW(I,4) HOLD FIRST ROW/COLUMN TO HAVE I NON-ZEROS
C     OR ZERO IF THERE ARE NONE.
C IW(I,5), IW(I,6) HOLD ROW/COL NUMBER OF ROW/COL PRIOR TO ROW/COL I
C     IN ITS LIST, OR ZERO IF NONE.
C IW(I,7), IW(I,8) HOLD ROW/COL NUMBER OF ROW/COL AFTER ROW/COL I
C     IN ITS LIST, OR ZERO IF NONE.
C FOR ROWS/COLS THAT HAVE BEEN PIVOTAL IW(I,5),IW(I,6) HOLD NEGATION OF
C     POSITION OF ROW/COL I IN THE PIVOTAL ORDERING.
      DATA RC(1,1),RC(1,2),RC(1,3),RC(2,1),RC(2,2),RC(2,3)
     1 / 'R','O','W','C','O','L'/
      DATA EPS/2.3E-16/
C EPS IS THE RELATIVE ACCURACY OF FLOATING-POINT COMPUTATION
      IF(U.GT.1.)U=1.
      IF(U.LT.EPS)U=EPS
      IF(N.LT.1)GO TO 520
      G=0.
      DO 5 I=1,N
      W(I)=0.
      DO 5 J=1,5
5     IW(I,J)=0
C
C FLUSH OUT SMALL ENTRIES, COUNT ELEMENTS IN ROWS AND COLUMNS
      L=1
      LENU=NZ
      DO 20 IDUMMY=1,NZ
      IF(L.GT.LENU)GO TO 25
      DO 10 K=L,LENU
      IF(DABS(A(K)).LE.SMALL)GO TO 15
      I=IND(K,1)
      J=IND(K,2)
      G=DMAX1(DABS(A(K)),G)
      IF(I.LT.1 .OR. I.GT.N)GO TO 540
      IF(J.LT.1 .OR. J.GT.N)GO TO 540
      IW(I,1)=IW(I,1)+1
10    IW(J,2)=IW(J,2)+1
      GO TO 25
15    L=K
      A(L)=A(LENU)
      IND(L,1)=IND(LENU,1)
      IND(L,2)=IND(LENU,2)
20    LENU=LENU-1
C
25    LENL=0
      LROW=LENU
      LCOL=LROW
C MCP IS THE MAXIMUM NUMBER OF COMPRESSES PERMITTED BEFORE AN
C     ERROR RETURN RESULTS.
      MCP=MAX0(N/10,20)
      NCP=0
C CHECK FOR NULL ROW OR COLUMN AND INITIALIZE IP(I,2) TO POINT
C     JUST BEYOND WHERE THE LAST COMPONENT OF COLUMN I OF A WILL
C     BE STORED.
      K=1
      DO 28 IR=1,N
      K=K+IW(IR,2)
      IP(IR,2)=K
      DO 28 L=1,2
      IF(IW(IR,L).LE.0)GO TO 580
 28   CONTINUE
C REORDER BY ROWS
      CALL MC20AD(N,LENU,A,IND(1,2),IP,IND(1,1),0)
C CHECK FOR DOUBLE ENTRIES WHILE USING THE NEWLY CONSTRUCTED
C     ROW FILE TO CONSTRUCT THE COLUMN FILE. NOTE THAT BY PUTTING
C    THE ENTRIES IN BACKWARDS AND DECREASING IP(J,2) EACH TIME IT
C     IS USED WE AUTOMATICALLY LEAVE IT POINTING TO THE FIRST ELEMENT.
      KL=LENU
      DO 40 II=1,N
      IR=N+1-II
      KP=IP(IR,1)
      DO 30 K=KP,KL
      J=IND(K,2)
      IF(IW(J,5).EQ.IR)GO TO 500
      IW(J,5)=IR
      KR=IP(J,2)-1
      IP(J,2)=KR
30    IND(KR,1)=IR
40    KL=KP-1
C
C SET UP LINKED LISTS OF ROWS AND COLS WITH EQUAL NUMBERS OF NON-ZEROS.
      DO 100 L=1,2
      DO 100 I=1,N
      NZ=IW(I,L)
      IN=IW(NZ,L+2)
      IW(NZ,L+2)=I
      IW(I,L+6)=IN
      IW(I,L+4)=0
100   IF(IN.NE.0)IW(IN,L+4)=I
C
C
C START OF MAIN ELIMINATION LOOP.
      DO 480 IPV=1,N
C FIND PIVOT. JCOST IS MARKOWITZ COST OF CHEAPEST PIVOT FOUND SO FAR,
C     WHICH IS IN ROW IPP AND COLUMN JP.
      JCOST=N*N
C LOOP ON LENGTH OF COLUMN TO BE SEARCHED
      DO 155 NZ=1,N
      IF(JCOST.LE.(NZ-1)**2)GO TO 183
      J=IW(NZ,4)
C SEARCH COLUMNS WITH NZ NON-ZEROS.
      DO 131 IDUMMY=1,N
      IF(J.LE.0)GO TO 133
      KP=IP(J,2)
      KL=KP+IW(J,2)-1
      DO 130 K=KP,KL
      I=IND(K,1)
      KCOST=(NZ-1)*(IW(I,1)-1)
      IF(KCOST.GE.JCOST)GO TO 130
      IF(NZ.EQ.1)GO TO 125
C FIND LARGEST ELEMENT IN ROW OF POTENTIAL PIVOT.
      AMAX=0.
      K1=IP(I,1)
      K2=IW(I,1)+K1-1
      DO 120 KK=K1,K2
      AMAX=DMAX1(AMAX,DABS(A(KK)))
120   IF(IND(KK,2).EQ.J)KJ=KK
C PERFORM STABILITY TEST.
       IF(DABS(A(KJ)).LT.AMAX*U)GO TO 130
125   JCOST=KCOST
      IPP=I
      JP=J
      IF(JCOST.LE.(NZ-1)**2)GO TO 183
130   CONTINUE
131   J=IW(J,8)
C SEARCH ROWS WITH NZ NON-ZEROS.
133   I=IW(NZ,3)
      DO 151 IDUMMY=1,N
      IF(I.LE.0)GO TO 155
      AMAX=0.
      KP=IP(I,1)
      KL=KP+IW(I,1)-1
C FIND LARGEST ELEMENT IN THE ROW
      DO 140 K=KP,KL
 140  AMAX=DMAX1(DABS(A(K)),AMAX)
      AU=AMAX*U
      DO 150 K=KP,KL
C PERFORM STABILITY TEST.
      IF(DABS(A(K)).LT.AU)GO TO 150
      J=IND(K,2)
      KCOST=(NZ-1)*(IW(J,2)-1)
      IF(KCOST.GE.JCOST)GO TO 150
      JCOST=KCOST
      IPP=I
      JP=J
      IF(JCOST.LE.(NZ-1)**2)GO TO 183
150   CONTINUE
151   I=IW(I,7)
155   CONTINUE
C
C PIVOT FOUND.
C REMOVE ROWS AND COLUMNS INVOLVED IN ELIMINATION FROM ORDERING VECTORS.
183   KP=IP(JP,2)
      KL=IW(JP,2)+KP-1
      DO 195 L=1,2
      DO 190 K=KP,KL
      I=IND(K,L)
      IL=IW(I,L+4)
      IN=IW(I,L+6)
      IF(IL.EQ.0)GO TO 185
      IW(IL,L+6)=IN
      GO TO 190
185   NZ=IW(I,L)
      IW(NZ,L+2)=IN
190   IF(IN.GT.0)IW(IN,L+4)=IL
      KP=IP(IPP,1)
195   KL=KP+IW(IPP,1)-1
C STORE PIVOT
      IW(IPP,5)=-IPV
      IW(JP,6 )=-IPV
C ELIMINATE PIVOTAL ROW FROM COLUMN FILE AND FIND PIVOT IN ROW FILE.
      DO 219 K=KP,KL
      J=IND(K,2)
      KPC=IP(J,2)
      IW(J,2)=IW(J,2)-1
      KLC=KPC+IW(J,2)
      DO 215 KC=KPC,KLC
      IF(IPP.EQ.IND(KC,1))GO TO 216
215   CONTINUE
216   IND(KC,1)=IND(KLC,1)
      IND(KLC,1)=0
219   IF(J.EQ.JP)KR=K
C BRING PIVOT TO FRONT OF PIVOTAL ROW.
      AU=A(KR)
      A(KR)=A(KP)
      A(KP)=AU
      IND(KR,2)=IND(KP,2)
      IND(KP,2)=JP
C
C PERFORM ELIMINATION ITSELF, LOOPING ON NON-ZEROS IN PIVOT COLUMN.
      NZC=IW(JP,2)
      IF(NZC.EQ.0)GO TO 468
      DO 467 NC=1,NZC
      KC=IP(JP,2)+NC-1
      IR=IND(KC,1)
C SEARCH NON-PIVOT ROW FOR ELEMENT TO BE ELIMINATED.
      KR=IP(IR,1)
      KRL=KR+IW(IR,1)-1
      DO 290 KNP=KR,KRL
      IF(JP.EQ.IND(KNP,2))GO TO 300
290   CONTINUE
C BRING ELEMENT TO BE ELIMINATED TO FRONT OF ITS ROW.
300   AM=A(KNP)
      A(KNP)=A(KR)
      A(KR)=AM
      IND(KNP,2)=IND(KR,2)
      IND(KR,2)=JP
      AM=-A(KR)/A(KP)
C COMPRESS ROW FILE UNLESS IT IS CERTAIN THAT THERE IS ROOM FOR NEW ROW.
      IF(LROW+IW(IR,1)+IW(IPP,1)+LENL.LE.IA)GO TO 340
      IF(NCP.GE.MCP .OR. LENU+IW(IR,1)+IW(IPP,1)+LENL.GT.IA)GO TO 600
      CALL LA05ED(A,IND(1,2),IP,N,IW,IA  ,.TRUE.)
      KP=IP(IPP,1)
      KR=IP(IR,1)
340   KRL=KR+IW(IR,1)-1
      KQ=KP+1
      KPL=KP+IW(IPP,1)-1
C PLACE PIVOT ROW (EXCLUDING PIVOT ITSELF) IN W.
      IF(KQ.GT.KPL)GO TO 350
      DO 345 K=KQ,KPL
      J=IND(K,2)
345   W(J)=A(K)
350   IP(IR,1)=LROW+1
C
C TRANSFER MODIFIED ELEMENTS.
      IND(KR,2)=0
      KR=KR+1
      IF(KR.GT.KRL)GO TO 380
      DO 370 KS=KR,KRL
      J =IND(KS,2)
      AU=A(KS)+AM*W(J)
      IND(KS,2)=0
C IF ELEMENT IS VERY SMALL REMOVE IT FROM U.
      IF(DABS(AU).LE.SMALL)GO TO 365
      G=DMAX1(G,DABS(AU))
      LROW=LROW+1
      A(LROW)=AU
      IND(LROW,2)=J
      GO TO 370
365   LENU=LENU-1
C REMOVE ELEMENT FROM COL FILE.
      K=IP(J,2)
      KL=K+IW(J,2)-1
      IW(J,2)=KL-K
      DO 366 KK=K,KL
      IF(IND(KK,1).EQ.IR)GO TO 367
366   CONTINUE
367   IND(KK,1)=IND(KL,1)
      IND(KL,1)=0
370   W(J)=0.
C
C SCAN PIVOT ROW FOR FILLS.
380   IF(KQ.GT.KPL)GO TO 435
      DO 430 KS=KQ,KPL
      J=IND(KS,2)
      AU=AM*W(J)
      IF(DABS(AU).LE.SMALL)GO TO 430
      LROW=LROW+1
      A(LROW)=AU
      IND(LROW,2)=J
      LENU=LENU+1
C
C CREATE FILL IN COLUMN FILE.
      NZ=IW(J,2)
      K=IP(J,2)
      KL=K+NZ-1
C IF POSSIBLE PLACE NEW ELEMENT AT END OF PRESENT ENTRY.
      IF(KL.NE.LCOL)GO TO 390
      IF(LCOL+LENL.GE.IA)GO TO 400
      LCOL=LCOL+1
      GO TO 395
390   IF(IND(KL+1,1).NE.0)GO TO 400
395   IND(KL+1,1)=IR
      GO TO 425
C NEW ENTRY HAS TO BE CREATED.
400   IF(LCOL+LENL+NZ+1.LT.IA)GO TO 410
C COMPRESS COLUMN FILE IF THERE IS NOT ROOM FOR NEW ENTRY.
      IF(NCP.GE.MCP .OR. LENU+LENL+NZ+1.GE.IA)GO TO 600
      CALL LA05ED(A,IND,IP(1,2),N,IW(1,2),IA  ,.FALSE.)
      K=IP(J,2)
      KL=K+NZ-1
C TRANSFER OLD ENTRY INTO NEW.
410   IP(J,2)=LCOL+1
      DO 420 KK=K,KL
      LCOL=LCOL+1
      IND(LCOL,1)=IND(KK,1)
420   IND(KK,1)=0
C ADD NEW ELEMENT.
      LCOL=LCOL+1
      IND(LCOL,1)=IR
 425  G=DMAX1(G,DABS(AU))
      IW(J,2)=NZ+1
430   W(J)=0.
435   IW(IR,1)=LROW+1-IP(IR,1)
C
C STORE MULTIPLIER
      IF(LENL+LCOL+1.LE.IA)GO TO 450
C COMPRESS COL FILE IF NECESSARY.
      IF(NCP.GE.MCP)GO TO 600
      CALL LA05ED(A,IND,IP(1,2),N,IW(1,2),IA  ,.FALSE.)
450   K=IA-LENL
      LENL=LENL+1
      A(K)=AM
      IND(K,1)=IPP
      IND(K,2)=IR
      LENU=LENU-1
467   CONTINUE
C
C INSERT ROWS AND COLUMNS INVOLVED IN ELIMINATION IN LINKED LISTS
C     OF EQUAL NUMBERS OF NON-ZEROS.
468   K1=IP(JP,2)
      K2=IW(JP,2)+K1-1
      IW(JP,2)=0
      DO 480 L=1,2
      IF(K2.LT.K1)GO TO 475
      DO 470 K=K1,K2
      IR=IND(K,L)
      IF(L.EQ.1)IND(K,L)=0
      NZ=IW(IR,L)
      IF(NZ.LE.0)GO TO 630
      IN=IW(NZ,L+2)
      IW(IR,L+6)=IN
      IW(IR,L+4)=0
      IW(NZ,L+2)=IR
470   IF(IN.NE.0)IW(IN,L+4)=IR
475   K1=IP(IPP,1)+1
480   K2=IW(IPP,1)+K1-2
C
C RESET COLUMN FILE TO REFER TO U AND STORE ROW/COL NUMBERS IN
C     PIVOTAL ORDER IN IW(.,3),IW(.,4)
      DO 482 I=1,N
      J=-IW(I,5)
      IW(J,3)=I
      J=-IW(I,6)
      IW(J,4)=I
482   IW(I,2)=0
      DO 485 I=1,N
      KP=IP(I,1)
      KL=IW(I,1)+KP-1
      DO 485 K=KP,KL
      J=IND(K,2)
485   IW(J,2)=IW(J,2)+1
      K=1
      DO 487 I=1,N
      K=K+IW(I,2)
487   IP(I,2)=K
      LCOL=K-1
      DO 490 II=1,N
      I=IW(II,3)
      KP=IP(I,1)
      KL=IW(I,1)+KP-1
      DO 490 K=KP,KL
      J=IND(K,2)
      KN=IP(J,2)-1
      IP(J,2)=KN
490   IND(KN,1)=I
      GO TO 720
C
C     THE FOLLOWING INSTRUCTIONS IMPLEMENT THE FAILURE EXITS.
500   IF(LP.GT.0)WRITE(LP,510)IR,J
510   FORMAT(//34X,35HTHERE IS MORE THAN ONE ENTRY IN ROW,I5,
     1 11H AND COLUMN,I5)
      G=-4.
      GO TO 700
520   IF(LP.GT.0)WRITE(LP,530)
530   FORMAT(//34X,17HN IS NOT POSITIVE)
      G=-1.
      GO TO 700
540   IF(LP.GT.0)WRITE(LP,550)K,I,J
550   FORMAT(//34X,7HELEMENT,I7,10H IS IN ROW,I5,11H AND COLUMN,I5)
      G=-3.
      GO TO 700
580   IF(LP.GT.0)WRITE(LP,590)(RC(L,I),I=1,3),IR
590   FORMAT(//34X,3A1,I5,16H HAS NO ELEMENTS)
      G=-2.
      GO TO 700
600   IF(LP.GT.0)WRITE(LP,610)
610   FORMAT(//34X,15HIA IS TOO SMALL)
      G=-7.
      GO TO 700
630   IPV=IPV+1
      IW(IPV,1)=IR
      DO 640 I=1,N
      II=-IW(I,L+4)
640   IF(II.GT.0)IW(II,1)=I
      IF(LP.GT.0)WRITE(LP,650)(RC(L,I),I=1,3),(IW(I,1),I=1,IPV)
 650  FORMAT(48H ERROR RETURN FROM LA05AD BECAUSE THE FOLLOWING ,3A1
     1,15HS ARE DEPENDENT/(20I5))
      G=-5.
      GO TO 720
700   IF(LP.GT.0)WRITE(LP,710)
 710  FORMAT(33H+ERROR RETURN FROM LA05AD BECAUSE )
720   RETURN
      END
      SUBROUTINE LA05BD(A,IND,IA,N,IP,IW,W,G,B,TRANS)
      DOUBLE PRECISION A(IA),B(N),AM,W(N),G,SMALL
      LOGICAL TRANS
C COULD USE HALF-WORDS:
      INTEGER IND(IA,2),IW(N,4)
C WARNING:  DON'T TRY TO USE HALF-WORDS FOR THE IP ARRAY.
      INTEGER IP(N,2)
      COMMON/LA05DD/SMALL,LP,LENL,LENU,NCP,LROW,LCOL
C IP(I,1),IP(I,2) POINT TO START OF ROW/COLUMN I OF U.
C IW(I,1),IW(I,2) ARE LENGTHS OF ROW/COL I OF U.
C IW(.,3),IW(.,4) HOLD ROW/COL NUMBERS IN PIVOTAL ORDER.
      IF(G.LT.0.)GO TO 400
      KLL=IA-LENL+1
      IF(TRANS)GO TO 300
C
C     MULTIPLY VECTOR BY INVERSE OF L
      IF(LENL.LE.0)GO TO 112
      L1=IA+1
      DO 110 KK=1,LENL
      K=L1-KK
      I=IND(K,1)
      IF(DABS(B(I)) .LT. SMALL)GO TO 110
      J=IND(K,2)
      B(J)=B(J)+A(K)*B(I)
110   CONTINUE
112   DO 113 I=1,N
      W(I)=B(I)
113   B(I)=0.
C
C     MULTIPLY VECTOR BY INVERSE OF U
      N1=N+1
      DO 140 II=1,N
      I=N1-II
      I=IW(I,3)
      AM=W(I)
      KP= IP(I,1)
      IF(KP.GT.0)GO TO 130
      KP=-KP
      IP(I,1)=KP
      NZ=IW(I,1)
      KL=KP-1+NZ
      K2=KP+1
      DO 120 K=K2,KL
      J=IND(K,2)
120   AM=AM-A(K)*B(J)
130   IF(DABS(AM) .LT. SMALL)GO TO 140
      J=IND(KP,2)
       B(J)=AM/A(KP)
      KPC=IP(J,2)
      KL=IW(J,2)+KPC-1
      IF(KL.EQ.KPC)GO TO 140
      K2=KPC+1
      DO 135 K=K2,KL
      I=IND(K,1)
135   IP(I,1)=-IABS(IP(I,1))
140   CONTINUE
      GO TO 500
C
C     MULTIPLY VECTOR BY INVERSE OF TRANSPOSE OF U
300   DO 303 I=1,N
      W(I)=B(I)
303   B(I)=0.
      DO 315 II=1,N
      I=IW(II,4)
      AM=W(I)
      IF(DABS(AM) .LT. SMALL)GO TO 315
      J=IW(II,3)
      KP=IP(J,1)
      AM=AM/A(KP)
      B(J)=AM
      KL=IW(J,1)+KP-1
      IF(KP.EQ.KL)GO TO 315
      K2=KP+1
      DO 310 K=K2,KL
      I=IND(K,2)
310   W(I)=W(I)-AM*A(K)
315   CONTINUE
C
C     MULTIPLY VECTOR BY INVERSE OF TRANSPOSE OF L
      IF(KLL.GT.IA)GO TO 500
      DO 330 K=KLL,IA
      J=IND(K,2)
      IF(DABS(B(J)) .LT. SMALL)GO TO 330
      I=IND(K,1)
      B(I)=B(I)+A(K)*B(J)
330   CONTINUE
      GO TO 500
C
400   IF(LP.GT.0)WRITE(LP,410)
 410  FORMAT(// 47H ERROR RETURN FROM LA05BD BECAUSE EARLIER ENTRY
     1,18H GAVE ERROR RETURN)
500   CONTINUE
      DO 510 II=1,N
      IF(DABS(B(II)).LT.SMALL)B(II)=0.0
510   CONTINUE
      RETURN
      END
      SUBROUTINE LA05CD(A,IND,IA,N,IP,IW,W,G,U,MM)
      DOUBLE PRECISION A(IA),G,U,AM,W(N),SMALL,AU
C COULD USE HALF-WORDS:
      INTEGER IND(IA,2),IW(N,4)
C WARNING:  DON'T TRY TO USE HALF-WORDS FOR THE IP ARRAY.
      INTEGER IP(N,2)
      COMMON/LA05DD/SMALL,LP,LENL,LENU,NCP,LROW,LCOL
      IF(G.LT.0.)GO TO 640
      JM=MM
C MCP LIMITS THE VALUE OF NCP PERMITTED BEFORE AN ERROR RETURN RESULTS.
      MCP=NCP+20
C REMOVE OLD COLUMN
      LENU=LENU-IW(JM,2)
      KP=IP(JM,2)
      IM=IND(KP,1)
      KL=KP+IW(JM,2)-1
      IW(JM,2)=0
      DO 40 K=KP,KL
       I=IND(K,1)
      IND(K,1)=0
      KR=IP(I,1)
      NZ=IW(I,1)-1
      IW(I,1)=NZ
      KRL=KR+NZ
      DO 10 KM=KR,KRL
      IF(IND(KM,2).EQ.JM)GO TO 20
10    CONTINUE
20    A(KM)=A(KRL)
      IND(KM,2)=IND(KRL,2)
40    IND(KRL,2)=0
C
C INSERT NEW COLUMN
      DO 110 II=1,N
      I=IW(II,3)
      IF(I.EQ.IM)M=II
      IF(DABS(W(I)).LE.SMALL)GO TO 110
      LENU=LENU+1
      LAST=II
      IF(LCOL+LENL.LT.IA)GO TO 50
C COMPRESS COLUMN FILE IF NECESSARY.
      IF(NCP.GE.MCP .OR. LENL+LENU.GE.IA)GO TO 600
      CALL LA05ED(A,IND,IP(1,2),N,IW(1,2),IA  ,.FALSE.)
50    LCOL=LCOL+1
      NZ=IW(JM,2)
      IF(NZ.EQ.0)IP(JM,2)=LCOL
      IW(JM,2)=NZ+1
      IND(LCOL,1)=I
      NZ=IW(I,1)
      KPL=IP(I,1)+NZ
      IF(KPL.GT.LROW)GO TO 55
      IF(IND(KPL,2).EQ.0)GO TO 90
C NEW ENTRY HAS TO BE CREATED.
55    IF(LENL+LROW+NZ.LT.IA)GO TO 60
      IF(NCP.GE.MCP .OR. LENL+LENU+NZ.GE.IA)GO TO 600
C COMPRESS ROW FILE IF NECESSARY.
      CALL LA05ED(A,IND(1,2),IP,N,IW,IA  ,.TRUE.)
60    KP=IP(I,1)
      IP(I,1)=LROW+1
      IF(NZ.EQ.0)GO TO 80
      KPL=KP+NZ-1
      DO 70 K=KP,KPL
      LROW=LROW+1
      A(LROW)=A(K)
      IND(LROW,2)=IND(K,2)
70    IND(K,2)=0
80    LROW=LROW+1
      KPL=LROW
C PLACE NEW ELEMENT AT END OF ROW.
90    IW(I,1)=NZ+1
      A(KPL )=W(I)
      IND(KPL ,2)=JM
110   W(I)=0.
      IF(IW(IM,1).EQ.0 .OR. IW(JM,2).EQ.0 .OR. M.GT.LAST)GO TO 580
C
C FIND COLUMN SINGLETONS, OTHER THAN THE SPIKE. NON-SINGLETONS ARE
C     MARKED WITH W(J)=1. ONLY IW(.,3) IS REVISED AND IW(.,4) IS USED
C     FOR WORKSPACE.
      INS=M
      M1=M
      W(JM)=1.
      DO 150 II=M,LAST
      I=IW(II,3)
      J=IW(II,4)
      IF(DABS(W(J)) .LT. SMALL)GO TO 140
      KP=IP(I,1)
      KL=KP+IW(I,1)-1
      DO 130 K=KP,KL
      J=IND(K,2)
130   W(J)=1.
      IW(INS,4)=I
      INS=INS+1
      GO TO 150
C PLACE SINGLETONS IN NEW POSITION.
140   IW(M1,3)=I
      M1=M1+1
150   CONTINUE
C PLACE NON-SINGLETONS IN NEW POSITION.
      IJ=M+1
      INDEX=LAST-1
      IF(INDEX.LT.M1)GO TO 161
      DO 160 II=M1,INDEX
      IW(II,3)=IW(IJ,4)
160   IJ=IJ+1
C PLACE SPIKE AT END.
  161 IW(LAST,3)=IM
C
C FIND ROW SINGLETONS, APART FROM SPIKE ROW. NON-SINGLETONS ARE MARKED
C     WITH W(I)=2. AGAIN ONLY IW(.,3) IS REVISED AND IW(.,4) IS USED
C     FOR WORKSPACE.
      LAST1=LAST
      JNS=LAST
      W(IM)=2.
      J=JM
      DO 190 IJ=M1,LAST
      II=LAST  +M1-IJ
      I=IW(II,3)
      IF(W(I).NE.2.)GO TO 180
      K=IP(I,1)
      IF(II.NE.LAST)J=IND(K,2)
      KP=IP(J,2)
      KL=KP+IW(J,2)-1
      IW(JNS,4)=I
      JNS=JNS-1
      DO 170 K=KP,KL
      I=IND(K,1)
170   W(I)=2.
      GO TO 190
180   IW(LAST1,3)=I
      LAST1=LAST1-1
190   CONTINUE
      DO 195 II=M1,LAST1
      JNS=JNS+1
      I=IW(JNS,4)
      W(I)=3.
195   IW(II,3)=I
C
C DEAL WITH SINGLETON SPIKE COLUMN. NOTE THAT BUMP ROWS ARE MARKED BY
C    W(I)=3.
      DO 220 II=M1,LAST1
      KP=IP(JM,2)
      KL=KP+IW(JM,2)-1
      IS=0
      DO 210 K=KP,KL
      L=IND(K,1)
      IF(W(L).NE.3.)GO TO 210
      IF(IS.NE.0)GO TO 230
      I=L
      KNP=K
      IS=1
210   CONTINUE
      IF(IS.EQ.0)GO TO 580
C MAKE A(I,JM) A PIVOT.
      IND(KNP,1)=IND(KP,1)
      IND(KP,1)=I
      KP=IP(I,1)
      DO 215 K=KP,IA
      IF(IND(K,2).EQ.JM)GO TO 216
215   CONTINUE
216   AM=A(KP)
      A(KP)=A(K)
      A(K)=AM
      IND(K,2)=IND(KP,2)
      IND(KP,2)=JM
      JM=IND(K ,2)
      IW(II,4)=I
220   W(I)=2.
      II=LAST1
      GO TO 250
230   IN=M1
      DO 240 IJ=II,LAST1
      IW(IJ,4)=IW(IN,3)
240   IN=IN+1
250   LAST2=LAST1-1
      IF(M1.EQ.LAST1)GO TO 485
      DO 260  I=M1,LAST2
260   IW(I ,3)=IW( I,4)
      M1=II
      IF(M1.EQ.LAST1)GO TO 485
C
C CLEAR W
      DO 270 I=1,N
270   W(I)=0.
C
C PERFORM ELIMINATION
      IR=IW(LAST1,3)
      DO 480 II=M1,LAST1
      IPP=IW(II,3)
      KP=IP(IPP,1)
      KR=IP(IR,1)
      JP=IND(KP,2)
      IF(II.EQ.LAST1)JP=JM
C SEARCH NON-PIVOT ROW FOR ELEMENT TO BE ELIMINATED.
C  AND BRING IT TO FRONT OF ITS ROW
      KRL=KR+IW(IR,1)-1
      DO 290 KNP=KR,KRL
      IF(JP.EQ.IND(KNP,2))GO TO 300
290   CONTINUE
      IF(II-LAST1)480,580,480
C BRING ELEMENT TO BE ELIMINATED TO FRONT OF ITS ROW.
300   AM=A(KNP)
      A(KNP)=A(KR)
      A(KR)=AM
      IND(KNP,2)=IND(KR,2)
      IND(KR,2)=JP
      IF(II.EQ.LAST1)GO TO 310
      IF(DABS(A(KP)).LT.U*DABS(AM))GO TO 310
      IF(DABS(AM).LT.U*DABS(A(KP)))GO TO 330
      IF(IW(IPP,1).LE.IW(IR,1))GO TO 330
C PERFORM INTERCHANGE
310   IW(LAST1,3)=IPP
      IW(II,3)=IR
      IR=IPP
      IPP=IW(II,3)
      K=KR
      KR=KP
      KP=K
      KJ=IP(JP,2)
      DO 320 K=KJ,IA
      IF(IND(K,1).EQ.IPP)GO TO 325
320   CONTINUE
325   IND(K,1)=IND(KJ,1)
      IND(KJ,1)=IPP
330   IF(DABS(A(KP)) .LT. SMALL)GO TO 580
      IF(II.EQ.LAST1)GO TO 480
      AM=-A(KR)/A(KP)
C COMPRESS ROW FILE UNLESS IT IS CERTAIN THAT THERE IS ROOM FOR NEW ROW.
      IF(LROW+IW(IR,1)+IW(IPP,1)+LENL.LE.IA)GO TO 340
      IF(NCP.GE.MCP .OR. LENU+IW(IR,1)+IW(IPP,1)+LENL.GT.IA)GO TO 600
      CALL LA05ED(A,IND(1,2),IP,N,IW,IA  ,.TRUE.)
      KP=IP(IPP,1)
      KR=IP(IR,1)
340   KRL=KR+IW(IR,1)-1
      KQ=KP+1
      KPL=KP+IW(IPP,1)-1
C PLACE PIVOT ROW (EXCLUDING PIVOT ITSELF) IN W.
      IF(KQ.GT.KPL)GO TO 350
      DO 345 K=KQ,KPL
      J=IND(K,2)
345   W(J)=A(K)
350   IP(IR,1)=LROW+1
C
C TRANSFER MODIFIED ELEMENTS.
      IND(KR,2)=0
      KR=KR+1
      IF(KR.GT.KRL)GO TO 380
      DO 370 KS=KR,KRL
      J =IND(KS,2)
      AU=A(KS)+AM*W(J)
      IND(KS,2)=0
C IF ELEMENT IS VERY SMALL REMOVE IT FROM U.
      IF(DABS(AU).LE.SMALL)GO TO 365
      G=DMAX1(G,DABS(AU))
      LROW=LROW+1
      A(LROW)=AU
      IND(LROW,2)=J
      GO TO 370
365   LENU=LENU-1
C REMOVE ELEMENT FROM COL FILE.
      K=IP(J,2)
      KL=K+IW(J,2)-1
      IW(J,2)=KL-K
      DO 366 KK=K,KL
      IF(IND(KK,1).EQ.IR)GO TO 367
366   CONTINUE
367   IND(KK,1)=IND(KL,1)
      IND(KL,1)=0
370   W(J)=0.
C
C SCAN PIVOT ROW FOR FILLS.
380   IF(KQ.GT.KPL)GO TO 435
      DO 430 KS=KQ,KPL
      J=IND(KS,2)
      AU=AM*W(J)
      IF(DABS(AU).LE.SMALL)GO TO 430
      LROW=LROW+1
      A(LROW)=AU
      IND(LROW,2)=J
      LENU=LENU+1
C
C CREATE FILL IN COLUMN FILE.
      NZ=IW(J,2)
      K=IP(J,2)
      KL=K+NZ-1
C IF POSSIBLE PLACE NEW ELEMENT AT END OF PRESENT ENTRY.
      IF(KL.NE.LCOL)GO TO 390
      IF(LCOL+LENL.GE.IA)GO TO 400
      LCOL=LCOL+1
      GO TO 395
390   IF(IND(KL+1,1).NE.0)GO TO 400
395   IND(KL+1,1)=IR
      GO TO 425
C NEW ENTRY HAS TO BE CREATED.
400   IF(LCOL+LENL+NZ+1.LT.IA)GO TO 410
C COMPRESS COLUMN FILE IF THERE IS NOT ROOM FOR NEW ENTRY.
      IF(NCP.GE.MCP .OR. LENU+LENL+NZ+1.GE.IA)GO TO 600
      CALL LA05ED(A,IND,IP(1,2),N,IW(1,2),IA  ,.FALSE.)
      K=IP(J,2)
      KL=K+NZ-1
C TRANSFER OLD ENTRY INTO NEW.
410   IP(J,2)=LCOL+1
      DO 420 KK=K,KL
      LCOL=LCOL+1
      IND(LCOL,1)=IND(KK,1)
420   IND(KK,1)=0
C ADD NEW ELEMENT.
      LCOL=LCOL+1
      IND(LCOL,1)=IR
 425  G=DMAX1(G,DABS(AU))
      IW(J,2)=NZ+1
430   W(J)=0.
435   IW(IR,1)=LROW+1-IP(IR,1)
C
C STORE MULTIPLIER
      IF(LENL+LCOL+1.LE.IA)GO TO 450
C COMPRESS COL FILE IF NECESSARY.
      IF(NCP.GE.MCP)GO TO 600
      CALL LA05ED(A,IND,IP(1,2),N,IW(1,2),IA  ,.FALSE.)
450   K=IA-LENL
      LENL=LENL+1
      A(K)=AM
      IND(K,1)=IPP
      IND(K,2)=IR
C CREATE BLANK IN PIVOTAL COLUMN.
      KP=IP(JP,2)
      NZ=IW(JP,2)-1
      KL=KP+NZ
      DO 460 K=KP,KL
      IF(IND(K,1).EQ.IR)GO TO 465
460   CONTINUE
465   IND(K,1)=IND(KL,1)
      IW(JP,2)=NZ
      IND(KL,1)=0
      LENU=LENU-1
480   CONTINUE
C
C CONSTRUCT COLUMN PERMUTATION AND STORE IT IN IW(.,4)
485   DO 490 II=M,LAST
      I=IW(II,3)
      K=IP(I,1)
      J=IND(K,2)
490   IW(II,4)=J
      GO TO 720
C
C     THE FOLLOWING INSTRUCTIONS IMPLEMENT THE FAILURE EXITS.
580   IF(LP.NE.0)WRITE(LP,590)MM
590   FORMAT(//34X,45HSINGULAR MATRIX CREATED BY REPLACEMENT OF COL,I5)
      G=-6.
      GO TO 700
600   IF(LP.NE.0)WRITE(LP,610)
610   FORMAT(//34X,15HIA IS TOO SMALL)
      G=-7.
      GO TO 700
640   IF(LP.NE.0)WRITE(LP,650)
650   FORMAT(//34X,31HEARLIER ENTRY GAVE ERROR RETURN)
700   IF(LP.NE.0)WRITE(LP,710)
 710  FORMAT(33H+ERROR RETURN FROM LA05CD BECAUSE )
720   RETURN
      END
      SUBROUTINE LA05ED(A,IRN,IP,N,IW,IA,REALS)
      LOGICAL REALS
      DOUBLE PRECISION A(IA),SMALL
C COULD USE HALF-WORDS:
      INTEGER IRN(IA),IW(N)
C WARNING:  DO NOT TRY TO USE HALF-WORDS FOR THE IP ARRAY.
      INTEGER IP(N)
      COMMON/LA05DD/SMALL,LP,LENL,LENU,NCP,LROW,LCOL
      NCP=NCP+1
C     COMPRESS FILE OF POSITIVE INTEGERS. ENTRY J STARTS AT IRN(IP(J))
C  AND CONTAINS IW(J) INTEGERS,J=1,N. OTHER COMPONENTS OF IRN ARE ZERO.
C  LENGTH OF COMPRESSED FILE PLACED IN LROW IF REALS IS .TRUE. OR LCOL
C  OTHERWISE.
C  IF REALS IS .TRUE. ARRAY A CONTAINS A REAL FILE ASSOCIATED WITH IRN
C  AND THIS IS COMPRESSED TOO.
C  A,IRN,IP,IW,IA ARE INPUT/OUTPUT VARIABLES.
C  N,REALS ARE INPUT/UNCHANGED VARIABLES.
C
      DO 5 J=1,N
C STORE THE LAST ELEMENT OF ENTRY J IN IW(J) THEN OVERWRITE IT BY -J.
      NZ=IW(J)
      IF(NZ.LE.0)GO TO 5
      K=IP(J)+NZ-1
      IW(J)=IRN(K)
      IRN(K)=-J
5     CONTINUE
C KN IS THE POSITION OF NEXT ENTRY IN COMPRESSED FILE.
      KN=0
      IPI=0
      KL=LCOL
      IF(REALS)KL=LROW
C LOOP THROUGH THE OLD FILE SKIPPING ZERO (DUMMY) ELEMENTS AND
C     MOVING GENUINE ELEMENTS FORWARD. THE ENTRY NUMBER BECOMES
C     KNOWN ONLY WHEN ITS END IS DETECTED BY THE PRESENCE OF A NEGATIVE
C     INTEGER.
      DO 25 K=1,KL
      IF(IRN(K).EQ.0)GO TO 25
      KN=KN+1
      IF(REALS)A(KN)=A(K)
      IF(IRN(K).GE.0)GO TO 20
C END OF ENTRY. RESTORE IRN(K), SET POINTER TO START OF ENTRY AND
C     STORE CURRENT KN IN IPI READY FOR USE WHEN NEXT LAST ENTRY
C     IS DETECTED.
      J=-IRN(K)
      IRN(K)=IW(J)
      IP(J)=IPI+1
      IW(J)=KN-IPI
      IPI=KN
20    IRN(KN)=IRN(K)
25    CONTINUE
      IF(REALS)LROW=KN
      IF(.NOT.REALS)LCOL=KN
      RETURN
      END
C        MC20AD         25/11/75
C NAME MC20AD(R)                 CHECK
      SUBROUTINE MC20AD(NC,MAXA,A,INUM,JPTR,JNUM,JDISP)
C
      INTEGER INUM(MAXA),JNUM(MAXA)
      DOUBLE PRECISION A(MAXA),ACE,ACEP
      DIMENSION JPTR(NC)
C
C     ******************************************************************
C
      NULL=-JDISP
C**      CLEAR JPTR
      DO 60 J=1,NC
   60 JPTR(J)=0
C**      COUNT THE NUMBER OF ELEMENTS IN EACH COLUMN.
      DO 120 K=1,MAXA
      J=JNUM(K)+JDISP
      JPTR(J)=JPTR(J)+1
  120 CONTINUE
C**      SET THE JPTR ARRAY
      K=1
      DO 150 J=1,NC
      KR=K+JPTR(J)
      JPTR(J)=K
  150 K=KR
C
C**      REORDER THE ELEMENTS INTO COLUMN ORDER.  THE ALGORITHM IS AN
C        IN-PLACE SORT AND IS OF ORDER MAXA.
      DO 230 I=1,MAXA
C        ESTABLISH THE CURRENT ENTRY.
      JCE=JNUM(I)+JDISP
      IF(JCE.EQ.0) GO TO 230
      ACE=A(I)
      ICE=INUM(I)
C        CLEAR THE LOCATION VACATED.
      JNUM(I)=NULL
C        CHAIN FROM CURRENT ENTRY TO STORE ITEMS.
      DO 200 J=1,MAXA
C        CURRENT ENTRY NOT IN CORRECT POSITION.  DETERMINE CORRECT
C        POSITION TO STORE ENTRY.
      LOC=JPTR(JCE)
      JPTR(JCE)=JPTR(JCE)+1
C        SAVE CONTENTS OF THAT LOCATION.
      ACEP=A(LOC)
      ICEP=INUM(LOC)
      JCEP=JNUM(LOC)
C        STORE CURRENT ENTRY.
      A(LOC)=ACE
      INUM(LOC)=ICE
      JNUM(LOC)=NULL
C        CHECK IF NEXT CURRENT ENTRY NEEDS TO BE PROCESSED.
      IF(JCEP.EQ.NULL) GO TO 230
C        IT DOES.  COPY INTO CURRENT ENTRY.
      ACE=ACEP
      ICE=ICEP
  200 JCE=JCEP+JDISP
C
  230 CONTINUE
C
C**      RESET JPTR VECTOR.
      JA=1
      DO 250 J=1,NC
      JB=JPTR(J)
      JPTR(J)=JA
  250 JA=JB
      RETURN
      END
      SUBROUTINE MC20BD(NC,MAXA,A,INUM,JPTR)
      DOUBLE PRECISION A(MAXA),ACE
      INTEGER INUM(MAXA)
      DIMENSION JPTR(NC)
C
C     ******************************************************************
C
      KMAX=MAXA
      DO 30 JJ=1,NC
      J=NC+1-JJ
      KLO=JPTR(J)+1
      IF(KLO.GT.KMAX)GO TO 30
      KOR=KMAX
      DO 25 KDUMMY=KLO,KMAX
C ITEMS KOR, KOR+1, .... ,KMAX ARE IN ORDER
      ACE=A(KOR-1)
      ICE=INUM(KOR-1)
      DO 10 K=KOR,KMAX
      IK=INUM(K)
      IF(IABS(ICE).LE.IABS(IK))GO TO 20
      INUM(K-1)=IK
10    A(K-1)=A(K)
      K=KMAX+1
20    INUM(K-1)=ICE
      A(K-1)=ACE
25    KOR=KOR-1
C        NEXT COLUMN
30    KMAX=KLO-2
      RETURN
      END
C
C     END OF THE STANDARD VERSION OF THE LA05 ROUTINES.
C**************************************************************
