package Language::INTERCAL::Interface::X;

# Graphical (Gtk2) interface for sick and intercalc

# This file is part of CLC-INTERCAL

# Copyright (c) 2006 Claudio Calvelli, all rights reserved.

# CLC-INTERCAL is copyrighted software. However, permission to use, modify,
# and distribute it is granted provided that the conditions set out in the
# licence agreement are met. See files README and COPYING in the distribution.

use strict;
use vars qw($PERVERSION);
$PERVERSION = "CLC-INTERCAL INTERCAL/Interface/X.pm 1.-94.-4";

use Carp;
use Gtk2;

use Language::INTERCAL::Exporter '1.-94.-4';
use Language::INTERCAL::Interface::common '1.-94.-4';
use vars qw(@ISA);
@ISA = qw(Language::INTERCAL::Interface::common);

my %keymap = (
    ' ' => 'space',
    '!' => 'exclam',
    '"' => 'quotedbl',
    '#' => 'numbersign',
    "'" => 'apostrophe',
    '$' => 'dollar',
    '%' => 'percent',
    '&' => 'ampersand',
    '(' => 'parenleft',
    ')' => 'parenright',
    '*' => 'asterisk',
    '+' => 'plus',
    ',' => 'comma',
    '-' => 'minus',
    '.' => 'period',
    '/' => 'slash',
    ':' => 'colon',
    ';' => 'semicolon',
    '<' => 'less',
    '=' => 'equal',
    '>' => 'greater',
    '?' => 'question',
    '@' => 'at',
    '[' => 'bracketleft',
    '\\' => 'backslash',
    ']' => 'bracketright',
    '^' => 'asciicircum',
    '_' => 'underscore',
    '`' => 'grave',
    '{' => 'braceleft',
    '|' => 'bar',
    '}' => 'braceright',
    '~' => 'asciitilde',
    '' => 'cent',
    '' => 'yen',
    'Enter' => 'KP_Enter',
    # XXX
);

sub new {
    @_ == 1 or croak "Usage: Language::INTERCAL::Interface::X->new";
    my ($class) = @_;
    $ENV{DISPLAY} or return undef;
    Gtk2->init();
    my $X = bless {
	keylist => {},
    }, $class;
    $X->_initialise;
    $X;
}

sub is_interactive { 1 }

sub window {
    @_ == 4 or croak "Usage: X->window(NAME, DESTROY, DEFINITION)";
    my ($X, $name, $destroy, $def) = @_;
    my $window = Gtk2::Window->new();
    $window->set_title($name);
    $X->{_accel} = Gtk2::AccelGroup->new();
    my $content = $X->_parse_def(@$def);
    $window->add($content);
    $window->add_accel_group($X->{_accel});
    delete $X->{_accel};
    $window->signal_connect(delete_event => sub { ! &$destroy });
    $window->show_all;
    $window;
}

sub show {
    @_ == 2 or croak "Usage: X->show(WINDOW)";
    my ($X, $window) = @_;
    $window->deiconify;
    $window->show_all;
    $window;
}

sub start {
    @_ == 1 or croak "Usage: X->start";
    my ($X) = @_;
    Gtk2::Gdk::Event->handler_set(\&_event, $X);
    Gtk2->main_iteration() while Gtk2->events_pending();
}

sub run {
    @_ == 1 or croak "Usage: X->run";
    my ($X) = @_;
    # why doesn't Gtk provide a way to handle mouse button events? Or if it
    # does, why don't they document it?
    Gtk2::Gdk::Event->handler_set(\&_event, $X);
    Gtk2->main;
}

sub pending_events {
    @_ == 1 or croak "Usage: X->pending_events";
    return Gtk2->events_pending();
}

sub update {
    @_ == 1 or croak "Usage: X->update";
    my ($X) = @_;
    Gtk2->main_iteration() while Gtk2->events_pending();
}

sub _event {
    my ($event, $X) = @_;
    if ($event->type eq 'button-press' && $event->button == 3) {
	my $clipboard = Gtk2::Clipboard->get(Gtk2::Gdk::Atom->new('PRIMARY'));
	return unless $clipboard->wait_is_text_available;
	my $text = $clipboard->wait_for_text;
	while ($text ne '') {
	    my $k = substr($text, 0, 1, '');
	    &{$X->{keylist}{$k}} if exists $X->{keylist}{$k};
	    Gtk2->main_iteration() while Gtk2->events_pending();
	}
	return;
    }
    Gtk2->main_do_event($event);
}

sub _set_text {
    my ($X, $text, $value) = @_;
    $text->set_label($value);
}

sub _get_text {
    @_ == 2 or croak "Usage: X->get_text(NAME)";
    my ($X, $text) = @_;
    $text->get_label();
}

sub close {
    @_ == 2 or croak "Usage: X->close(WINDOW)";
    my ($X, $window) = @_;
    $window->destroy;
}

sub enable {
    @_ == 2 or croak "Usage: X->enable(BUTTON)";
    my ($curse, $window) = @_;
    $window->set_relief('normal');
}

sub disable {
    @_ == 2 or croak "Usage: X->disable(BUTTON)";
    my ($curse, $window) = @_;
    $window->set_relief('none');
}

sub _make_table {
    my ($X, $rows, $cols, $border, $elements) = @_;
    my $table = Gtk2::Table->new($rows, $cols);
    $table->set_border_width($border);
    for my $te (@$elements) {
	my ($e, $c0, $c1, $r0, $r1) = @$te;
	$table->attach_defaults($e, $c0, $c1, $r0, $r1);
    }
    $table;
}

sub _make_text {
    my ($X, $value, $align, $size) = @_;
    my $text = Gtk2::Label->new($value);
    $text->set_width_chars($size) if $size;
    $text->set_max_width_chars($size) if $size;
    $text->set_alignment(0.0, 0.0) if $align =~ /^l/i;
    $text->set_alignment(0.5, 0.0) if $align =~ /^c/i;
    $text->set_alignment(1.0, 0.0) if $align =~ /^r/i;
    $text;
}

sub _make_key {
    my ($X, $label, $action, $keys) = @_;
    my $key = Gtk2::Button->new_with_label($label);
    $key->signal_connect(clicked => $action);
    for my $k (@$keys) {
	$X->{keylist}{$k} = $action;
	$k =~ s/^([\c@-\c_])$/sprintf("<control>%c", 64 + ord($1))/e;
	$k =~ s/^([A-Z])$/sprintf("<shift>%c", 32 + ord($1))/e;
	$k = $keymap{$k} if exists $keymap{$k};
	my ($a, $m) = Gtk2::Accelerator->parse($k);
die "k=$k a=$a m=$m\n" if $a == 0; # XXX
	my $fs = sub { $key->activate };
	$X->{_accel}->connect($a, $m, [], $fs);
    };
    $key;
}

1;
